<?php
/**
 * Plugin Name: Hospedar Paginas Exito/Error Webpay Version REST
 * Plugin URI: https://www.hospedar.cl
 * Description: Despliegue de paginas de exito y error para pago por webpay
 * Version: 0.3
 * Text Domain: hospedar-webpay
 * Author: Cesar Villalobos
 * Author URI: https://www.hospedar.cl
 */
 
function hospedar_pagina_exito($atts='') {
    
    if($_GET['t']){
	
	    $datosCompra = getDataTrx($_GET['t']);
	    
	    if($datosCompra['buyOrder']){

					if($datosCompra['datosTransaccion']->installments_number > 0) {
						$ContentCuotas = "
						<tr>
					    	<th>Numero de Cuotas</th>
					    	<td>" . $datosCompra['datosTransaccion']->installments_number . "</td>
					  	</tr>
						<tr>
						  <th>Valor de cada Cuota</th>
						  <td>" . $datosCompra['datosTransaccion']->installments_amount . "</td>
						</tr>";
					}else{
						$ContentCuotas = "";
					}
	        
	            	$Content = "<h2 class='webpay-tituloDetallePago'>Detalles del Pago</h2>
					<table class='webpay-detallePago'>
					  <tr>
					    <th>Respuesta de la Transacci&oacute;n</th>
					    <td>" . $datosCompra['transaction_response'] . "</td>
					  </tr>
					  <tr>
					    <th>Orden de Compra</th>
					    <td>" . $datosCompra['buyOrder'] . "</td>
					  </tr>
					  <tr>
					    <th>C&oacute;digo de Autorizaci&oacute;n</th>
					    <td>" . $datosCompra['datosTransaccion']->authorization_code . "</td>
					  </tr>
					  <tr>
					    <th>Fecha Transacci&oacute;n</th>
					    <td>" . $datosCompra['date_accepted']->format('d-m-Y') . "</td>
					  </tr>
					  <tr>
					    <th>Hora Transacci&oacute;n</th>
					    <td>" . $datosCompra['date_accepted']->format('H:i:s') . "</td>
					  </tr>
					  <tr>
					    <th>Numero Tarjeta</th>
					    <td>" . $datosCompra['datosTransaccion']->card_number . "</td>
					  </tr>
					  <tr>
					    <th>Tipo de Pago</th>
					    <td>" . $datosCompra['paymentType'] . "</td>
					  </tr>
					  <tr>
					    <th>Tipo de Cuota</th>
					    <td>" . $datosCompra['paymentTypeDes'] . "</td>
					  </tr>
					  <tr>
					    <th>Monto Compra</th>
					    <td>" . "$ " . $datosCompra['amount'] . "</td>
					  </tr>
					  $ContentCuotas
					</table>";	

	        
	    }else{
	        $Content = "<h2 class='webpay-tituloDetallePago'>No hemos encontrado la transacci&oacute;n</h2>";
	    }
	

    }else{
        $Content = "<h2 class='webpay-tituloDetallePago'>No hemos encontrado la transacci&oacute;n</h2>";
    }	
	 
    return $Content;
}

function hospedar_pagina_error($atts='') {
    
    if($_GET['t']){
 
    	$datosCompra = getDataTrx($_GET['t'], false);

		if($_GET['c']){

			if($_GET['c'] == 'aborted'){

				$Content = "<h2 class='webpay-tituloDetallePago'>Transacci&oacute;n abortada</h2>
		
				<p class='webpay-bajadaErrorPago'>
					Ho hay problema, si a&uacute;n quieres reservar intenta nuevamente.  O de lo contrario cont&aacute;ctanos y te ayudaremos.
				</p>
	
				<table class='webpay-detallePago'>
				  <tr>
					<th>Respuesta de la Transacci&oacute;n</th>
					<td>" . $datosCompra['transaction_response'] . "</td>
				  </tr>
				  <tr>
					<th>Orden de Compra</th>
					<td>" . $datosCompra['buyOrder'] . "</td>
				  </tr>
				  <tr>
					<th>Monto Pendiente de Pago</th>
					<td>" . "$ " . $datosCompra['amount'] . "</td>
				  </tr>
				</table>";   

			}else if($_GET['c'] == 'timeout'){

				$Content = "<h2 class='webpay-tituloDetallePago'>Transacci&oacute;n Caducada</h2>
		
				<p class='webpay-bajadaErrorPago'>
					Ho hay problema, si a&uacute;n quieres reservar intenta nuevamente.  O de lo contrario cont&aacute;ctanos y te ayudaremos.
				</p>
	
				<table class='webpay-detallePago'>
				  <tr>
					<th>Respuesta de la Transacci&oacute;n</th>
					<td>" . $datosCompra['transaction_response'] . "</td>
				  </tr>
				  <tr>
					<th>Orden de Compra</th>
					<td>" . $datosCompra['buyOrder'] . "</td>
				  </tr>
				  <tr>
					<th>Monto Pendiente de Pago</th>
					<td>" . "$ " . $datosCompra['amount'] . "</td>
				  </tr>
				</table>"; 

			}

		}else{

			if($datosCompra['buyOrder']){
    	
				$Content = "<h2 class='webpay-tituloDetallePago'>Detalles de la transacci&oacute;n fallada</h2>
		
							<p class='webpay-bajadaErrorPago'>Las posibles causas para las transacciones rechazadas son:
						<ul class='webpay-detalleErrorPago'>
						<li>Error en el ingreso de los datos de su tarjeta de Crédito o Débito (fecha y/o c&oacute;digo de seguridad).</li>
						<li>Su tarjeta de Cr&eacute;dito o D&eacute;bito no cuenta con saldo suficiente.</li>
						<li>Tarjeta a&uacute;n no habilitada en el sistema financiero.</li>
						</ul>
						</p>
		
							<table class='webpay-detallePago'>
							  <tr>
								<th>Respuesta de la Transacci&oacute;n</th>
								<td>" . $datosCompra['transaction_response'] . "</td>
							  </tr>
							  <tr>
								<th>Orden de Compra</th>
								<td>" . $datosCompra['buyOrder'] . "</td>
							  </tr>
							  <tr>
								<th>Fecha Transacci&oacute;n</th>
								<td>" . $datosCompra['date_accepted']->format('d-m-Y') . "</td>
							  </tr>
							  <tr>
								<th>Hora Transacci&oacute;n</th>
								<td>" . $datosCompra['date_accepted']->format('H:i:s') . "</td>
							  </tr>
							  <tr>
								<th>Monto Compra</th>
								<td>" . "$ " . $datosCompra['amount'] . "</td>
							  </tr>
							</table>";   
							
			}else{
				$Content = "<h2 class='webpay-tituloDetallePago'>No hemos encontrado la transacci&oacute;n</h2>";
			}

		}

        
    }else{
        $Content = "<h2 class='webpay-tituloDetallePago'>No hemos encontrado la transacci&oacute;n</h2>";
    }
	

	 
    return $Content;
}


function getDataTrx($token, $exito = true){
    
    $webpayUrlSrv  = getEndpoint();
    $urlWebpayApi = $webpayUrlSrv  . "/api/v2/api_v2.php/trx_webpay/" . $token;


    $datosDevueltos = array();

    $datosRetornados = get_web_page($urlWebpayApi);

    $datosTransaccion = json_decode($datosRetornados["content"]);
    $datosDevueltos['datosTransaccion'] = $datosTransaccion;

    if ($datosTransaccion->response_code == 0) {
    	$datosDevueltos['transactionResponse'] = "Transacci&oacute;n Aprobada";
    } else {
    	$datosDevueltos['transactionResponse'] = "Transacci&oacute;n Rechazada";
    }
    
    $transactionDate = isset($datosTransaccion->transaction_date) ? $datosTransaccion->transaction_date : null;
    $date_accepted = new DateTime($transactionDate);

    $tZone = new DateTimeZone("America/Santiago");
    $date_accepted->setTimezone($tZone);
    
    $datosDevueltos['date_accepted'] = $date_accepted;
    
    //$splitOrder = explode("-", $datosTransaccion->buyOrder);
    $buyOrder =  $datosTransaccion->buy_order;//$splitOrder[1];
    $datosDevueltos['buyOrder'] = $buyOrder;
    
    $amount = number_format($datosTransaccion->amount, 0, ',', '.');
    $datosDevueltos['amount'] = $amount;
    
    if($exito){
        
        if ($datosTransaccion->payment_type_code == "VD") {
        	$paymentType = "Débito";
        } elseif($datosTransaccion->payment_type_code == "VP") {
        	$paymentType = "Prepago";
        } else {
        	$paymentType = "Crédito";
        }
        
        $datosDevueltos['paymentType'] = $paymentType;
        
        
        $paymentTypeDes = "Sin Cuotas";
        
        switch ($datosTransaccion->payment_type_code) {
        	case "VP":
        		$paymentTypeDes = "Venta Prepago";
        		break;
        	case "VD":
        		$paymentTypeDes = "Venta Deb&iacute;to";
        		break;
        	case "VN":
        		$paymentTypeDes = "Venta Normal";
        		break;
        	case "VC":
        		$paymentTypeDes = "Venta en cuotas";
        		break;
        	case "SI":
        		$paymentTypeDes = "3 cuotas sin inter&eacute;s";
        		break;
        	case "S2":
        		$paymentTypeDes = "2 cuotas sin inter&eacute;s";
        		break;
        	 case "NC":
        		$paymentTypeDes = "N cuotas sin inter&eacute;s";
        		break;
        }
        
        $datosDevueltos['paymentTypeDes'] = $paymentTypeDes;
        
    }
    
    return  $datosDevueltos;
    
}

function getEndpoint(){

	$url = preg_replace("(^https?://)", "", $_SERVER['HTTP_HOST'] );

	if($url == 'localhost' || $url == 'demo.hospedar.cl'){
		return "https://webpayrest.integracion.y3.cl";
	}

    $dominio = explode("." ,$url);
	$dominioPrincipal = "y3";
    
    $cantidad = 1;
    while ($cantidad <= 2){
        $subDominio = array_pop($dominio);
        $cantidad ++;
    }

	if($subDominio == 'y3'){
        $subDominio = 'integracion';
    }else{
		if($subDominio == 'y1'){
			$subDominio = array_pop($dominio);
		}
		$dominioPrincipal = "y1";
	}

    return "https://webpayrest.$subDominio.$dominioPrincipal.cl";
}


function get_web_page( $url )
{
		$options = array(
			CURLOPT_RETURNTRANSFER => true,     // return web page
			CURLOPT_HEADER         => false,    // don't return headers
			CURLOPT_FOLLOWLOCATION => true,     // follow redirects
			CURLOPT_ENCODING       => "",       // handle all encodings
			CURLOPT_USERAGENT      => "hospedar 3.4.7", // who am i
			CURLOPT_AUTOREFERER    => true,     // set referer on redirect
			CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
			CURLOPT_TIMEOUT        => 120,      // timeout on response
			CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
			CURLOPT_SSL_VERIFYPEER => false     // Disabled SSL Cert checks
		);

		$ch      = curl_init( $url );
		curl_setopt_array( $ch, $options );
		$content = curl_exec( $ch );
		$err     = curl_errno( $ch );
		$errmsg  = curl_error( $ch );
		$header  = curl_getinfo( $ch );
		curl_close( $ch );

		$header['errno']   = $err;
		$header['errmsg']  = $errmsg;
		$header['content'] = $content;
		return $header;
}