<?php
if (!defined("ROOT_PATH")) {
    header("HTTP/1.1 403 Forbidden");
    exit;
}
require_once dirname(__FILE__) . '/pjApps.class.php';
class pjDispatcher extends pjObject
{
    public $ClassFile = __FILE__;
    private $controller;
    public $viewPath;
    public $templateName;
    public function __construct()
    {
    }
    
    public function dispatch(&$request, $options)
    {
        
        
        
        
        
        $request    = pjDispatcher::sanitizeRequest($request);
        $controller = $this->createController($request);
        if ($controller !== false) {
            if (is_object($controller)) {
                $this->controller =& $controller;
                $tpl =& $controller->tpl;
                $controller->body =& $_POST;
                $controller->query =& $_GET;
                $controller->files =& $_FILES;
                $controller->session =& $_SESSION;
                if (isset($request['action'])) {
                    $action = $request['action'];
                    if (method_exists($controller, $action)) {
                        $controller->beforeFilter();
                        if (isset($request['params'])) {
                            $controller->params = $request['params'];
                        }
                        $result = $controller->$action();
                        $controller->afterFilter();
                        $controller->beforeRender();
                        $tpl['query']   = $controller->query;
                        $tpl['body']    = $controller->body;
                        $tpl['session'] = $controller->session;
                        $template       = $action;
                        if (!is_null($controller->template)) {
                        }
                        $content_tpl = $this->getTemplate($request);
                    } else {
                        printf('Method <strong>%s::%s</strong> didn\'t exists', $request['controller'], $request['action']);
                        exit;
                    }
                } else {
                    $request['action'] = 'pjActionIndex';
                    $controller->beforeFilter();
                    $controller->pjActionIndex();
                    $controller->afterFilter();
                    $controller->beforeRender();
                    $tpl['query']   = $controller->query;
                    $tpl['body']    = $controller->body;
                    $tpl['session'] = $controller->session;
                    $content_tpl    = $this->getTemplate($request);
                }
                if (in_array('return', $options)) {
                    return $result;
                } elseif (in_array('output', $options)) {
                    return $tpl;
                } else {
                    if (!is_file($content_tpl)) {
                        echo 'template not found';
                        exit;
                    }
                    if ($controller->getAjax()) {
                        require $content_tpl;
                        $controller->afterRender();
                    } else {
                        $layoutFile = PJ_VIEWS_PATH . 'pjLayouts/' . $controller->getLayout() . '.php';
                        if (is_file($layoutFile)) {
                            require $layoutFile;
                        } else {
                            if (null !== ($plugin = pjObject::getPlugin($request['controller']))) {
                                $layoutFile = pjObject::getConstant($plugin, 'PLUGIN_VIEWS_PATH') . 'pjLayouts/' . $controller->getLayout() . '.php';
                                if (is_file($layoutFile)) {
                                    require $layoutFile;
                                }
                            }
                        }
                        $controller->afterRender();
                    }
                }
            } else {
                echo 'controller not is object';
                exit;
            }
        } else {
            if (isset($request['controller'])) {
                exit(sprintf('cla' . 'ss <strong>%s</strong> didn\'t exists', $request['controller']));
            } else {
                exit('cla' . 'ss didn\'t exists');
            }
        }
    }
    
    
    public function loadController($request)
    {
        
        
        
        
        $request        = pjDispatcher::sanitizeRequest($request);
        $this->viewPath = PJ_VIEWS_PATH . $request['controller'] . '/';
        if (null !== ($plugin = pjObject::getPlugin($request['controller']))) {
            $this->viewPath = PJ_PLUGINS_PATH . $plugin . '/views/' . $request['controller'] . '/';
        }
        return $this;
    }
    
    
    public function createController($request)
    {
        
        
        
        
        $request = pjDispatcher::sanitizeRequest($request);
        $this->loadController($request);
        if (class_exists($request['controller'])) {
            return new $request['controller'];
        }
        return false;
    }
    
    
    public function getController()
    {
        
        
        
        
        return $this->controller;
    }
    
    
    public function getTemplate($request)
    {
        
        
        $request = pjDispatcher::sanitizeRequest($request);
        if (!is_null($this->controller->template)) {
            if (!strpos($this->controller->template['template'], ":")) {
                return PJ_VIEWS_PATH . $this->controller->template['controller'] . '/' . $this->controller->template['template'] . '.php';
            } else {
                list($pluginController, $view) = explode(":", $this->controller->template['template']);
                return pjObject::getConstant($this->controller->template['controller'], 'PLUGIN_VIEWS_PATH') . '/' . $pluginController . '/' . $view . '.php';
            }
        } else {
            return $this->viewPath . $request['action'] . '.php';
        }
    }
    
    
    private static function sanitizeRequest($request)
    {
        
        
        
        $pattern      = '/[^a-zA-Z0-9\_]/';
        if (isset($request['controller'])) {
            $request['controller'] = preg_replace($pattern, '', basename($request['controller']));
        }
        if (isset($request['action'])) {
            $request['action'] = preg_replace($pattern, '', basename($request['action']));
        }
        return $request;
    }
    
    
    private static function sanitizeOutput($buffer)
    {
        
        
        
        $search       = array(
            '/\>[^\S ]+/s',
            '/[^\S ]+\</s',
            '/(\s)+/s'
        );
        $replace      = array(
            '>',
            '<',
            '\\1'
        );
        return preg_replace($search, $replace, $buffer);
    }
}
?>