<?php
require('app/config/config.inc.php');

$link = new mysqli(PJ_HOST, PJ_USER, PJ_PASS, PJ_DB);

// Check connection
if($link === false){
    die("ERROR: Could not connect. " . mysqli_connect_error());
}

$consultaReservasNoSync = "SELECT * 
FROM ". PJ_PREFIX . "hotel_booking_bookings_rooms ro left join ". PJ_PREFIX . "hotel_booking_bookings bo on ro.booking_id=bo.id inner join ". PJ_PREFIX . "hotel_booking_rooms bor 
 ON ro.room_id = bor.id " .
" WHERE ro.room_number_id is not null 
AND bo.sync is null
AND bo.date_from > now() 
AND (bo.status = 'confirmed' or bo.status = 'pay_checkin') 
AND bor.avail_ota > 0
AND bor.wb_id is not null";



$consultaReservasSyncCancelled = "SELECT * 
FROM ". PJ_PREFIX . "hotel_booking_bookings_rooms ro left join ". PJ_PREFIX . "hotel_booking_bookings bo on ro.booking_id=bo.id inner join ". PJ_PREFIX . "hotel_booking_rooms bor 
 ON ro.room_id = bor.id " .
" WHERE ro.room_number_id is not null 
AND bo.sync is not null
AND bo.date_from > now() 
AND (bo.status = 'cancelled') 
AND bor.avail_ota > 0
AND bor.wb_id is not null";

$objJson = new stdClass();
$objJson->rooms = array();


$bookingIdToUpdateSync = array();

//echo $consultaReservasNoSync;
//echo "<hr>";
if($result = mysqli_query($link, $consultaReservasNoSync)) {
    //$cantidadReservasConError += mysqli_num_rows($result); 
    if(mysqli_num_rows($result) > 0){
       
        while($row = mysqli_fetch_array($result)){
            $bookingIdToUpdateSync[] = $row['booking_id'];
            
            $objRoom = new stdClass();
            $objRoom->id = intval($row['wb_id']);
            
            
            $days_array =createDateRangeArray($row['date_from'],$row['date_to']);
            array_pop($days_array);
            $avail_ota = --$row['avail_ota'];
            
            
            foreach($days_array as $dayProcessed){
                $objDay = new stdClass();
                $objDay->date = datetowubook($dayProcessed);
                $objDay->avail = $avail_ota;       
                $objRoom->days[] = $objDay;
            }
            
            
            
            $objJson->rooms[] = $objRoom;

        }

        // Free result set
        mysqli_free_result($result);
    } /*else{
        echo "No records matching your query were found.";
    }*/
} else{
    echo "ERROR: Could not able to execute $consultaReservasNoSync. " . mysqli_error($link);
}

// cancelled reservations

if($result = mysqli_query($link, $consultaReservasSyncCancelled)) {
    //$cantidadReservasConError += mysqli_num_rows($result); 
    if(mysqli_num_rows($result) > 0){
       
        while($row = mysqli_fetch_array($result)){
            $bookingIdToUpdateSync[] = $row['booking_id'];
            
            $objRoom = new stdClass();
            $objRoom->id = intval($row['wb_id']);
            
            
            $days_array =createDateRangeArray($row['date_from'],$row['date_to']);
            array_pop($days_array);
            $avail_ota = $row['avail_ota'];

            /*if($avail_ota > $row['avail_ota']){
                $avail_ota = $row['avail_ota'];
            }*/
            
            foreach($days_array as $dayProcessed){
                $objDay = new stdClass();
                $objDay->date = datetowubook($dayProcessed);
                $objDay->avail = $avail_ota;       
                $objRoom->days[] = $objDay;
            }
            
            
            
            $objJson->rooms[] = $objRoom;

        }

        // Free result set
        mysqli_free_result($result);
    } /*else{
        echo "No records matching your query were found.";
    }*/
} else{
    echo "ERROR: Could not able to execute $consultaReservasNoSync. " . mysqli_error($link);
}



//var_dump($bookingIdToUpdateSync);

//echo json_encode($objJson, JSON_UNESCAPED_SLASHES);


if(count($bookingIdToUpdateSync)>0){
    
    if(PJ_WB_TOKEN){

        $curl = curl_init();
    	
    	curl_setopt_array($curl, array(
    	CURLOPT_URL => "http://sync.ybt.cl:4000/batch/availability/sparse",
    	CURLOPT_RETURNTRANSFER => true,
    	CURLOPT_ENCODING => "",
    	CURLOPT_MAXREDIRS => 10,
    	CURLOPT_TIMEOUT => 0,
    	CURLOPT_FOLLOWLOCATION => true,
    	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    	CURLOPT_CUSTOMREQUEST => "PUT",
    	CURLOPT_POSTFIELDS => json_encode($objJson, JSON_UNESCAPED_SLASHES),
    	CURLOPT_HTTPHEADER => array(
    				"Authorization: Bearer " . PJ_WB_TOKEN,
    				"Content-Type: application/json"
    			),
    	));
    						
    	$response = curl_exec($curl);
    	file_put_contents('./log_sync_avail_'.date("j.n.Y").'.log', var_export($response, true) . "\n", FILE_APPEND);
    						
    	curl_close($curl);
    }
    
    $listUpdatedBook = implode(",", $bookingIdToUpdateSync);
    $updateBookingSyncQuery = "UPDATE ". PJ_PREFIX . "hotel_booking_bookings SET sync = now() WHERE id in ($listUpdatedBook)";
    
    echo $updateBookingSyncQuery;
    
    if($result = mysqli_query($link, $updateBookingSyncQuery)) {
        echo "sync ok";
    }
}



function datetowubook($date){

return substr($date,8,2).'/'.substr($date,5,2).'/'.substr($date,0,4);    

}

function createDateRangeArray($strDateFrom,$strDateTo)
{
    // takes two dates formatted as YYYY-MM-DD and creates an
    // inclusive array of the dates between the from and to dates.

    // could test validity of dates here but I'm already doing
    // that in the main script

    $aryRange = [];

    $iDateFrom = mktime(1, 0, 0, substr($strDateFrom, 5, 2), substr($strDateFrom, 8, 2), substr($strDateFrom, 0, 4));
    $iDateTo = mktime(1, 0, 0, substr($strDateTo, 5, 2), substr($strDateTo, 8, 2), substr($strDateTo, 0, 4));

    if ($iDateTo >= $iDateFrom) {
        array_push($aryRange, date('Y-m-d', $iDateFrom)); // first entry
        while ($iDateFrom<$iDateTo) {
            $iDateFrom += 86400; // add 24 hours
            array_push($aryRange, date('Y-m-d', $iDateFrom));
        }
    }
    return $aryRange;
}

