<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjWebpay extends pjWebpayAppController
{


	private $defaultEndpointWebpay = '/api/v1/api_v1.php/trx_webpay/';
                                            
	public function pjActionConfirm()
	{
		$params = $this->getParams();

		$resp = array();		


		if (isset($params['id'], $params['webpay_url_srv']) && !empty($params['id']) && !empty($params['webpay_url_srv']))
		{

			$urlWebpayApi = $params['webpay_url_srv'] . $this->defaultEndpointWebpay . $params['id'];

			$datosRetornados = pjUtil::get_web_page($urlWebpayApi);
			$datosTransaccion = json_decode($datosRetornados["content"]);

	    	if ($datosTransaccion->response_code != NULL)
	    	{
	    	    $statusMsg = "";
				$statusFlag = false;
				
				if($datosTransaccion->response_code == 0){
					$statusFlag = true;
					$statusMsg .= $datosTransaccion->response_code ."|";
				}
	    	    
	    	    
	        	if ($statusFlag)
	        	{
					// Transaction approved!
	        		$this->log('pjWebpay | Transaction approved!');
					$resp['transaction_id'] = $params['token'];
					$resp['status'] = 'OK';
				} else {
					// There was a problem.
					$this->log('pjWebpay | Error - ' . sprintf('Reason text: %s | Code: %s', $statusMsg,$datosTransaccion->response_code));
					$resp['response_code'] = $datosTransaccion->response_code;
					$resp['response_reason_text'] = $datosTransaccion->response_code;
					$resp['status'] = 'FAIL';
				}
			} else {
				$this->log('pjWebpay | Servicio No Responde.');
				$resp['response_reason_text'] = "No responde servicio";
				$resp['status'] = 'FAIL';
			}
		} else {
			$this->log('pjWebpay | Missing or empty parameters: id, webpay_url_srv.');
			$resp['response_reason_text'] = "Missing or empty parameters";
			$resp['status'] = 'FAIL';
		}

		return $resp;
	}
	
	public function pjActionForm()
	{
		$this->setAjax(true);
		//KEYS:
		//-------------
		//name
		//id
		//timezone
		//transkey
		//x_login
		//x_description
		//x_amount
		//x_invoice_num
		//x_receipt_link_url
		//x_relay_url
		//submit
		//submit_class
		//target
		$params = $this->getParams();

		$params['tbk_monto'] = (int) number_format($params['amount'], 0, ',', '');
		$params['tbk_orden_compra'] = "HD-" . $params['item_name'];
		$params['tbk_id_sesion'] = "HD-" . $params['custom'];
		$params['tbk_url_exito'] = $params['notify_url'];
		$params['tbk_url_fracaso'] = $params['error_url'];

		$tokenData['tbk_monto'] = $params['tbk_monto'];
		$tokenData['tbk_orden_compra'] = $params['tbk_orden_compra'];
		$tokenData['tbk_id_sesion'] = $params['tbk_id_sesion'];
		$tokenData['tbk_url_exito'] = $params['tbk_url_exito'];
		$tokenData['tbk_url_fracaso'] = $params['tbk_url_fracaso'];

		$encryption = openssl_encrypt(json_encode($tokenData),"AES-128-CTR",
		"H05P3D4R-34-w3bp4y", 0, '2217121980180033');

		$params['tbk_token'] = $encryption; 



		$this->set('arr', $params);
	}
}
?>