<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjQvo extends pjQvoAppController
{
	private $currencies = array(
		'AUD',
		'GBP',
		'CAD',
		'DKK',
		'EUR',
		'NZD',
		'NOK',
		'PLN',
		'SEK',
		'CHF',
		'USD',
	);
	
	public function pjActionGetCurrencies()
	{
		return $this->currencies;
	}
	
	public function pjActionCheckCurrency()
	{
		$params = $this->getParams();
		
		if (!isset($params['currency']) || empty($params['currency']))
		{
			return array('status' => 'ERR', 'code' => 100, 'text' => 'Missing or empty \'currency\' parameter');
		}
		
		$currency = strtoupper($params['currency']);
		
		if (!in_array($currency, $this->currencies))
		{
			return array(
				'status' => 'ERR', 
				'code' => 101, 
				'text' => sprintf(__('plugin_authorize_currency_not_supported', true), $currency),
				'currency' => $currency,
				'currencies' => $this->currencies,
			);
		}
		
		return array(
			'status' => 'OK', 
			'code' => 200, 
			'text' => sprintf(__('plugin_authorize_currency_supported', true), $currency),
			'currency' => $currency,
			'currencies' => $this->currencies,
		);
	}
                                            
	public function pjActionConfirm()
	{
		$params = $this->getParams();
		
		
		$resp = array();
		
		if (isset($params['qvo_token'], $params['qvo_url_srv']) &&
			!empty($params['qvo_token']) && !empty($params['qvo_url_srv']))
		{
            $dataAuth = explode("/", $params['qvo_token']);
    				    $datosPago = array(
        				                      array( "url" =>  $params['qvo_url_srv'] . '/api/login_check',
        				                             "type"  => "auth",
        				                             "post" => array('_username'=>$dataAuth[0],'_password'=>$dataAuth[1])
        				                      ),
        				                      array( "url" => $params['qvo_url_srv'] . '/api/v1/transaction/id_producto/'. $params['id_producto'],
        				                             "type" => "get"
        				                      )
        				                      
        				    );
        				    
        				    
        				    $datosRetornados = pjUtil::initPaymentService($datosPago);
			
	    	if ($datosRetornados->code == 200)
	    	{
	    	    $statusMsg = "";
	    	    $statusFlag = false;
	    	    
	    	    foreach($datosRetornados->data as $data){
	    	        if($data->status == "successful"){
	    	            $statusFlag = true;
	    	        }
	    	        
	    	        $statusMsg .= $data->status ."|";
	    	    }
	    	    
	        	if ($statusFlag)
	        	{
					// Transaction approved!
	        		$this->log('pjQvo | Transaction approved!');
					$resp['transaction_id'] = $params['id_producto'];
					$resp['status'] = 'OK';
				} else {
					// There was a problem.
					$this->log('pjQvo | Error - ' . sprintf('Reason text: %s | Code: %s', $statusMsg,$datosRetornados->code));
					$resp['response_code'] = $datosRetornados->code;
					$resp['response_reason_text'] = $datosRetornados->data->status;
					$resp['status'] = 'FAIL';
				}
			} else {
				$this->log('pjQvo | Servicio No Responde.');
				$resp['response_reason_text'] = "No responde servicio";
				$resp['status'] = 'FAIL';
			}
		} else {
			$this->log('pjQvo | Missing or empty parameters: qvo_token, qvo_url_srv.');
			$resp['response_reason_text'] = "Missing or empty parameters";
			$resp['status'] = 'FAIL';
		}

		return $resp;
	}
	
	public function pjActionForm()
	{
		$this->setAjax(true);
		//KEYS:
		//-------------
		//name
		//id
		//timezone
		//transkey
		//x_login
		//x_description
		//x_amount
		//x_invoice_num
		//x_receipt_link_url
		//x_relay_url
		//submit
		//submit_class
		//target
		$this->set('arr', $this->getParams());
	}
}
?>