<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjPriceAppController extends pjPlugin
{
	public function __construct()
	{
		$this->setLayout('pjActionAdmin');
	}

	public static function getConst($const)
	{
		$registry = pjRegistry::getInstance();
		$store = $registry->get('pjPrice');
		return isset($store[$const]) ? $store[$const] : NULL;
	}

	public function isPriceReady()
	{
		$reflector = new ReflectionClass('pjPlugin');
		try {
			//Try to find out 'isPriceReady' into parent class
			$ReflectionMethod = $reflector->getMethod('isPriceReady');
			return $ReflectionMethod->invoke(new pjPlugin(), 'isPriceReady');
		} catch (ReflectionException $e) {
			//echo $e->getMessage();
			//If failed to find it out, denied access, or not :)
			return false;
		}
	}

	public function getForeignId()
	{
		$reflector = new ReflectionClass('pjPlugin');
		try {
			//Try to find out 'getForeignId' into parent class
			$ReflectionMethod = $reflector->getMethod('getForeignIdPrice');
			return $ReflectionMethod->invoke(new pjPlugin(), 'getForeignIdPrice');
		} catch (ReflectionException $e) {
			//echo $e->getMessage();
			//If failed to find it out, denied access, or not :)
			return parent::getForeignId();
		}
	}

	public function convertToMySQLNumber($number, $currency_format)
	{
		if($currency_format == 1 || $currency_format == 2)
		{
			if(strpos($number, ".") === false)
			{
				$number = preg_replace('/\s+/', '', $number);
				$number = preg_replace('/[,]/', '', $number);
				$number = (float) $number;
			}else{
				$number = preg_replace('/\s+/', '', $number);
				$number = preg_replace('/[,]/', '', $number);
				$number = (float) $number;
			}
		}else if($currency_format == 3 || $currency_format == 4){
			if(strpos($number, ",") === false)
			{
				if(strpos($number, ".") !== false)
				{
					$number = (float) $number;
				}else{
					$number = preg_replace('/\s+/', '', $number);
					$number = preg_replace('/[.]/', '', $number);
					$number = (float) $number;
				}
			}else{
				$number = preg_replace('/\s+/', '', $number);
				$number = preg_replace('/[.]/', '', $number);
				$number = preg_replace('/[,]/', '.', $number);
				$number = (float) $number;
			}
		}
		return $number;
	}

	public function converToCurrencyFormat($number, $currency_format)
	{
		switch ($currency_format) {
			case 1:
				$number = number_format($number, 2, '.', ',');
				break;
			case 2:
				$number = number_format($number, 2, '.', ' ');
				break;
			case 3:
				$number = number_format($number, 2, ',', '.');
				break;
			case 4:
				$number = number_format($number, 2, ',', ' ');
				break;
			default:
				$number = number_format($number, $this->option_arr['o_int_decimals'], $this->option_arr['o_dec_point'], '');


		}
		return $number;
	}
}
?>