<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	static public function getDiscount($amount, $room_id, $voucher=NULL)
	{
		if (is_null($voucher) || !isset($voucher) || empty($voucher))
		{
			return 0;
		}
		
		$discount = 0;
		if (isset($voucher['voucher_rooms']['all'])
			|| in_array($room_id, array_keys($voucher['voucher_rooms']))
		)
		{
			foreach ($voucher['voucher_rooms'] as $rid => $item)
			{
				if (!in_array($rid, array('all', $room_id)))
				{
					continue;
				}
				switch ($item['voucher_type'])
				{
					case 'percent':
						$discount = ($amount * $item['voucher_discount']) / 100;
						break;
					case 'amount':
						$discount = $item['voucher_discount'];
						break;
				}
			}
		}
		
		return $discount;
	}
	
	static public function getReferer()
	{
		if (isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SERVER['REDIRECT_URL']))
			{
				return $_SERVER['REDIRECT_URL'];
			}
		}
		
		if (isset($_SERVER['HTTP_REFERER']))
		{
			$pos = strpos($_SERVER['HTTP_REFERER'], "#");
			if ($pos !== FALSE)
			{
				// IE fix
				return substr($_SERVER['HTTP_REFERER'], 0, $pos);
			}
			return $_SERVER['HTTP_REFERER'];
		}
	}
	
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}
	
	static public function sortMultiDimensionsArray(&$array, $key)
	{
		$sorter = array();
		$ret = array();
		reset($array);
		foreach ($array as $k => $val) 
		{
			$sorter[$k]=$val[$key];
		}
		asort($sorter);
		foreach ($sorter as $k => $val) 
		{
			$ret[$k]=$array[$k];
		}
		$array=$ret;
	}
	
	public static function printNotice($title, $body, $convert = true, $close = true, $autoClose = false)
	{
		if (!$autoClose)
		{
			parent::printNotice($title, $body, $convert, $close);
		} else {
			?>
			<div class="notice-box notice-fancy">
				<div class="notice-middle">
					<span class="notice-success">&nbsp;</span>
					<div class="notice-content">
						<?php
						if (!empty($title))
						{
							printf('<div class="notice-title">%s</div>', $convert ? htmlspecialchars(stripslashes($title)) : stripslashes($title));
						}
						if (!empty($body))
						{
							printf('<div class="notice-body">%s</div>', $convert ? htmlspecialchars(stripslashes($body)) : stripslashes($body));
						}
						if ($close)
						{
							?><a href="#" class="notice-close"></a><?php
						}
						?>
						<div class="notice-progress-wrap">
							<div class="notice-progress"></div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}
	
	public static function toMomemtJS($format)
	{
		$f = str_replace(
				array('Y', 'm', 'n', 'd', 'j'),
				array('yyyy', 'mm', 'm', 'dd', 'd'),
				$format
		);
	
		return $f;
	}
	
	public static function initPaymentService($urlPostData)
	{
 
	    
	    $header = array('Content-Type: application/json');
	    
	    $jsonObj = NULL;
	    
	    foreach($urlPostData as $data){
    	    $ch = curl_init(); // Initialise cURL
    
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); // This will follow any redirects	   	        
	        curl_setopt($ch, CURLOPT_URL, $data["url"]);
	        curl_setopt($ch, CURLOPT_HTTPHEADER, $header); // Inject the token into the header
	        
	        if($data["type"] == "auth" || $data["type"] == "post"){
	            curl_setopt($ch, CURLOPT_POST, 1); // Specify the request method as POST
	            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data["post"])); // Set the posted fields    
	        }
	        
	        $result = curl_exec($ch); // Execute the cURL statement
	        
	        $jsonObj = json_decode($result);
	        
            
            if($data["type"] == "auth"){
                $authorization = "Authorization: Bearer ".$jsonObj->token; // Prepare the authorisation token
                $header[] = $authorization;
            }else{
                //var_dump($jsonObj);
            }               
            
            curl_close($ch); // Close the cURL connection  
      
	    }
	    
	    
	    
	    return $jsonObj;
	    
	}

	public static function get_web_page( $url )
	{
		$options = array(
			CURLOPT_RETURNTRANSFER => true,     // return web page
			CURLOPT_HEADER         => false,    // don't return headers
			CURLOPT_FOLLOWLOCATION => true,     // follow redirects
			CURLOPT_ENCODING       => "",       // handle all encodings
			CURLOPT_USERAGENT      => "hospedar 3.4.5", // who am i
			CURLOPT_AUTOREFERER    => true,     // set referer on redirect
			CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
			CURLOPT_TIMEOUT        => 120,      // timeout on response
			CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
			CURLOPT_SSL_VERIFYPEER => false     // Disabled SSL Cert checks
		);

		$ch      = curl_init( $url );
		curl_setopt_array( $ch, $options );
		$content = curl_exec( $ch );
		$err     = curl_errno( $ch );
		$errmsg  = curl_error( $ch );
		$header  = curl_getinfo( $ch );
		curl_close( $ch );

		$header['errno']   = $err;
		$header['errmsg']  = $errmsg;
		$header['content'] = $content;
		return $header;
	}
}
?>