DROP TABLE IF EXISTS `hotel_booking_bookings`;
CREATE TABLE IF NOT EXISTS `hotel_booking_bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned NOT NULL,
  `uuid` varchar(12) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `room_price` decimal(9,2) unsigned DEFAULT NULL,
  `extra_price` decimal(9,2) unsigned DEFAULT NULL,
  `total` decimal(9,2) unsigned DEFAULT NULL,
  `deposit` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(9,2) unsigned DEFAULT NULL,
  `security` decimal(9,2) unsigned DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  `voucher` varchar(50) DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `status` enum('confirmed','cancelled','pending') DEFAULT 'pending',
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `locale_id` int(10) unsigned NOT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `c_arrival` time DEFAULT NULL,
  `c_notes` text,
  `c_title` varchar(255) DEFAULT NULL,
  `c_fname` varchar(255) DEFAULT NULL,
  `c_lname` varchar(255) DEFAULT NULL,
  `c_phone` varchar(255) DEFAULT NULL,
  `c_email` varchar(255) DEFAULT NULL,
  `c_company` varchar(255) DEFAULT NULL,
  `c_address_1` varchar(255) DEFAULT NULL,
  `c_address_2` varchar(255) DEFAULT NULL,
  `c_address_3` varchar(255) DEFAULT NULL,
  `c_city` varchar(255) DEFAULT NULL,
  `c_state` varchar(255) DEFAULT NULL,
  `c_zip` varchar(255) DEFAULT NULL,
  `c_country` int(10) unsigned DEFAULT NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_bookings_extras`;
CREATE TABLE IF NOT EXISTS `hotel_booking_bookings_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `extra_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `booking_id` (`booking_id`,`extra_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_bookings_rooms`;
CREATE TABLE IF NOT EXISTS `hotel_booking_bookings_rooms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `room_id` int(10) unsigned DEFAULT NULL,
  `adults` smallint(5) unsigned DEFAULT NULL,
  `children` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `room_id` (`room_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_bookings_rooms_temp`;
CREATE TABLE IF NOT EXISTS `hotel_booking_bookings_rooms_temp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `room_id` int(10) unsigned DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `adults` smallint(5) unsigned DEFAULT NULL,
  `children` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `room_id` (`room_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_calendars`;
CREATE TABLE IF NOT EXISTS `hotel_booking_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_discount_codes`;
CREATE TABLE IF NOT EXISTS `hotel_booking_discount_codes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `room_id` int(10) unsigned DEFAULT NULL,
  `promo_code` varchar(50) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `type` enum('amount','percent') DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `room_id` (`room_id`,`promo_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_discount_frees`;
CREATE TABLE IF NOT EXISTS `hotel_booking_discount_frees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `room_id` int(10) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `min_length` tinyint(3) unsigned DEFAULT NULL,
  `max_length` tinyint(3) unsigned DEFAULT NULL,
  `free_nights` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `room_id` (`room_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_discount_packages`;
CREATE TABLE IF NOT EXISTS `hotel_booking_discount_packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `room_id` int(10) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `start_day` tinyint(1) unsigned DEFAULT NULL,
  `end_day` tinyint(1) unsigned DEFAULT NULL,
  `total_price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `room_id` (`room_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_discount_packages_items`;
CREATE TABLE IF NOT EXISTS `hotel_booking_discount_packages_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `package_id` int(10) unsigned DEFAULT NULL,
  `adults` smallint(5) unsigned DEFAULT NULL,
  `children` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `package_id` (`package_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_extras`;
CREATE TABLE IF NOT EXISTS `hotel_booking_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `per` enum('booking','day','person','day_person') DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_fields`;
CREATE TABLE IF NOT EXISTS `hotel_booking_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_limits`;
CREATE TABLE IF NOT EXISTS `hotel_booking_limits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `room_id` int(10) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `start_on` tinyint(1) unsigned DEFAULT NULL,
  `min_nights` tinyint(3) unsigned DEFAULT NULL,
  `max_nights` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `room_id` (`room_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_multi_lang`;
CREATE TABLE IF NOT EXISTS `hotel_booking_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(60) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_options`;
CREATE TABLE IF NOT EXISTS `hotel_booking_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_roles`;
CREATE TABLE IF NOT EXISTS `hotel_booking_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `hotel_booking_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

DROP TABLE IF EXISTS `hotel_booking_rooms`;
CREATE TABLE IF NOT EXISTS `hotel_booking_rooms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `adults` smallint(5) unsigned DEFAULT NULL,
  `children` smallint(5) unsigned DEFAULT NULL,
  `cnt` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `hotel_booking_users`;
CREATE TABLE IF NOT EXISTS `hotel_booking_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;














INSERT INTO `hotel_booking_fields` VALUES
('5', 'user', 'backend', 'Username', 'script', NULL),
('6', 'pass', 'backend', 'Password', 'script', NULL),
('7', 'email', 'backend', 'E-Mail', 'script', NULL),
('8', 'url', 'backend', 'URL', 'script', NULL),
('13', 'created', 'backend', 'Created', 'script', NULL),
('16', 'btnSave', 'backend', 'Save', 'script', NULL),
('17', 'btnReset', 'backend', 'Reset', 'script', NULL),
('18', 'addLocale', 'backend', 'Add language', 'script', NULL),
('22', 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
('23', 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
('24', 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
('25', 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
('26', 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
('31', 'btnUpdate', 'backend', 'Update', 'script', NULL),
('36', 'lblChoose', 'backend', 'Choose', 'script', NULL),
('37', 'btnSearch', 'backend', 'Search', 'script', NULL),
('40', 'backend', 'backend', 'Backend titles', 'script', NULL),
('41', 'frontend', 'backend', 'Front-end titles', 'script', NULL),
('42', 'locales', 'backend', 'Languages', 'script', NULL),
('44', 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
('45', 'btnLogin', 'backend', 'Login', 'script', NULL),
('47', 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
('57', 'lblOptionList', 'backend', 'Option list', 'script', NULL),
('58', 'btnAdd', 'backend', 'Button Add', 'script', NULL),
('62', 'lblDelete', 'backend', 'Delete', 'script', NULL),
('65', 'lblType', 'backend', 'Type', 'script', NULL),
('66', 'lblName', 'backend', 'Name', 'script', NULL),
('67', 'lblRole', 'backend', 'Role', 'script', NULL),
('68', 'lblStatus', 'backend', 'Status', 'script', NULL),
('69', 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
('70', 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
('71', 'lblAddUser', 'backend', 'Add user', 'script', NULL),
('72', 'lblValue', 'backend', 'Value', 'script', NULL),
('73', 'lblOption', 'backend', 'Option', 'script', NULL),
('74', 'lblDays', 'backend', 'Days', 'script', NULL),
('115', 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
('116', 'lblYes', 'backend', 'Yes', 'script', NULL),
('117', 'lblNo', 'backend', 'No', 'script', NULL),
('338', 'lblError', 'backend', 'Error', 'script', NULL),
('347', 'btnBack', 'backend', 'Button Back', 'script', NULL),
('355', 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
('356', 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
('357', 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
('358', 'btnSend', 'backend', 'Button Send', 'script', NULL),
('359', 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
('360', 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
('365', 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
('380', 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
('381', 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
('382', 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
('383', 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
('384', 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
('385', 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
('386', 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
('387', 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
('388', 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
('389', 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
('390', 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
('391', 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
('392', 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
('393', 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
('395', 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
('396', 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
('408', 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
('409', 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
('410', 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
('411', 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
('412', 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
('413', 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
('414', 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
('415', 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
('416', 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
('417', 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
('418', 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
('419', 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
('420', 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
('421', 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
('422', 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
('423', 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
('424', 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
('425', 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
('426', 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
('433', 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', '2013-09-19 10:03:32'),
('434', 'lblIp', 'backend', 'IP address', 'script', NULL),
('435', 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
('441', 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
('442', 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
('451', 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
('452', 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
('455', 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
('456', 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
('457', 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
('458', 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
('471', '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
('472', '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
('476', 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
('477', 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
('478', 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
('479', 'personal_titles2_ARRAY_ms', 'arrays', 'personal_titles2_ARRAY_ms', 'script', NULL),
('480', 'personal_titles2_ARRAY_dr', 'arrays', 'personal_titles2_ARRAY_dr', 'script', NULL),
('481', 'personal_titles2_ARRAY_prof', 'arrays', 'personal_titles2_ARRAY_prof', 'script', NULL),
('482', 'personal_titles2_ARRAY_rev', 'arrays', 'personal_titles2_ARRAY_rev', 'script', NULL),
('483', 'personal_titles2_ARRAY_other', 'arrays', 'personal_titles2_ARRAY_other', 'script', NULL),
('496', 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
('497', 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
('498', 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
('499', 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
('500', 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
('501', 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
('502', 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
('503', 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
('504', 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
('505', 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
('506', 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
('507', 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
('508', 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
('509', 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
('510', 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
('511', 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
('512', 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
('513', 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
('514', 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
('515', 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
('516', 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
('517', 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
('518', 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
('519', 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
('520', 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
('521', 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
('540', 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
('541', 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
('542', 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
('543', 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
('552', 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
('553', 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
('554', 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
('555', 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
('556', 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
('557', 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
('558', 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
('559', 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
('578', 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
('579', 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
('580', 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
('581', 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
('589', 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
('590', 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', '2013-09-19 10:04:10'),
('591', 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
('592', 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
('593', 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
('594', 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
('595', 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
('596', 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
('597', 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
('627', 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
('628', 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
('629', 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
('630', 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
('631', 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
('632', 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
('633', 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
('634', 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
('635', 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
('636', 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
('637', 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
('638', 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
('639', 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
('640', 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
('641', 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
('642', 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
('643', 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
('644', 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
('645', 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
('646', 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
('647', 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
('648', 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
('649', 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
('650', 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
('651', 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
('652', 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
('653', 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
('654', 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
('655', 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
('656', 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
('657', 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
('658', 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
('659', 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
('660', 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
('661', 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
('662', 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
('663', 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
('664', 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
('665', 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
('666', 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
('667', 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
('668', 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
('669', 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
('670', 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
('671', 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
('672', 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
('673', 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
('674', 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
('675', 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
('676', 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
('677', 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
('678', 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
('679', 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
('907', 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
('908', 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
('909', 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
('910', 'lnkBack', 'backend', 'Link Back', 'script', NULL),
('982', 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
('983', 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
('984', 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
('985', 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
('986', 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
('990', 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
('992', 'vr_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
('993', 'revert_status', 'backend', 'Revert status', 'script', NULL),
('994', 'lblExport', 'backend', 'Export', 'script', NULL),
('995', 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
('996', 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
('997', 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
('998', 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
('999', 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
('1200', 'menuSms', 'backend', 'Menu Sms', 'script', NULL),
('1201', 'menuInvoice', 'backend', 'Menu Invoice', 'script', NULL),
('1202', 'menuBookings', 'backend', 'Menu Bookings', 'script', NULL),
('1203', 'menuRooms', 'backend', 'Menu Rooms', 'script', NULL),
('1231', 'menuPrice', 'backend', 'Menu Price', 'script', NULL),
('1232', 'menuExtras', 'backend', 'Menu Extras', 'script', NULL),
('1233', 'menuLimits', 'backend', 'Menu Limits', 'script', NULL),
('1234', 'menuDiscounts', 'backend', 'Menu Discounts', 'script', NULL),
('1235', 'extra_per_ARRAY_day', 'arrays', 'Extras / Per', 'script', NULL),
('1236', 'extra_per_ARRAY_booking', 'arrays', 'Extras / Per', 'script', NULL),
('1237', 'extra_per_ARRAY_person', 'arrays', 'Extras / Per', 'script', NULL),
('1238', 'extra_per_ARRAY_day_person', 'arrays', 'Extras / Per', 'script', NULL),
('1239', 'extra_price', 'backend', 'Extras / Price', 'script', NULL),
('1240', 'extra_name', 'backend', 'Extras / Name', 'script', NULL),
('1241', 'extra_index_title', 'backend', 'Extras / Index title', 'script', '2013-09-19 10:35:04'),
('1242', 'extra_index_body', 'backend', 'Extras / Index body', 'script', '2013-09-19 10:35:56'),
('1243', 'extra_create_title', 'backend', 'Extras / Create title', 'script', NULL),
('1244', 'extra_create_body', 'backend', 'Extras / Create body', 'script', '2013-09-19 10:41:25'),
('1245', 'extra_update_title', 'backend', 'Extras / Update title', 'script', NULL),
('1246', 'extra_update_body', 'backend', 'Extras / Update body', 'script', NULL),
('1247', 'extra_per_lbl', 'backend', 'Extras / Per label', 'script', NULL),
('1248', 'delete_selected', 'backend', 'Delete selected', 'script', NULL),
('1249', 'delete_confirmation', 'backend', 'Delete confirmation', 'script', NULL),
('1250', 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
('1252', 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
('1253', 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
('1254', 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
('1255', 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
('1256', 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
('1257', 'error_titles_ARRAY_AE02', 'arrays', 'error_titles_ARRAY_AE02', 'script', NULL),
('1258', 'error_bodies_ARRAY_AE02', 'arrays', 'error_bodies_ARRAY_AE02', 'script', NULL),
('1259', 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
('1260', 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
('1263', 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
('1264', 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
('1265', 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
('1266', 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
('1267', 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
('1268', 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
('1269', 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
('1270', 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
('1271', 'rooms_name', 'backend', 'Rooms / Type', 'script', NULL),
('1272', 'rooms_adults', 'backend', 'Rooms / Adults', 'script', NULL),
('1273', 'rooms_children', 'backend', 'Rooms / Children', 'script', NULL),
('1274', 'rooms_cnt', 'backend', 'Rooms / Count', 'script', NULL),
('1275', 'rooms_add', 'backend', 'Rooms / Add room', 'script', NULL),
('1276', 'rooms_update', 'backend', 'Rooms / Update room', 'script', NULL),
('1278', 'rooms_description', 'backend', 'Rooms / Description', 'script', NULL),
('1279', 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
('1280', 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
('1281', 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
('1282', 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
('1283', 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', '2013-09-19 09:27:42'),
('1284', 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', '2013-09-19 09:27:50'),
('1285', 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
('1286', 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
('1287', 'menuInstall', 'backend', 'Menu Install', 'script', NULL),
('1288', 'menuPreview', 'backend', 'Menu Preview', 'script', NULL),
('1289', 'info_ARRAY_room_photos_title', 'arrays', 'info_ARRAY_room_photos_title', 'script', '2013-09-19 09:39:16'),
('1290', 'info_ARRAY_room_photos_body', 'arrays', 'info_ARRAY_room_photos_body', 'script', '2013-09-19 09:39:28'),
('1291', 'booking_add', 'backend', 'Bookings / Add booking', 'script', NULL),
('1292', 'booking_update', 'backend', 'Bookings / Update booking', 'script', NULL),
('1293', 'booking_statuses_ARRAY_confirmed', 'arrays', 'Bookings / Booking status ''confirmed''', 'script', NULL),
('1294', 'booking_statuses_ARRAY_pending', 'arrays', 'Bookings / Booking status ''pending''', 'script', NULL),
('1295', 'booking_statuses_ARRAY_cancelled', 'arrays', 'Bookings / Booking status ''cancelled''', 'script', NULL),
('1296', 'booking_dates', 'backend', 'Bookings / Dates', 'script', NULL),
('1297', 'booking_client', 'backend', 'Bookings / Client', 'script', NULL),
('1298', 'booking_rooms', 'backend', 'Bookings / Rooms', 'script', NULL),
('1299', 'booking_c_fname', 'backend', 'Bookings / First Name', 'script', NULL),
('1300', 'booking_c_lname', 'backend', 'Bookings / Last Name', 'script', NULL),
('1301', 'booking_c_title', 'backend', 'Bookings / Title', 'script', NULL),
('1302', 'booking_c_email', 'backend', 'Bookings / Email', 'script', NULL),
('1303', 'booking_c_phone', 'backend', 'Bookings / Phone', 'script', NULL),
('1304', 'booking_c_company', 'backend', 'Bookings / Company Name', 'script', NULL),
('1305', 'booking_c_zip', 'backend', 'Bookings / Zip', 'script', NULL),
('1306', 'booking_c_city', 'backend', 'Bookings / City', 'script', NULL),
('1307', 'booking_c_state', 'backend', 'Bookings / State', 'script', NULL),
('1308', 'booking_c_country', 'backend', 'Bookings / Country', 'script', NULL),
('1309', 'booking_c_address_1', 'backend', 'Bookings / Address Line 1', 'script', NULL),
('1310', 'booking_arrival', 'backend', 'Bookings / Arrival Time', 'script', NULL),
('1311', 'booking_notes', 'backend', 'Bookings / Notes', 'script', NULL),
('1312', 'booking_status', 'backend', 'Bookings / Status', 'script', NULL),
('1313', 'booking_deposit', 'backend', 'Bookings / Deposit', 'script', '2013-09-19 12:57:48'),
('1314', 'booking_tax', 'backend', 'Bookings / Tax', 'script', NULL),
('1315', 'booking_total', 'backend', 'Bookings / Total', 'script', NULL),
('1316', 'booking_payment_method', 'backend', 'Bookings / Payment method', 'script', NULL),
('1317', 'booking_date_from', 'backend', 'Bookings / Date from', 'script', NULL),
('1318', 'booking_date_to', 'backend', 'Bookings / Date to', 'script', NULL),
('1319', 'booking_room', 'backend', 'Bookings / Room type', 'script', NULL),
('1320', 'booking_payments_ARRAY_paypal', 'arrays', 'Bookings / Payment with Paypal', 'script', NULL),
('1321', 'booking_payments_ARRAY_authorize', 'arrays', 'Bookings / Payment with Authorize.NET', 'script', NULL),
('1322', 'booking_payments_ARRAY_bank', 'arrays', 'Bookings / Payment with Bank Account', 'script', NULL),
('1323', 'booking_payments_ARRAY_creditcard', 'arrays', 'Bookings / Payment with Credit card', 'script', NULL),
('1324', 'booking_client_details', 'backend', 'Bookings / Client details', 'script', NULL),
('1325', 'booking_booking_details', 'backend', 'Bookings / Booking details', 'script', NULL),
('1326', 'booking_payment_details', 'backend', 'Bookings / Payment details', 'script', NULL),
('1327', 'booking_cc_exp', 'backend', 'Bookings / CC Exp.date', 'script', NULL),
('1328', 'booking_cc_num', 'backend', 'Bookings / CC Number', 'script', NULL),
('1329', 'booking_cc_code', 'backend', 'Bookings / CC Code', 'script', NULL),
('1330', 'booking_cc_type', 'backend', 'Bookings / CC Type', 'script', NULL),
('1331', 'booking_cc_types_ARRAY_visa', 'arrays', 'Bookings / CC Type Visa', 'script', NULL),
('1332', 'booking_cc_types_ARRAY_mastercard', 'arrays', 'Bookings / CC Type MasterCard', 'script', NULL),
('1333', 'booking_cc_types_ARRAY_amex', 'arrays', 'Bookings / CC Type American Express', 'script', NULL),
('1334', 'booking_cc_types_ARRAY_maestro', 'arrays', 'Bookings / CC Type Maestro', 'script', NULL),
('1335', 'booking_room_details', 'backend', 'Bookings / Room details', 'script', NULL),
('1336', 'booking_add_room', 'backend', 'Bookings / Add room', 'script', NULL),
('1337', 'booking_recalc', 'backend', 'Bookings / Recalculate the price', 'script', NULL),
('1338', 'booking_room_edit', 'backend', 'Bookings / Edit booking room', 'script', NULL),
('1339', 'booking_room_delete', 'backend', 'Bookings / Delete booking room', 'script', NULL),
('1340', 'booking_room_add', 'backend', 'Bookings / Add booking room', 'script', NULL),
('1341', 'error_titles_ARRAY_ABK06', 'arrays', 'error_titles_ARRAY_ABK06', 'script', NULL),
('1342', 'error_bodies_ARRAY_ABK06', 'arrays', 'error_bodies_ARRAY_ABK06', 'script', NULL),
('1343', 'booking_extra_details', 'backend', 'Bookings / Extra details', 'script', NULL),
('1344', 'error_titles_ARRAY_ABK01', 'arrays', 'error_titles_ARRAY_ABK01', 'script', NULL),
('1345', 'error_titles_ARRAY_ABK03', 'arrays', 'error_titles_ARRAY_ABK03', 'script', NULL),
('1346', 'error_titles_ARRAY_ABK04', 'arrays', 'error_titles_ARRAY_ABK04', 'script', NULL),
('1347', 'error_titles_ARRAY_ABK08', 'arrays', 'error_titles_ARRAY_ABK08', 'script', NULL),
('1348', 'error_bodies_ARRAY_ABK01', 'arrays', 'error_bodies_ARRAY_ABK01', 'script', NULL),
('1349', 'error_bodies_ARRAY_ABK03', 'arrays', 'error_bodies_ARRAY_ABK03', 'script', NULL),
('1350', 'error_bodies_ARRAY_ABK04', 'arrays', 'error_bodies_ARRAY_ABK04', 'script', NULL),
('1351', 'error_bodies_ARRAY_ABK08', 'arrays', 'error_bodies_ARRAY_ABK08', 'script', NULL),
('1352', 'limit_date_from', 'backend', 'Limits / Date from', 'script', NULL),
('1353', 'limit_date_to', 'backend', 'Limits / Date to', 'script', NULL),
('1354', 'limit_start_on', 'backend', 'Limits / Start on', 'script', NULL),
('1355', 'limit_min_nights', 'backend', 'Limits / Min nights', 'script', NULL),
('1356', 'limit_max_nights', 'backend', 'Limits / Max nights', 'script', NULL),
('1357', 'limit_any_day', 'backend', 'Limits / Any day', 'script', NULL),
('1358', 'room_select', 'backend', 'Rooms / Select a room', 'script', NULL),
('1359', 'limit_add', 'backend', 'Limits / + Add Limit', 'script', NULL),
('1360', 'menuPackage', 'backend', 'Menu Package', 'script', NULL),
('1361', 'menuFreeNight', 'backend', 'Menu Free Night', 'script', NULL),
('1362', 'menuPromoCode', 'backend', 'Menu Promo Code', 'script', NULL),
('1363', 'discount_add_code', 'backend', 'Discounts / Add Promo code', 'script', NULL),
('1364', 'discount_add_free', 'backend', 'Discounts / Add Free night', 'script', NULL),
('1365', 'discount_add_package', 'backend', 'Discounts / Add Package', 'script', NULL),
('1366', 'discount_types_ARRAY_amount', 'arrays', 'Discounts / Type amount', 'script', NULL),
('1367', 'discount_types_ARRAY_percent', 'arrays', 'Discounts / Type percent', 'script', NULL),
('1368', 'discount_type', 'backend', 'Discounts / Type', 'script', NULL),
('1369', 'discount_discount', 'backend', 'Discounts / Discount', 'script', NULL),
('1370', 'discount_code', 'backend', 'Discounts / Promo code', 'script', NULL),
('1371', 'discount_min_length', 'backend', 'Discounts/ Min length', 'script', NULL),
('1372', 'discount_max_length', 'backend', 'Discounts/ Max length', 'script', NULL),
('1373', 'discount_free_nights', 'backend', 'Discounts / Free nights', 'script', NULL),
('1374', 'discount_start_day', 'backend', 'Discounts / Start day', 'script', NULL),
('1375', 'discount_end_day', 'backend', 'Discounts / End day', 'script', NULL),
('1376', 'discount_total_price', 'backend', 'Discounts / Total price', 'script', NULL),
('1377', 'menuGeneral', 'backend', 'Menu General', 'script', NULL),
('1378', 'menuPayments', 'backend', 'Menu Payments', 'script', NULL),
('1379', 'menuBookingForm', 'backend', 'Menu Booking form', 'script', NULL),
('1380', 'menuTerms', 'backend', 'Menu Terms', 'script', NULL),
('1381', 'menuConfirmation', 'backend', 'Menu Confirmation', 'script', NULL),
('1382', 'opt_o_bf_address', 'backend', 'Options / Address', 'script', NULL),
('1384', 'opt_o_bf_captcha', 'backend', 'Options / Captcha', 'script', NULL),
('1386', 'opt_o_bf_city', 'backend', 'Options / City', 'script', NULL),
('1387', 'opt_o_bf_email', 'backend', 'Options / Email', 'script', NULL),
('1388', 'opt_o_bf_fname', 'backend', 'Options / First Name', 'script', NULL),
('1389', 'opt_o_bf_notes', 'backend', 'Options / Notes', 'script', NULL),
('1390', 'opt_o_bf_phone', 'backend', 'Options / Phone', 'script', NULL),
('1391', 'opt_o_bf_state', 'backend', 'Options / State', 'script', NULL),
('1392', 'opt_o_bf_terms', 'backend', 'Options / Terms', 'script', NULL),
('1393', 'opt_o_bf_zip', 'backend', 'Options / Zip', 'script', NULL),
('1394', 'opt_o_bf_country', 'backend', 'Options / Country', 'script', NULL),
('1395', 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
('1396', 'opt_o_accept_bookings', 'backend', 'Options / Accept Bookings', 'script', '2013-09-19 12:53:29'),
('1397', 'opt_o_allow_authorize', 'backend', 'Options / Allow Authorize.net', 'script', NULL),
('1398', 'opt_o_allow_bank', 'backend', 'Options / Allow Bank', 'script', '2013-09-19 12:59:40'),
('1399', 'opt_o_allow_creditcard', 'backend', 'Options / Allow Credit Card', 'script', '2013-09-19 12:59:27'),
('1400', 'opt_o_allow_paypal', 'backend', 'Options / Allow Paypal', 'script', NULL),
('1401', 'opt_o_authorize_key', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
('1402', 'opt_o_authorize_mid', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
('1403', 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
('1404', 'opt_o_deposit', 'backend', 'Options / Deposit', 'script', '2013-09-19 12:57:58'),
('1405', 'opt_o_disable_payments', 'backend', 'Options / Disable payments', 'script', '2013-09-19 12:56:05'),
('1406', 'opt_o_price_based_on', 'backend', 'Options / Calculate price based on number of booked days or nights', 'script', '2013-09-19 12:54:43'),
('1407', 'opt_o_require_all_within', 'backend', 'Options / Require 100% if the reservations is within X days', 'script', '2013-09-19 12:58:41'),
('1408', 'opt_o_security', 'backend', 'Options / Security deposit payment', 'script', '2013-09-19 12:58:11'),
('1409', 'opt_o_status_if_not_paid', 'backend', 'Options / Default status for booked dates if not paid', 'script', '2013-09-19 12:54:16'),
('1410', 'opt_o_status_if_paid', 'backend', 'Options / Default status for booked dates if paid', 'script', '2013-09-19 12:53:59'),
('1411', 'opt_o_tax', 'backend', 'Options / Tax payment', 'script', '2013-09-19 12:58:26'),
('1412', 'opt_o_thankyou_page', 'backend', 'Options / "Thank you" page location', 'script', '2013-09-19 12:59:58'),
('1413', 'opt_o_authorize_tz', 'backend', 'Options / Authorize.net Time zone', 'script', NULL),
('1414', 'opt_o_email_new_reservation', 'backend', 'Options / New booking received', 'script', NULL),
('1415', 'opt_o_email_reservation_cancelled', 'backend', 'Options / Booking cancelled', 'script', NULL),
('1416', 'opt_o_email_password_reminder', 'backend', 'Notifications / Password reminder', 'script', NULL),
('1417', 'lblOptionsTermsURL', 'backend', 'Options / Booking terms URL', 'script', NULL),
('1418', 'lblOptionsTermsContent', 'backend', 'Options / Booking terms content', 'script', NULL),
('1419', 'error_titles_ARRAY_AO24', 'arrays', 'error_titles_ARRAY_AO24', 'script', NULL),
('1420', 'error_titles_ARRAY_AO25', 'arrays', 'error_titles_ARRAY_AO25', 'script', NULL),
('1421', 'error_titles_ARRAY_AO26', 'arrays', 'error_titles_ARRAY_AO26', 'script', NULL),
('1422', 'error_bodies_ARRAY_AO24', 'arrays', 'error_bodies_ARRAY_AO24', 'script', NULL),
('1423', 'error_bodies_ARRAY_AO25', 'arrays', 'error_bodies_ARRAY_AO25', 'script', '2013-12-11 18:12:01'),
('1424', 'error_bodies_ARRAY_AO26', 'arrays', 'error_bodies_ARRAY_AO26', 'script', NULL),
('1425', 'error_bodies_ARRAY_AO27', 'arrays', 'error_bodies_ARRAY_AO27', 'script', NULL),
('1430', 'lblMaxValue', 'backend', 'Options / Max value', 'script', NULL),
('1431', 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
('1432', 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
('1433', 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
('1434', 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
('1435', 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
('1436', 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
('1437', 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
('1438', 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
('1439', 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
('1440', 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
('1441', 'error_titles_ARRAY_AO07', 'arrays', 'error_titles_ARRAY_AO07', 'script', NULL),
('1442', 'error_bodies_ARRAY_AO07', 'arrays', 'error_bodies_ARRAY_AO07', 'script', NULL),
('1443', 'lblReservationCreateInvoice', 'backend', 'Create Invoice', 'script', NULL),
('1444', 'lblReservationFindInvoices', 'backend', 'Find Invoices', 'script', NULL),
('1445', 'lblReservationInvoiceDetails', 'backend', 'Invoice Details', 'script', NULL),
('1446', 'booking_uuid', 'backend', 'Bookings / Unique ID', 'script', NULL),
('1447', 'limit_room', 'backend', 'Limits / Room', 'script', NULL),
('1448', 'discount_package_items', 'backend', 'Discounts / Package Items', 'script', NULL),
('1449', 'discount_price', 'backend', 'Discounts / Price', 'script', NULL),
('1450', 'discount_package_items_add', 'backend', 'Discounts / Add item', 'script', NULL),
('1451', 'front_title', 'frontend', 'Search / Title', 'script', NULL),
('1452', 'front_btn_check', 'frontend', 'Search / Button check', 'script', NULL),
('1453', 'front_check_in', 'frontend', 'Search / Check-in date', 'script', NULL),
('1454', 'front_check_out', 'frontend', 'Search / Check-out date', 'script', NULL),
('1455', 'front_adults', 'frontend', 'Search / Adults', 'script', NULL),
('1456', 'front_children', 'frontend', 'Search / Children', 'script', NULL),
('1457', 'front_people', 'frontend', 'Frontend / People', 'script', NULL),
('1458', 'front_rooms', 'frontend', 'Frontend / Rooms', 'script', NULL),
('1459', 'front_price', 'frontend', 'Frontend / Price', 'script', NULL),
('1460', 'front_na', 'frontend', 'Frontend / Not available', 'script', NULL),
('1461', 'front_from', 'frontend', 'Frontend / From', 'script', NULL),
('1462', 'front_available_rooms', 'frontend', 'Frontend / Available rooms from', 'script', NULL),
('1463', 'front_change_dates', 'frontend', 'Frontend / Change dates', 'script', NULL),
('1464', 'front_btn_book', 'frontend', 'Frontend / Book', 'script', NULL),
('1465', 'front_btn_back', 'frontend', 'Frontend / Back', 'script', NULL),
('1466', 'front_not_found', 'frontend', 'Frontend / Rooms not found', 'script', NULL),
('1467', 'front_room', 'frontend', 'Frontend / Room', 'script', NULL),
('1468', 'front_btn_continue', 'frontend', 'Frontend / Continue', 'script', NULL),
('1469', 'front_selected_rooms', 'frontend', 'Frontend / Selected rooms accommodate', 'script', NULL),
('1470', 'front_price_note', 'frontend', 'Frontend / Price note', 'script', '2013-09-19 13:29:16'),
('1471', 'front_personal', 'frontend', 'Frontend / Personal Details', 'script', NULL),
('1472', 'front_billing', 'frontend', 'Frontend / Billing Address', 'script', NULL),
('1473', 'front_payment', 'frontend', 'Frontend / Payment Method', 'script', NULL),
('1474', 'front_terms', 'frontend', 'Frontend / Terms and Conditions', 'script', NULL),
('1475', 'front_select_title', 'frontend', 'Frontend / Select Title', 'script', NULL),
('1476', 'front_select_country', 'frontend', 'Frontend / Select Country', 'script', NULL),
('1477', 'front_select_payment', 'frontend', 'Frontend / Select Payment method', 'script', NULL),
('1480', 'front_terms_note', 'frontend', 'Frontend / Terms note', 'script', '2013-09-19 13:31:52'),
('1481', 'front_terms_link', 'frontend', 'Frontend / Terms link', 'script', '2013-09-19 13:32:11'),
('1482', 'front_btn_preview', 'frontend', 'Frontend / Preview Booking', 'script', NULL),
('1483', 'front_btn_confirm', 'frontend', 'Frontend / Confirm Booking', 'script', NULL),
('1484', 'opt_o_bf_lname', 'backend', 'Options / Last Name', 'script', NULL),
('1485', 'opt_o_bf_title', 'backend', 'Options / Title', 'script', NULL),
('1486', 'opt_o_bf_arrival', 'backend', 'Options / Arrival Time', 'script', NULL),
('1487', 'opt_o_bf_company', 'backend', 'Options / Company', 'script', NULL),
('1488', 'front_select_cc_type', 'frontend', 'Bookings / Select CC Type', 'script', NULL),
('1489', 'front_human_verification', 'frontend', 'Frontend / Human Verification', 'script', NULL),
('1490', 'front_captcha', 'frontend', 'Frontend / Captcha', 'script', NULL),
('1491', 'front_btn_checkout', 'frontend', 'Frontend / Checkout', 'script', NULL),
('1492', 'front_your_booking', 'frontend', 'Frontend / Your Booking', 'script', NULL),
('1493', 'front_extras', 'frontend', 'Frontend / Extras', 'script', NULL),
('1494', 'front_change', 'frontend', 'Frontend / Change', 'script', NULL),
('1495', 'front_booking_conditions', 'frontend', 'Frontend / Booking conditions', 'script', NULL),
('1496', 'front_for', 'frontend', 'Frontend / For', 'script', NULL),
('1497', 'front_max_persons', 'frontend', 'Frontend / Max persons per room', 'script', NULL),
('1498', 'front_room_price', 'frontend', 'Frontend / Room(s) Price', 'script', NULL),
('1499', 'front_extras_price', 'frontend', 'Frontend / Extras Price', 'script', NULL),
('1500', 'front_tax', 'frontend', 'Frontend / Tax', 'script', NULL),
('1501', 'front_total', 'frontend', 'Frontend / Total', 'script', NULL),
('1502', 'front_deposit', 'frontend', 'Frontend / Deposit required', 'script', NULL),
('1503', 'front_night_singular', 'frontend', 'Frontend / Night (singular)', 'script', NULL),
('1504', 'front_room_singular', 'frontend', 'Frontend / Room (singular)', 'script', NULL),
('1505', 'front_room_plural', 'frontend', 'Frontend / Room (plural)', 'script', NULL),
('1506', 'front_night_plural', 'frontend', 'Frontend / Night (plural)', 'script', NULL),
('1507', 'day_suffix_ARRAY_st', 'arrays', 'Day suffix (1st)', 'script', NULL),
('1508', 'day_suffix_ARRAY_nd', 'arrays', 'Day suffix (2nd)', 'script', NULL),
('1509', 'day_suffix_ARRAY_rd', 'arrays', 'Day suffix (3rd)', 'script', NULL),
('1510', 'day_suffix_ARRAY_th', 'arrays', 'Day suffix (4th)', 'script', NULL),
('1511', 'front_to', 'frontend', 'Frontend / To', 'script', NULL),
('1512', 'booking_room_price', 'backend', 'Bookings / Room(s) price', 'script', NULL),
('1513', 'booking_extra_price', 'backend', 'Bookings / Extra(s) price', 'script', NULL),
('1514', 'system_100', 'backend', 'System / Rooms / Missing parameters', 'script', NULL),
('1515', 'system_101', 'backend', 'System / Extras / Missing parameters', 'script', NULL),
('1516', 'system_102', 'backend', 'System / Checkout / Missing parameters', 'script', NULL),
('1517', 'system_103', 'backend', 'System / Preview / Missing parameters', 'script', NULL),
('1518', 'system_200', 'backend', 'System / Checkout / Submitted', 'script', NULL),
('1519', 'system_104', 'backend', 'System / Booking / Missing parameters', 'script', NULL),
('1520', 'system_105', 'backend', 'System / Booking / Missing or wrong captcha', 'script', NULL),
('1521', 'system_106', 'backend', 'System / Booking / Invalid data', 'script', NULL),
('1522', 'system_107', 'backend', 'System / Booking / Booking not stored', 'script', NULL),
('1523', 'system_201', 'backend', 'System / Booking / Booking stored', 'script', NULL),
('1524', 'system_202', 'backend', 'System / Booking / Booking sent', 'script', NULL),
('1525', 'system_203', 'backend', 'System / Booking / Booking redirect', 'script', NULL),
('1526', 'front_payment_paypal_title', 'backend', 'Frontend / Paypal title', 'script', NULL),
('1527', 'front_payment_authorize_title', 'frontend', 'Frontend / Authorize.NET title', 'script', NULL),
('1528', 'front_payment_paypal_submit', 'frontend', 'Frontend / Paypal submit', 'script', NULL),
('1529', 'front_payment_authorize_submit', 'frontend', 'Frontend / Authorize.NET submit', 'script', NULL),
('1530', 'front_rooms_accommodate', 'frontend', 'Frontend / Rooms accommodate', 'script', NULL),
('1531', 'booking_bank_account', 'frontend', 'Frontend / Bank account', 'script', NULL),
('1563', 'error_titles_ARRAY_AR06', 'arrays', 'error_titles_ARRAY_AR06', 'script', NULL),
('1564', 'error_bodies_ARRAY_AR06', 'arrays', 'error_bodies_ARRAY_AR06', 'script', '2013-09-19 09:27:02'),
('1565', 'front_btn_apply', 'frontend', 'Search / Button apply code', 'script', NULL),
('1566', 'lblDashLastLogin', 'backend', 'Dashboard / Last login', 'script', NULL),
('1567', 'lblNights', 'backend', 'Nights', 'script', NULL),
('1568', 'lblNight', 'backend', 'Night', 'script', NULL),
('1569', 'lblDay', 'backend', 'Day', 'script', NULL),
('1570', 'lblDashBookings', 'backend', 'Dashboard / Bookings today', 'script', NULL),
('1571', 'lblDashBooking', 'backend', 'Dashboard / Booking today', 'script', NULL),
('1572', 'lblDashAvailableRooms', 'backend', 'Dashboard / Available rooms', 'script', NULL),
('1573', 'lblDashAvailableRoom', 'backend', 'Dashboard / Available room', 'script', NULL),
('1574', 'lblDashBookedRooms', 'backend', 'Dashboard / Booked rooms', 'script', NULL),
('1575', 'lblDashBookedRoom', 'backend', 'Dashboard / Booked room', 'script', NULL),
('1576', 'front_discount', 'frontend', 'Frontend / Discount', 'script', NULL),
('1577', 'booking_voucher', 'backend', 'Bookings / Promo code', 'script', NULL),
('1578', 'booking_discount', 'backend', 'Bookings / Discount', 'script', NULL),
('1811', 'front_btn_cancel', 'frontend', 'Room / Button Cancel', 'script', NULL),
('1812', 'front_child', 'frontend', 'Search / Child', 'script', NULL),
('1813', 'front_adult', 'frontend', 'Search / Adult', 'script', NULL),
('1814', 'front_edit_room', 'frontend', 'Room / Edit room', 'script', NULL),
('1815', 'front_change_rooms', 'frontend', 'Room / Change rooms', 'script', NULL),
('1816', 'front_security', 'frontend', 'Frontend / Security', 'script', NULL),
('1817', 'front_booking_details', 'frontend', 'Frontend / Booking Details', 'script', NULL),
('1818', 'lblInstallJs1_1', 'backend', 'Install / Step 1', 'script', NULL),
('1819', 'lblInstallJs1_2', 'backend', 'Install / Step 2', 'script', NULL),
('1820', 'lblInstallJs1_3', 'backend', 'Install / Step 3', 'script', '2013-09-19 13:36:35'),
('1821', 'lblInstallJs1_title', 'backend', 'Install / Title', 'script', '2013-09-19 13:33:32'),
('1822', 'lblInstallJs1_body', 'backend', 'Install / Body', 'script', '2013-09-19 13:34:04'),
('1823', 'lblInstallConfig', 'backend', 'Install / Config', 'script', NULL),
('1824', 'lblInstallConfigLocale', 'backend', 'Install / Locale', 'script', NULL),
('1825', 'booking_security', 'backend', 'Bookings / Security', 'script', NULL),
('1826', 'error_bodies_ARRAY_AR10', 'arrays', 'error_bodies_ARRAY_AR10', 'script', NULL),
('1827', 'error_titles_ARRAY_AR10', 'arrays', 'error_titles_ARRAY_AR10', 'script', NULL),
('1828', 'error_bodies_ARRAY_AL10', 'arrays', 'error_bodies_ARRAY_AL10', 'script', '2013-09-19 10:23:06'),
('1829', 'error_titles_ARRAY_AL10', 'arrays', 'error_titles_ARRAY_AL10', 'script', '2013-09-19 10:05:05'),
('1830', 'error_titles_ARRAY_AD10', 'arrays', 'error_titles_ARRAY_AD10', 'script', '2013-09-19 10:31:27'),
('1831', 'error_bodies_ARRAY_AD10', 'arrays', 'error_bodies_ARRAY_AD10', 'script', '2013-09-19 10:32:32'),
('1832', 'error_titles_ARRAY_AD11', 'arrays', 'error_titles_ARRAY_AD11', 'script', '2013-09-19 10:32:55'),
('1833', 'error_bodies_ARRAY_AD11', 'arrays', 'error_bodies_ARRAY_AD11', 'script', '2013-09-19 10:34:12'),
('1834', 'error_titles_ARRAY_AD12', 'arrays', 'error_titles_ARRAY_AD12', 'script', '2013-09-19 10:24:54'),
('1835', 'error_bodies_ARRAY_AD12', 'arrays', 'error_bodies_ARRAY_AD12', 'script', '2013-09-19 10:30:58'),
('1836', 'error_titles_ARRAY_AR07', 'arrays', 'error_titles_ARRAY_AR07', 'script', '2013-09-19 09:28:06'),
('1837', 'error_bodies_ARRAY_AR07', 'arrays', 'error_bodies_ARRAY_AR07', 'script', '2013-09-19 09:28:39'),
('1838', 'error_titles_ARRAY_AO21', 'arrays', 'error_titles_ARRAY_AO21', 'script', NULL),
('1839', 'error_bodies_ARRAY_AO21', 'arrays', 'error_bodies_ARRAY_AO21', 'script', '2013-09-19 10:02:10'),
('1840', 'error_titles_ARRAY_AO23', 'arrays', 'error_titles_ARRAY_AO23', 'script', '2013-09-19 12:52:36'),
('1841', 'error_bodies_ARRAY_AO23', 'arrays', 'error_bodies_ARRAY_AO23', 'script', '2013-09-19 12:53:08'),
('1842', 'error_titles_ARRAY_AO37', 'arrays', 'error_titles_ARRAY_AO37', 'script', '2013-09-19 12:55:26'),
('1843', 'error_bodies_ARRAY_AO37', 'arrays', 'error_bodies_ARRAY_AO37', 'script', '2013-09-19 12:55:49'),
('1844', 'lblDashNoBookingsToday', 'backend', 'lblDashNoBookingsToday', 'script', NULL),
('1846', 'lblDashNoAvailableRoomsToday', 'backend', 'lblDashNoAvailableRoomsToday', 'script', NULL),
('1847', 'lblDashNoBookedRoomsToday', 'backend', 'lblDashNoBookedRoomsToday', 'script', NULL),
('1848', 'lblAll', 'backend', 'All', 'script', NULL),
('1849', 'booking_search_c_name', 'backend', 'Booking Search / Client Name', 'script', NULL),
('1850', 'booking_search_c_email', 'backend', 'Booking Search / Client Email', 'script', NULL),
('1851', 'booking_search_room', 'backend', 'Booking Search / Room Type', 'script', NULL),
('1852', 'booking_search_dates', 'backend', 'Booking Search / Booking from/to', 'script', NULL),
('1853', 'booking_search_created', 'backend', 'Booking Search / Booking made between', 'script', NULL),
('1854', 'booking_search_price', 'backend', 'Booking Search / Price range', 'script', NULL),
('1855', 'confirmation_subject', 'backend', 'Confirmation / Email subject', 'script', NULL),
('1856', 'confirmation_body', 'backend', 'Confirmation / Email body', 'script', NULL),
('1858', 'confirmation_client_confirmation', 'backend', 'Confirmation / Client confirmation title', 'script', NULL),
('1859', 'confirmation_client_payment', 'backend', 'Confirmation / Client payment title', 'script', NULL),
('1860', 'confirmation_admin_confirmation', 'backend', 'Confirmation / Admin confirmation title', 'script', NULL),
('1861', 'confirmation_admin_payment', 'backend', 'Confirmation / Admin payment title', 'script', NULL),
('1862', 'opt_o_authorize_hash', 'backend', 'Options / Authorize.net hash value', 'script', NULL),
('1863', 'booking_invoice_details', 'backend', 'Bookings / Invoice', 'script', NULL),
('1864', 'booking_invoice', 'backend', 'Bookings / Invoice', 'script', NULL),
('1865', 'booking_balance_payment', 'backend', 'Bookings / Balance payment', 'script', NULL),
('1866', 'gridInvalidDate', 'backend', 'Grid / Invalid date', 'script', NULL),
('1867', 'gridInvalidDatetime', 'backend', 'Grid / Invalid datetime', 'script', NULL),
('1868', 'gridEmptyDatetime', 'backend', 'Grid / Empty datetime', 'script', NULL),
('1869', 'gridEmptyDate', 'backend', 'Grid / Empty date', 'script', NULL),
('1870', 'booking_currency', 'backend', 'Bookings / Currency', 'script', NULL),
('2113', 'error_titles_ARRAY_AR09', 'arrays', 'error_titles_ARRAY_AR09', 'script', '2013-10-08 12:14:57'),
('2114', 'error_bodies_ARRAY_AR09', 'arrays', 'error_bodies_ARRAY_AR09', 'script', '2013-11-12 08:56:05'),
('2115', 'menuAvailability', 'backend', 'Menu Availability', 'script', '2013-10-08 12:58:10'),
('2116', 'error_titles_ARRAY_ABK09', 'arrays', 'error_titles_ARRAY_ABK09', 'script', '2013-10-08 13:00:26'),
('2117', 'error_bodies_ARRAY_ABK09', 'arrays', 'error_bodies_ARRAY_ABK09', 'script', '2013-11-12 09:21:49'),
('2118', 'booking_prev30', 'backend', 'Bookings / Previous 30 days', 'script', '2013-10-08 13:25:20'),
('2119', 'booking_next30', 'backend', 'Bookings / Next 30 days', 'script', '2013-10-08 13:25:33'),
('2120', 'booking_created', 'backend', 'Bookings / Date & Time', 'script', '2013-10-08 15:13:57'),
('2121', 'booking_ip', 'backend', 'Bookings / IP', 'script', '2013-10-08 15:14:15'),
('2122', 'booking_confirmation', 'backend', 'Bookings / Email confirmation', 'script', '2013-10-08 15:17:17'),
('2123', 'booking_confirmation_title', 'backend', 'Bookings / Email confirmation (title)', 'script', '2013-10-08 15:19:19'),
('2124', 'booking_subject', 'backend', 'Bookings / Subject', 'script', '2013-10-09 06:22:31'),
('2125', 'booking_message', 'backend', 'Bookings / Message', 'script', '2013-10-09 06:22:43'),
('2126', 'menuSeo', 'backend', 'Menu SEO', 'script', '2013-11-12 11:29:21'),
('2127', 'lblInstallConfigHide', 'backend', 'Install / Config hide', 'script', '2013-11-12 12:12:13'),
('2128', 'error_bodies_ARRAY_AO30', 'arrays', 'error_titles_ARRAY_AO30', 'script', '2013-11-12 12:14:46'),
('2129', 'error_titles_ARRAY_AO30', 'arrays', 'error_titles_ARRAY_AO30', 'script', '2013-11-12 12:15:12'),
('2130', 'lblInstallSeo_2', 'backend', 'Install / SEO Step 2', 'script', '2013-11-12 12:15:53'),
('2131', 'lblInstallSeo_1', 'backend', 'Install / SEO Step 1', 'script', '2013-11-12 12:16:06'),
('2132', 'lblInstallSeo_3', 'backend', 'Install / SEO Step 3', 'script', '2013-11-12 12:16:22'),
('2133', 'front_voucher_error', 'frontend', 'Frontend / Voucher error', 'script', '2013-11-29 09:43:02'),
('2134', 'opt_o_allow_cash', 'backend', 'Options / Allow Cash payments', 'script', '2013-12-09 07:08:27'),
('2135', 'booking_payments_ARRAY_cash', 'arrays', 'Bookings / Payment with Cash', 'script', '2013-12-09 07:11:14'),
('2136', 'error_titles_ARRAY_AA14', 'arrays', 'error_titles_ARRAY_AA14', 'script', '2013-12-12 07:34:02'),
('2137', 'error_bodies_ARRAY_AA14', 'arrays', 'error_bodies_ARRAY_AA14', 'script', '2013-12-12 07:34:23'),
('2138', 'lblDashLatestBookings', 'backend', 'Dashboard / Latest bookings', 'script', '2013-12-12 07:54:08'),
('2139', 'lblDashAvailableRoomsToday', 'backend', 'Dashboard / Available rooms today', 'script', '2013-12-12 07:54:55'),
('2140', 'lblDashBookedRoomsToday', 'backend', 'Dashboard / Booked rooms today', 'script', '2013-12-12 07:55:21'),
('2141', 'error_titles_ARRAY_ABK10', 'arrays', 'error_titles_ARRAY_ABK10', 'script', '2013-12-12 16:07:41'),
('2142', 'error_bodies_ARRAY_ABK10', 'arrays', 'error_bodies_ARRAY_ABK10', 'script', '2013-12-12 16:06:25'),
('2143', 'error_titles_ARRAY_AA15', 'arrays', 'error_titles_ARRAY_AA15', 'script', '2013-12-13 08:55:31'),
('2144', 'error_bodies_ARRAY_AA15', 'arrays', 'error_bodies_ARRAY_AA15', 'script', '2013-12-13 08:56:13'),
('2145', 'error_bodies_ARRAY_AA16', 'arrays', 'error_bodies_ARRAY_AA16', 'script', '2013-12-13 09:05:04'),
('2146', 'error_titles_ARRAY_AA16', 'arrays', 'error_titles_ARRAY_AA16', 'script', '2013-12-13 09:05:28'),
('2147', 'error_titles_ARRAY_AU09', 'arrays', 'error_titles_ARRAY_AU09', 'script', '2013-12-13 09:15:42'),
('2148', 'error_bodies_ARRAY_AU09', 'arrays', 'error_bodies_ARRAY_AU09', 'script', '2013-12-13 09:15:58'),
('2149', 'error_titles_ARRAY_AU10', 'arrays', 'error_titles_ARRAY_AU10', 'script', '2013-12-13 09:30:08'),
('2150', 'error_bodies_ARRAY_AU10', 'arrays', 'error_bodies_ARRAY_AU10', 'script', '2013-12-13 09:16:56'),
('2151', 'tabEmails', 'backend', 'Tabs / Emails', 'script', '2014-03-20 09:04:17'),
('2152', 'tabSms', 'backend', 'Tabs / Sms', 'script', '2014-03-20 09:04:31'),
('2153', 'confirm_sms_admin', 'backend', 'Confirmation / Admin - booking confirmation sms', 'script', '2014-03-20 09:05:59'),
('2154', 'payment_sms_admin', 'backend', 'Confirmation / Admin - payment confirmation sms', 'script', '2014-03-20 09:06:26'),
('2155', 'sms_body', 'backend', 'Confirmation / SMS content', 'script', '2014-03-20 09:07:06'),
('2452', 'opt_o_layout', 'backend', 'Options / Layout', 'script', '2014-05-19 10:37:32'),
('2453', 'front_i_want_this', 'frontend', 'Frontend / I want this?', 'script', '2014-05-19 11:48:39'),
('2454', 'front_more_extras', 'frontend', 'Frontend / More Extras', 'script', '2014-05-19 11:58:33'),
('2455', 'extra_thumb', 'backend', 'Extras / Image', 'script', '2014-05-19 12:47:00'),
('2456', 'extra_del_title', 'backend', 'Extras / Delete confirmation', 'script', '2014-05-19 13:23:04'),
('2457', 'extra_del_body', 'backend', 'Extras / Delete confirmation (body)', 'script', '2014-05-19 13:23:36'),
('2458', 'opt_o_show_week_numbers', 'backend', 'Options / Show week numbers', 'script', '2014-05-19 14:27:15'),
('2459', 'day_abbr_ARRAY_0', 'arrays', 'day_abbr_ARRAY_0', 'script', '2014-05-19 15:06:18'),
('2460', 'day_abbr_ARRAY_6', 'arrays', 'day_abbr_ARRAY_6', 'script', '2014-05-19 15:06:41'),
('2461', 'day_abbr_ARRAY_1', 'arrays', 'day_abbr_ARRAY_1', 'script', '2014-05-19 15:06:57'),
('2462', 'day_abbr_ARRAY_2', 'arrays', 'day_abbr_ARRAY_2', 'script', '2014-05-19 15:07:10'),
('2463', 'day_abbr_ARRAY_3', 'arrays', 'day_abbr_ARRAY_3', 'script', '2014-05-19 15:07:17'),
('2464', 'day_abbr_ARRAY_4', 'arrays', 'day_abbr_ARRAY_4', 'script', '2014-05-19 15:07:25'),
('2465', 'day_abbr_ARRAY_5', 'arrays', 'day_abbr_ARRAY_5', 'script', '2014-05-19 15:07:33'),
('2466', 'front_prev_month', 'frontend', 'Frontend / Prev month', 'script', '2014-05-20 08:24:16'),
('2467', 'front_next_month', 'frontend', 'Frontend / Next month', 'script', '2014-05-20 08:24:35'),
('2468', 'front_more_rooms', 'frontend', 'Frontend / More Rooms', 'script', '2014-05-20 08:34:59'),
('2469', 'front_cal_note', 'frontend', 'Frontend / Calendar note', 'script', '2014-05-20 08:36:14'),
('2470', 'front_combo_nights', 'frontend', 'Frontend / Nights', 'script', '2014-05-20 08:39:08'),
('2471', 'front_combo_children', 'frontend', 'Frontend / Children', 'script', '2014-05-20 08:39:21'),
('2472', 'front_combo_adults', 'frontend', 'Frontend / Adults', 'script', '2014-05-20 08:39:31'),
('2473', 'front_combo_arrival', 'frontend', 'Frontend / Arrival', 'script', '2014-05-20 08:39:41'),
('2474', 'opt_o_max_nights', 'backend', 'Options / Max.nights (Layout 2)', 'script', '2014-05-20 09:37:59'),
('2475', 'front_promo_code', 'frontend', 'Frontend / Promo Code', 'script', '2014-05-21 08:43:05'),
('2476', 'front_promo_apply', 'frontend', 'Frontend / Button Apply', 'script', '2014-05-21 08:55:19'),
('2477', 'front_na_short', 'frontend', 'Frontend / Not available', 'script', '2014-05-21 13:52:06'),
('2478', 'booking_tab_details', 'backend', 'Bookings / Details', 'script', '2014-05-23 14:43:43'),
('2479', 'booking_tab_client', 'backend', 'Bookings / Client', 'script', '2014-05-23 14:43:53'),
('2480', 'error_titles_ARRAY_ABK11', 'arrays', 'error_titles_ARRAY_ABK11', 'script', '2014-05-23 14:50:16'),
('2481', 'error_bodies_ARRAY_ABK11', 'arrays', 'error_bodies_ARRAY_ABK11', 'script', '2014-05-23 14:50:25'),
('2482', 'error_titles_ARRAY_ABK12', 'arrays', 'error_titles_ARRAY_ABK12', 'script', '2014-05-23 14:50:46'),
('2483', 'error_bodies_ARRAY_ABK12', 'arrays', 'error_bodies_ARRAY_ABK12', 'script', '2014-05-23 14:50:53'),
('2484', 'error_titles_ARRAY_ABK13', 'arrays', 'error_titles_ARRAY_ABK13', 'script', '2014-05-23 14:51:19'),
('2485', 'error_bodies_ARRAY_ABK13', 'arrays', 'error_bodies_ARRAY_ABK13', 'script', '2014-05-23 14:51:47'),
('2486', 'error_titles_ARRAY_ABK14', 'arrays', 'error_titles_ARRAY_ABK14', 'script', '2014-05-23 14:55:21'),
('2487', 'error_bodies_ARRAY_ABK14', 'arrays', 'error_bodies_ARRAY_ABK14', 'script', '2014-05-23 14:55:31'),
('2488', 'error_titles_ARRAY_ABK15', 'arrays', 'error_titles_ARRAY_ABK15', 'script', '2014-05-23 14:55:50'),
('2489', 'error_bodies_ARRAY_ABK15', 'arrays', 'error_bodies_ARRAY_ABK15', 'script', '2014-05-23 14:55:56'),
('2490', 'front_price_night', 'frontend', 'Frontend / Night', 'script', '2014-05-23 14:59:02'),
('2491', 'front_price_day', 'frontend', 'Frontend / Day', 'script', '2014-05-23 14:59:16'),
('2492', 'install_layout', 'backend', 'Install / Layout', 'script', '2014-05-23 15:07:38'),
('2493', 'install_legend', 'backend', 'Install / Legend', 'script', '2014-05-23 15:07:52'),
('2494', 'menuInstallPreview', 'backend', 'Menu Install & Preview', 'script', '2014-05-23 15:32:45'),
('2495', 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', '2014-06-24 14:19:03'),
('2496', 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', '2014-06-24 14:19:19'),
('2497', 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', '2014-06-24 14:19:34'),
('2498', 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', '2014-06-24 14:19:47'),
('2499', 'cancel_err_ARRAY_5', 'arrays', 'cancel_err_ARRAY_5', 'script', '2014-06-24 14:20:01'),
('2500', 'cancel_confirm', 'frontend', 'Cancel / Cancel button', 'script', '2014-06-24 14:20:26'),
('2501', 'cancel_title', 'frontend', 'Cancel / Page title', 'script', '2014-06-24 14:20:58'),
('2502', 'confirmation_admin_cancel', 'backend', 'Confirmation / Admin cancellation title', 'script', '2014-07-22 11:46:19'),
('2805', 'front_combo_departure', 'frontend', 'Frontend / Departure', 'script', '2014-07-22 12:23:30'),
('2806', 'front_combo_days', 'frontend', 'Frontend / Days', 'script', '2014-07-22 12:59:55'),
('2807', 'front_day_plural', 'frontend', 'Frontend / Day (plural)', 'script', '2014-07-22 13:03:22'),
('2808', 'front_day_singular', 'frontend', 'Frontend / Day (singular)', 'script', '2014-07-22 13:03:34'),
('2809', 'system_108', 'backend', 'System / Checkout / Haven''t selected room', 'script', '2014-07-22 13:45:29'),
('2810', 'system_109', 'backend', 'System / Checkout / Bookings not accepted', 'script', '2014-07-22 13:46:06'),
('2812', 'system_110', 'backend', 'System / Checkout / Rooms not available', 'script', '2014-07-22 13:47:14'),
('3115', 'front_price_per_day', 'frontend', 'Frontend / Per day', 'script', '2014-08-04 07:08:17'),
('3116', 'front_price_per_night', 'frontend', 'Frontend / Per night', 'script', '2014-08-04 07:08:28');

INSERT INTO `hotel_booking_multi_lang` VALUES
('1', '5', 'pjField', '1', 'title', 'Username', 'script'),
('2', '6', 'pjField', '1', 'title', 'Password', 'script'),
('3', '7', 'pjField', '1', 'title', 'Email', 'script'),
('4', '8', 'pjField', '1', 'title', 'URL', 'script'),
('5', '13', 'pjField', '1', 'title', 'DateTime', 'script'),
('6', '16', 'pjField', '1', 'title', 'Save', 'script'),
('7', '17', 'pjField', '1', 'title', 'Reset', 'script'),
('8', '18', 'pjField', '1', 'title', 'Add language', 'script'),
('9', '22', 'pjField', '1', 'title', 'Multi Lang', 'script'),
('10', '23', 'pjField', '1', 'title', 'Plugins', 'script'),
('11', '24', 'pjField', '1', 'title', 'Users', 'script'),
('12', '25', 'pjField', '1', 'title', 'Options', 'script'),
('13', '26', 'pjField', '1', 'title', 'Logout', 'script'),
('14', '31', 'pjField', '1', 'title', 'Update', 'script'),
('15', '36', 'pjField', '1', 'title', 'Choose', 'script'),
('16', '37', 'pjField', '1', 'title', 'Search', 'script'),
('17', '40', 'pjField', '1', 'title', 'Back-end titles', 'script'),
('18', '41', 'pjField', '1', 'title', 'Front-end titles', 'script'),
('19', '42', 'pjField', '1', 'title', 'Languages', 'script'),
('20', '44', 'pjField', '1', 'title', 'Admin Login', 'script'),
('21', '45', 'pjField', '1', 'title', 'Login', 'script'),
('22', '47', 'pjField', '1', 'title', 'Dashboard', 'script'),
('23', '57', 'pjField', '1', 'title', 'Option list', 'script'),
('24', '58', 'pjField', '1', 'title', 'Add +', 'script'),
('25', '62', 'pjField', '1', 'title', 'Delete', 'script'),
('26', '65', 'pjField', '1', 'title', 'Type', 'script'),
('27', '66', 'pjField', '1', 'title', 'Name', 'script'),
('28', '67', 'pjField', '1', 'title', 'Role', 'script'),
('29', '68', 'pjField', '1', 'title', 'Status', 'script'),
('30', '69', 'pjField', '1', 'title', 'Is confirmed', 'script'),
('31', '70', 'pjField', '1', 'title', 'Update user', 'script'),
('32', '71', 'pjField', '1', 'title', 'Add user', 'script'),
('33', '72', 'pjField', '1', 'title', 'Value', 'script'),
('34', '73', 'pjField', '1', 'title', 'Option', 'script'),
('35', '74', 'pjField', '1', 'title', 'days', 'script'),
('36', '115', 'pjField', '1', 'title', 'Languages', 'script'),
('37', '5', 'pjField', '2', 'title', 'Username', 'script'),
('38', '6', 'pjField', '2', 'title', 'Password', 'script'),
('39', '7', 'pjField', '2', 'title', 'Email', 'script'),
('40', '8', 'pjField', '2', 'title', 'URL', 'script'),
('41', '13', 'pjField', '2', 'title', 'DateTime', 'script'),
('42', '16', 'pjField', '2', 'title', 'Save', 'script'),
('43', '17', 'pjField', '2', 'title', 'Reset', 'script'),
('44', '18', 'pjField', '2', 'title', 'Add language', 'script'),
('45', '22', 'pjField', '2', 'title', 'Multi Lang', 'script'),
('46', '23', 'pjField', '2', 'title', 'Plugins', 'script'),
('47', '24', 'pjField', '2', 'title', 'Users', 'script'),
('48', '25', 'pjField', '2', 'title', 'Options', 'script'),
('49', '26', 'pjField', '2', 'title', 'Logout', 'script'),
('50', '31', 'pjField', '2', 'title', 'Update', 'script'),
('51', '36', 'pjField', '2', 'title', 'Choose', 'script'),
('52', '37', 'pjField', '2', 'title', 'Search', 'script'),
('53', '40', 'pjField', '2', 'title', 'Back-end titles', 'script'),
('54', '41', 'pjField', '2', 'title', 'Front-end titles', 'script'),
('55', '42', 'pjField', '2', 'title', 'Languages', 'script'),
('56', '44', 'pjField', '2', 'title', 'Admin Login', 'script'),
('57', '45', 'pjField', '2', 'title', 'Login', 'script'),
('58', '47', 'pjField', '2', 'title', 'Dashboard', 'script'),
('59', '57', 'pjField', '2', 'title', 'Option list', 'script'),
('60', '58', 'pjField', '2', 'title', 'Add +', 'script'),
('61', '62', 'pjField', '2', 'title', 'Delete', 'script'),
('62', '65', 'pjField', '2', 'title', 'Type', 'script'),
('63', '66', 'pjField', '2', 'title', 'Name', 'script'),
('64', '67', 'pjField', '2', 'title', 'Role', 'script'),
('65', '68', 'pjField', '2', 'title', 'Status', 'script'),
('66', '69', 'pjField', '2', 'title', 'Is Active', 'script'),
('67', '70', 'pjField', '2', 'title', 'Update user', 'script'),
('68', '71', 'pjField', '2', 'title', 'Add user', 'script'),
('69', '72', 'pjField', '2', 'title', 'Value', 'script'),
('70', '73', 'pjField', '2', 'title', 'Option', 'script'),
('71', '74', 'pjField', '2', 'title', 'days', 'script'),
('72', '115', 'pjField', '2', 'title', 'Languages', 'script'),
('73', '116', 'pjField', '1', 'title', 'Yes', 'script'),
('74', '116', 'pjField', '2', 'title', 'Ð”Ð°', 'script'),
('75', '117', 'pjField', '1', 'title', 'No', 'script'),
('76', '117', 'pjField', '2', 'title', 'ÐÐµ', 'script'),
('77', '338', 'pjField', '1', 'title', 'Error', 'script'),
('78', '338', 'pjField', '2', 'title', 'Error', 'script'),
('79', '347', 'pjField', '1', 'title', '&laquo; Back', 'script'),
('80', '347', 'pjField', '2', 'title', 'Back', 'script'),
('81', '355', 'pjField', '1', 'title', 'Cancel', 'script'),
('82', '355', 'pjField', '2', 'title', 'Cancel', 'script'),
('83', '356', 'pjField', '1', 'title', 'Forgot password', 'script'),
('84', '356', 'pjField', '2', 'title', 'Forgot password', 'script'),
('85', '357', 'pjField', '1', 'title', 'Password reminder', 'script'),
('86', '357', 'pjField', '2', 'title', 'Password reminder', 'script'),
('87', '358', 'pjField', '1', 'title', 'Send', 'script'),
('88', '358', 'pjField', '2', 'title', 'Send', 'script'),
('89', '359', 'pjField', '1', 'title', 'Password reminder', 'script'),
('90', '359', 'pjField', '2', 'title', 'Password reminder', 'script'),
('91', '360', 'pjField', '1', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('92', '360', 'pjField', '2', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('93', '365', 'pjField', '1', 'title', 'Profile', 'script'),
('94', '365', 'pjField', '2', 'title', 'Profile', 'script'),
('95', '380', 'pjField', '1', 'title', 'Languages Title', 'script'),
('96', '380', 'pjField', '2', 'title', 'Languages Title', 'script'),
('97', '381', 'pjField', '1', 'title', 'Languages Body', 'script'),
('98', '381', 'pjField', '2', 'title', 'Languages Body', 'script'),
('99', '382', 'pjField', '1', 'title', 'Languages Backend Title', 'script'),
('100', '382', 'pjField', '2', 'title', 'Languages Backend Title', 'script'),
('101', '383', 'pjField', '1', 'title', 'Languages Backend Body', 'script'),
('102', '383', 'pjField', '2', 'title', 'Languages Backend Body', 'script'),
('103', '384', 'pjField', '1', 'title', 'Languages Frontend Title', 'script'),
('104', '384', 'pjField', '2', 'title', 'Languages Frontend Title', 'script'),
('105', '385', 'pjField', '1', 'title', 'Languages Frontend Body', 'script'),
('106', '385', 'pjField', '2', 'title', 'Languages Frontend Body', 'script'),
('107', '386', 'pjField', '1', 'title', 'Listing Prices Title', 'script'),
('108', '386', 'pjField', '2', 'title', 'Listing Prices Title', 'script'),
('109', '387', 'pjField', '1', 'title', 'Listing Prices Body', 'script'),
('110', '387', 'pjField', '2', 'title', 'Listing Prices Body', 'script'),
('111', '388', 'pjField', '1', 'title', 'Listing Bookings Title', 'script'),
('112', '388', 'pjField', '2', 'title', 'Listing Bookings Title', 'script'),
('113', '389', 'pjField', '1', 'title', 'Listing Bookings Body', 'script'),
('114', '389', 'pjField', '2', 'title', 'Listing Bookings Body', 'script'),
('115', '390', 'pjField', '1', 'title', 'Listing Contact Title', 'script'),
('116', '390', 'pjField', '2', 'title', 'Listing Contact Title', 'script'),
('117', '391', 'pjField', '1', 'title', 'Listing Contact Body', 'script'),
('118', '391', 'pjField', '2', 'title', 'Listing Contact Body', 'script'),
('119', '392', 'pjField', '1', 'title', 'Listing Address Title', 'script'),
('120', '392', 'pjField', '2', 'title', 'Listing Address Title', 'script'),
('121', '393', 'pjField', '1', 'title', 'Listing Address Body', 'script'),
('122', '393', 'pjField', '2', 'title', 'Listing Address Body', 'script'),
('123', '395', 'pjField', '1', 'title', 'Extend exp.date Title', 'script'),
('124', '395', 'pjField', '2', 'title', 'Extend exp.date Title', 'script'),
('125', '396', 'pjField', '1', 'title', 'Extend exp.date Body', 'script'),
('126', '396', 'pjField', '2', 'title', 'Extend exp.date Body', 'script'),
('127', '408', 'pjField', '1', 'title', 'Backup', 'script'),
('128', '408', 'pjField', '2', 'title', 'Backup', 'script'),
('129', '409', 'pjField', '1', 'title', 'Backup', 'script'),
('130', '409', 'pjField', '2', 'title', 'Backup', 'script'),
('131', '410', 'pjField', '1', 'title', 'Backup database', 'script'),
('132', '410', 'pjField', '2', 'title', 'Backup database', 'script'),
('133', '411', 'pjField', '1', 'title', 'Backup files', 'script'),
('134', '411', 'pjField', '2', 'title', 'Backup files', 'script'),
('135', '412', 'pjField', '1', 'title', 'Choose Action', 'script'),
('136', '412', 'pjField', '2', 'title', 'Choose Action', 'script'),
('137', '413', 'pjField', '1', 'title', 'Go to page:', 'script'),
('138', '413', 'pjField', '2', 'title', 'Go to page:', 'script'),
('139', '414', 'pjField', '1', 'title', 'Total items:', 'script'),
('140', '414', 'pjField', '2', 'title', 'Total items:', 'script'),
('141', '415', 'pjField', '1', 'title', 'Items per page', 'script'),
('142', '415', 'pjField', '2', 'title', 'Items per page', 'script'),
('143', '416', 'pjField', '1', 'title', 'Prev page', 'script'),
('144', '416', 'pjField', '2', 'title', 'Prev page', 'script'),
('145', '417', 'pjField', '1', 'title', '&laquo; Prev', 'script'),
('146', '417', 'pjField', '2', 'title', '&laquo; Prev', 'script'),
('147', '418', 'pjField', '1', 'title', 'Next page', 'script'),
('148', '418', 'pjField', '2', 'title', 'Next page', 'script'),
('149', '419', 'pjField', '1', 'title', 'Next &raquo;', 'script'),
('150', '419', 'pjField', '2', 'title', 'Next &raquo;', 'script'),
('151', '420', 'pjField', '1', 'title', 'Delete confirmation', 'script'),
('152', '420', 'pjField', '2', 'title', 'Delete confirmation', 'script'),
('153', '421', 'pjField', '1', 'title', 'Are you sure you want to delete selected record?', 'script'),
('154', '421', 'pjField', '2', 'title', 'Are you sure you want to delete selected record?', 'script'),
('155', '422', 'pjField', '1', 'title', 'Action confirmation', 'script'),
('156', '422', 'pjField', '2', 'title', 'Action confirmation', 'script'),
('157', '423', 'pjField', '1', 'title', 'OK', 'script'),
('158', '423', 'pjField', '2', 'title', 'OK', 'script'),
('159', '424', 'pjField', '1', 'title', 'Cancel', 'script'),
('160', '424', 'pjField', '2', 'title', 'Cancel', 'script'),
('161', '425', 'pjField', '1', 'title', 'Delete', 'script'),
('162', '425', 'pjField', '2', 'title', 'Delete', 'script'),
('163', '426', 'pjField', '1', 'title', 'No records found', 'script'),
('164', '426', 'pjField', '2', 'title', 'No records found', 'script'),
('165', '433', 'pjField', '1', 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
('166', '433', 'pjField', '2', 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
('167', '434', 'pjField', '1', 'title', 'IP address', 'script'),
('168', '434', 'pjField', '2', 'title', 'IP address', 'script'),
('169', '435', 'pjField', '1', 'title', 'Registration date/time', 'script'),
('170', '435', 'pjField', '2', 'title', 'Registration date/time', 'script'),
('171', '441', 'pjField', '1', 'title', 'Currency', 'script'),
('172', '441', 'pjField', '2', 'title', 'Currency', 'script'),
('173', '442', 'pjField', '1', 'title', 'Date format', 'script'),
('174', '442', 'pjField', '2', 'title', 'Date format', 'script'),
('175', '451', 'pjField', '1', 'title', 'Timezone', 'script'),
('176', '451', 'pjField', '2', 'title', 'Timezone', 'script'),
('177', '452', 'pjField', '1', 'title', 'First day of the week', 'script'),
('178', '452', 'pjField', '2', 'title', 'First day of the week', 'script'),
('179', '455', 'pjField', '1', 'title', 'Active', 'script'),
('180', '456', 'pjField', '1', 'title', 'Inactive', 'script'),
('181', '457', 'pjField', '1', 'title', 'Active', 'script'),
('182', '458', 'pjField', '1', 'title', 'Inactive', 'script'),
('183', '471', 'pjField', '1', 'title', 'Yes', 'script'),
('184', '472', 'pjField', '1', 'title', 'No', 'script'),
('185', '476', 'pjField', '1', 'title', 'Mr.', 'script'),
('186', '477', 'pjField', '1', 'title', 'Mrs.', 'script'),
('187', '478', 'pjField', '1', 'title', 'Miss', 'script'),
('188', '479', 'pjField', '1', 'title', 'Ms.', 'script'),
('189', '480', 'pjField', '1', 'title', 'Dr.', 'script'),
('190', '481', 'pjField', '1', 'title', 'Prof.', 'script'),
('191', '482', 'pjField', '1', 'title', 'Rev.', 'script'),
('192', '483', 'pjField', '1', 'title', 'Other', 'script'),
('193', '496', 'pjField', '1', 'title', 'GMT-12:00', 'script'),
('194', '497', 'pjField', '1', 'title', 'GMT-11:00', 'script'),
('195', '498', 'pjField', '1', 'title', 'GMT-10:00', 'script'),
('196', '499', 'pjField', '1', 'title', 'GMT-09:00', 'script'),
('197', '500', 'pjField', '1', 'title', 'GMT-08:00', 'script'),
('198', '501', 'pjField', '1', 'title', 'GMT-07:00', 'script'),
('199', '502', 'pjField', '1', 'title', 'GMT-06:00', 'script'),
('200', '503', 'pjField', '1', 'title', 'GMT-05:00', 'script'),
('201', '504', 'pjField', '1', 'title', 'GMT-04:00', 'script'),
('202', '505', 'pjField', '1', 'title', 'GMT-03:00', 'script'),
('203', '506', 'pjField', '1', 'title', 'GMT-02:00', 'script'),
('204', '507', 'pjField', '1', 'title', 'GMT-01:00', 'script'),
('205', '508', 'pjField', '1', 'title', 'GMT', 'script'),
('206', '509', 'pjField', '1', 'title', 'GMT+01:00', 'script'),
('207', '510', 'pjField', '1', 'title', 'GMT+02:00', 'script'),
('208', '511', 'pjField', '1', 'title', 'GMT+03:00', 'script'),
('209', '512', 'pjField', '1', 'title', 'GMT+04:00', 'script'),
('210', '513', 'pjField', '1', 'title', 'GMT+05:00', 'script'),
('211', '514', 'pjField', '1', 'title', 'GMT+06:00', 'script'),
('212', '515', 'pjField', '1', 'title', 'GMT+07:00', 'script'),
('213', '516', 'pjField', '1', 'title', 'GMT+08:00', 'script'),
('214', '517', 'pjField', '1', 'title', 'GMT+09:00', 'script'),
('215', '518', 'pjField', '1', 'title', 'GMT+10:00', 'script'),
('216', '519', 'pjField', '1', 'title', 'GMT+11:00', 'script'),
('217', '520', 'pjField', '1', 'title', 'GMT+12:00', 'script'),
('218', '521', 'pjField', '1', 'title', 'GMT+13:00', 'script'),
('219', '540', 'pjField', '1', 'title', 'User updated!', 'script'),
('220', '541', 'pjField', '1', 'title', 'User added!', 'script'),
('221', '542', 'pjField', '1', 'title', 'User failed to add.', 'script'),
('222', '543', 'pjField', '1', 'title', 'User not found.', 'script'),
('223', '552', 'pjField', '1', 'title', 'Backup', 'script'),
('224', '553', 'pjField', '1', 'title', 'Backup complete!', 'script'),
('225', '554', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('226', '555', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('227', '556', 'pjField', '1', 'title', 'Account not found!', 'script'),
('228', '557', 'pjField', '1', 'title', 'Password send!', 'script'),
('229', '558', 'pjField', '1', 'title', 'Password not send!', 'script'),
('230', '559', 'pjField', '1', 'title', 'Profile updated!', 'script'),
('231', '578', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('232', '579', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('233', '580', 'pjField', '1', 'title', 'We are sorry, but the user has not been added.', 'script'),
('234', '581', 'pjField', '1', 'title', 'User your looking for is missing.', 'script'),
('235', '589', 'pjField', '1', 'title', 'All the changes made to titles have been saved.', 'script'),
('236', '590', 'pjField', '1', 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
('237', '591', 'pjField', '1', 'title', 'All backup files have been saved.', 'script'),
('238', '592', 'pjField', '1', 'title', 'No option was selected.', 'script'),
('239', '593', 'pjField', '1', 'title', 'Backup not performed.', 'script'),
('240', '594', 'pjField', '1', 'title', 'Given email address is not associated with any account.', 'script'),
('241', '595', 'pjField', '1', 'title', 'For further instructions please check your mailbox.', 'script'),
('242', '596', 'pjField', '1', 'title', 'We''re sorry, please try again later.', 'script'),
('243', '597', 'pjField', '1', 'title', 'All the changes made to your profile have been saved.', 'script'),
('244', '627', 'pjField', '1', 'title', 'January', 'script'),
('245', '628', 'pjField', '1', 'title', 'February', 'script'),
('246', '629', 'pjField', '1', 'title', 'March', 'script'),
('247', '630', 'pjField', '1', 'title', 'April', 'script'),
('248', '631', 'pjField', '1', 'title', 'May', 'script'),
('249', '632', 'pjField', '1', 'title', 'June', 'script'),
('250', '633', 'pjField', '1', 'title', 'July', 'script'),
('251', '634', 'pjField', '1', 'title', 'August', 'script'),
('252', '635', 'pjField', '1', 'title', 'September', 'script'),
('253', '636', 'pjField', '1', 'title', 'October', 'script'),
('254', '637', 'pjField', '1', 'title', 'November', 'script'),
('255', '638', 'pjField', '1', 'title', 'December', 'script'),
('256', '639', 'pjField', '1', 'title', 'Sunday', 'script'),
('257', '640', 'pjField', '1', 'title', 'Monday', 'script'),
('258', '641', 'pjField', '1', 'title', 'Tuesday', 'script'),
('259', '642', 'pjField', '1', 'title', 'Wednesday', 'script'),
('260', '643', 'pjField', '1', 'title', 'Thursday', 'script'),
('261', '644', 'pjField', '1', 'title', 'Friday', 'script'),
('262', '645', 'pjField', '1', 'title', 'Saturday', 'script'),
('263', '646', 'pjField', '1', 'title', 'S', 'script'),
('264', '647', 'pjField', '1', 'title', 'M', 'script'),
('265', '648', 'pjField', '1', 'title', 'T', 'script'),
('266', '649', 'pjField', '1', 'title', 'W', 'script'),
('267', '650', 'pjField', '1', 'title', 'T', 'script'),
('268', '651', 'pjField', '1', 'title', 'F', 'script'),
('269', '652', 'pjField', '1', 'title', 'S', 'script'),
('270', '653', 'pjField', '1', 'title', 'Jan', 'script'),
('271', '654', 'pjField', '1', 'title', 'Feb', 'script'),
('272', '655', 'pjField', '1', 'title', 'Mar', 'script'),
('273', '656', 'pjField', '1', 'title', 'Apr', 'script'),
('274', '657', 'pjField', '1', 'title', 'May', 'script'),
('275', '658', 'pjField', '1', 'title', 'Jun', 'script'),
('276', '659', 'pjField', '1', 'title', 'Jul', 'script'),
('277', '660', 'pjField', '1', 'title', 'Aug', 'script'),
('278', '661', 'pjField', '1', 'title', 'Sep', 'script'),
('279', '662', 'pjField', '1', 'title', 'Oct', 'script'),
('280', '663', 'pjField', '1', 'title', 'Nov', 'script'),
('281', '664', 'pjField', '1', 'title', 'Dec', 'script'),
('282', '665', 'pjField', '1', 'title', 'You are not loged in.', 'script'),
('283', '666', 'pjField', '1', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('284', '667', 'pjField', '1', 'title', 'Empty resultset.', 'script'),
('285', '668', 'pjField', '1', 'title', 'The operation is not allowed in demo mode.', 'script'),
('286', '669', 'pjField', '1', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('287', '670', 'pjField', '1', 'title', 'No permisions to edit the property', 'script'),
('288', '671', 'pjField', '1', 'title', 'No permisions to edit the reservation', 'script'),
('289', '672', 'pjField', '1', 'title', 'No reservation found', 'script'),
('290', '673', 'pjField', '1', 'title', 'No property for the reservation found', 'script'),
('291', '674', 'pjField', '1', 'title', 'Your registration was successfull.', 'script'),
('292', '675', 'pjField', '1', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('293', '676', 'pjField', '1', 'title', 'E-Mail address already exist', 'script'),
('294', '677', 'pjField', '1', 'title', 'Wrong username or password', 'script'),
('295', '678', 'pjField', '1', 'title', 'Access denied', 'script'),
('296', '679', 'pjField', '1', 'title', 'Account is disabled', 'script'),
('297', '455', 'pjField', '2', 'title', 'Active', 'script'),
('298', '456', 'pjField', '2', 'title', 'Inactive', 'script'),
('299', '457', 'pjField', '2', 'title', 'Active', 'script'),
('300', '458', 'pjField', '2', 'title', 'Inactive', 'script'),
('301', '471', 'pjField', '2', 'title', 'Yes', 'script'),
('302', '472', 'pjField', '2', 'title', 'No', 'script'),
('303', '476', 'pjField', '2', 'title', 'Mr.', 'script'),
('304', '477', 'pjField', '2', 'title', 'Mrs.', 'script'),
('305', '478', 'pjField', '2', 'title', 'Miss', 'script'),
('306', '479', 'pjField', '2', 'title', 'Ms.', 'script'),
('307', '480', 'pjField', '2', 'title', 'Dr.', 'script'),
('308', '481', 'pjField', '2', 'title', 'Prof.', 'script'),
('309', '482', 'pjField', '2', 'title', 'Rev.', 'script'),
('310', '483', 'pjField', '2', 'title', 'Other', 'script'),
('311', '496', 'pjField', '2', 'title', 'GMT-12:00', 'script'),
('312', '497', 'pjField', '2', 'title', 'GMT-11:00', 'script'),
('313', '498', 'pjField', '2', 'title', 'GMT-10:00', 'script'),
('314', '499', 'pjField', '2', 'title', 'GMT-09:00', 'script'),
('315', '500', 'pjField', '2', 'title', 'GMT-08:00', 'script'),
('316', '501', 'pjField', '2', 'title', 'GMT-07:00', 'script'),
('317', '502', 'pjField', '2', 'title', 'GMT-06:00', 'script'),
('318', '503', 'pjField', '2', 'title', 'GMT-05:00', 'script'),
('319', '504', 'pjField', '2', 'title', 'GMT-04:00', 'script'),
('320', '505', 'pjField', '2', 'title', 'GMT-03:00', 'script'),
('321', '506', 'pjField', '2', 'title', 'GMT-02:00', 'script'),
('322', '507', 'pjField', '2', 'title', 'GMT-01:00', 'script'),
('323', '508', 'pjField', '2', 'title', 'GMT', 'script'),
('324', '509', 'pjField', '2', 'title', 'GMT+01:00', 'script'),
('325', '510', 'pjField', '2', 'title', 'GMT+02:00', 'script'),
('326', '511', 'pjField', '2', 'title', 'GMT+03:00', 'script'),
('327', '512', 'pjField', '2', 'title', 'GMT+04:00', 'script'),
('328', '513', 'pjField', '2', 'title', 'GMT+05:00', 'script'),
('329', '514', 'pjField', '2', 'title', 'GMT+06:00', 'script'),
('330', '515', 'pjField', '2', 'title', 'GMT+07:00', 'script'),
('331', '516', 'pjField', '2', 'title', 'GMT+08:00', 'script'),
('332', '517', 'pjField', '2', 'title', 'GMT+09:00', 'script'),
('333', '518', 'pjField', '2', 'title', 'GMT+10:00', 'script'),
('334', '519', 'pjField', '2', 'title', 'GMT+11:00', 'script'),
('335', '520', 'pjField', '2', 'title', 'GMT+12:00', 'script'),
('336', '521', 'pjField', '2', 'title', 'GMT+13:00', 'script'),
('337', '540', 'pjField', '2', 'title', 'User updated!', 'script'),
('338', '541', 'pjField', '2', 'title', 'User added!', 'script'),
('339', '542', 'pjField', '2', 'title', 'User failed to add.', 'script'),
('340', '543', 'pjField', '2', 'title', 'User not found.', 'script'),
('341', '552', 'pjField', '2', 'title', 'Backup', 'script'),
('342', '553', 'pjField', '2', 'title', 'Backup complete!', 'script'),
('343', '554', 'pjField', '2', 'title', 'Backup failed!', 'script'),
('344', '555', 'pjField', '2', 'title', 'Backup failed!', 'script'),
('345', '556', 'pjField', '2', 'title', 'Account not found!', 'script'),
('346', '557', 'pjField', '2', 'title', 'Password send!', 'script'),
('347', '558', 'pjField', '2', 'title', 'Password not send!', 'script'),
('348', '559', 'pjField', '2', 'title', 'Profile updated!', 'script'),
('349', '578', 'pjField', '2', 'title', 'All the changes made to this user have been saved.', 'script'),
('350', '579', 'pjField', '2', 'title', 'All the changes made to this user have been saved.', 'script'),
('351', '580', 'pjField', '2', 'title', 'We are sorry, but the user has not been added.', 'script'),
('352', '581', 'pjField', '2', 'title', 'User your looking for is missing.', 'script'),
('353', '589', 'pjField', '2', 'title', 'All the changes made to titles have been saved.', 'script'),
('354', '590', 'pjField', '2', 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
('355', '591', 'pjField', '2', 'title', 'All backup files have been saved.', 'script'),
('356', '592', 'pjField', '2', 'title', 'No option was selected.', 'script'),
('357', '593', 'pjField', '2', 'title', 'Backup not performed.', 'script'),
('358', '594', 'pjField', '2', 'title', 'Given email address is not associated with any account.', 'script'),
('359', '595', 'pjField', '2', 'title', 'For further instructions please check your mailbox.', 'script'),
('360', '596', 'pjField', '2', 'title', 'We''re sorry, please try again later.', 'script'),
('361', '597', 'pjField', '2', 'title', 'All the changes made to your profile have been saved.', 'script'),
('362', '627', 'pjField', '2', 'title', 'January', 'script'),
('363', '628', 'pjField', '2', 'title', 'February', 'script'),
('364', '629', 'pjField', '2', 'title', 'March', 'script'),
('365', '630', 'pjField', '2', 'title', 'April', 'script'),
('366', '631', 'pjField', '2', 'title', 'May', 'script'),
('367', '632', 'pjField', '2', 'title', 'June', 'script'),
('368', '633', 'pjField', '2', 'title', 'July', 'script'),
('369', '634', 'pjField', '2', 'title', 'August', 'script'),
('370', '635', 'pjField', '2', 'title', 'September', 'script'),
('371', '636', 'pjField', '2', 'title', 'October', 'script'),
('372', '637', 'pjField', '2', 'title', 'November', 'script'),
('373', '638', 'pjField', '2', 'title', 'December', 'script'),
('374', '639', 'pjField', '2', 'title', 'Sunday', 'script'),
('375', '640', 'pjField', '2', 'title', 'Monday', 'script'),
('376', '641', 'pjField', '2', 'title', 'Tuesday', 'script'),
('377', '642', 'pjField', '2', 'title', 'Wednesday', 'script'),
('378', '643', 'pjField', '2', 'title', 'Thursday', 'script'),
('379', '644', 'pjField', '2', 'title', 'Friday', 'script'),
('380', '645', 'pjField', '2', 'title', 'Saturday', 'script'),
('381', '646', 'pjField', '2', 'title', 'S', 'script'),
('382', '647', 'pjField', '2', 'title', 'M', 'script'),
('383', '648', 'pjField', '2', 'title', 'T', 'script'),
('384', '649', 'pjField', '2', 'title', 'W', 'script'),
('385', '650', 'pjField', '2', 'title', 'T', 'script'),
('386', '651', 'pjField', '2', 'title', 'F', 'script'),
('387', '652', 'pjField', '2', 'title', 'S', 'script'),
('388', '653', 'pjField', '2', 'title', 'Jan', 'script'),
('389', '654', 'pjField', '2', 'title', 'Feb', 'script'),
('390', '655', 'pjField', '2', 'title', 'Mar', 'script'),
('391', '656', 'pjField', '2', 'title', 'Apr', 'script'),
('392', '657', 'pjField', '2', 'title', 'May', 'script'),
('393', '658', 'pjField', '2', 'title', 'Jun', 'script'),
('394', '659', 'pjField', '2', 'title', 'Jul', 'script'),
('395', '660', 'pjField', '2', 'title', 'Aug', 'script'),
('396', '661', 'pjField', '2', 'title', 'Sep', 'script'),
('397', '662', 'pjField', '2', 'title', 'Oct', 'script'),
('398', '663', 'pjField', '2', 'title', 'Nov', 'script'),
('399', '664', 'pjField', '2', 'title', 'Dec', 'script'),
('400', '665', 'pjField', '2', 'title', 'You are not loged in.', 'script'),
('401', '666', 'pjField', '2', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('402', '667', 'pjField', '2', 'title', 'Empty resultset.', 'script'),
('403', '668', 'pjField', '2', 'title', 'The operation is not allowed in demo mode.', 'script'),
('404', '669', 'pjField', '2', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('405', '670', 'pjField', '2', 'title', 'No permisions to edit the property', 'script'),
('406', '671', 'pjField', '2', 'title', 'No permisions to edit the reservation', 'script'),
('407', '672', 'pjField', '2', 'title', 'No reservation found', 'script'),
('408', '673', 'pjField', '2', 'title', 'No property for the reservation found', 'script'),
('409', '674', 'pjField', '2', 'title', 'Your registration was successfull.', 'script'),
('410', '675', 'pjField', '2', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('411', '676', 'pjField', '2', 'title', 'E-Mail address already exist', 'script'),
('412', '677', 'pjField', '2', 'title', 'Wrong username or password', 'script'),
('413', '678', 'pjField', '2', 'title', 'Access denied', 'script'),
('414', '679', 'pjField', '2', 'title', 'Account is disabled', 'script'),
('415', '907', 'pjField', '1', 'title', 'Arrays titles', 'script'),
('416', '907', 'pjField', '2', 'title', 'Arrays titles', 'script'),
('417', '908', 'pjField', '1', 'title', 'Languages Arrays Title', 'script'),
('418', '908', 'pjField', '2', 'title', 'Languages Arrays Title', 'script'),
('419', '909', 'pjField', '1', 'title', 'Languages Array Body', 'script'),
('420', '909', 'pjField', '2', 'title', 'Languages Array Body', 'script'),
('421', '910', 'pjField', '1', 'title', 'Back', 'script'),
('422', '910', 'pjField', '2', 'title', 'Back', 'script'),
('423', '982', 'pjField', '1', 'title', 'Order', 'script'),
('424', '982', 'pjField', '2', 'title', 'Order', 'script'),
('425', '983', 'pjField', '1', 'title', 'Is default', 'script'),
('426', '983', 'pjField', '2', 'title', 'Is default', 'script'),
('427', '984', 'pjField', '1', 'title', 'Flag', 'script'),
('428', '984', 'pjField', '2', 'title', 'Flag', 'script'),
('429', '985', 'pjField', '1', 'title', 'Title', 'script'),
('430', '985', 'pjField', '2', 'title', 'Title', 'script'),
('431', '986', 'pjField', '1', 'title', 'Delete', 'script'),
('432', '986', 'pjField', '2', 'title', 'Delete', 'script'),
('433', '990', 'pjField', '1', 'title', 'Continue', 'script'),
('434', '990', 'pjField', '2', 'title', 'Continue', 'script'),
('435', '992', 'pjField', '1', 'title', 'Email address is already in use', 'script'),
('436', '992', 'pjField', '2', 'title', 'Email address is already in use', 'script'),
('437', '993', 'pjField', '1', 'title', 'Revert status', 'script'),
('438', '993', 'pjField', '2', 'title', 'Revert status', 'script'),
('439', '994', 'pjField', '1', 'title', 'Export', 'script'),
('440', '994', 'pjField', '2', 'title', 'Export', 'script'),
('441', '5', 'pjField', '3', 'title', 'Username', 'script'),
('442', '6', 'pjField', '3', 'title', 'Password', 'script'),
('443', '7', 'pjField', '3', 'title', 'Email', 'script'),
('444', '8', 'pjField', '3', 'title', 'URL', 'script'),
('445', '13', 'pjField', '3', 'title', 'DateTime', 'script'),
('446', '16', 'pjField', '3', 'title', 'Save', 'script'),
('447', '17', 'pjField', '3', 'title', 'Reset', 'script'),
('448', '18', 'pjField', '3', 'title', 'Add language', 'script'),
('449', '22', 'pjField', '3', 'title', 'Multi Lang', 'script'),
('450', '23', 'pjField', '3', 'title', 'Plugins', 'script'),
('451', '24', 'pjField', '3', 'title', 'Users', 'script'),
('452', '25', 'pjField', '3', 'title', 'Options', 'script'),
('453', '26', 'pjField', '3', 'title', 'Logout', 'script'),
('454', '31', 'pjField', '3', 'title', 'Update', 'script'),
('455', '36', 'pjField', '3', 'title', 'Choose', 'script'),
('456', '37', 'pjField', '3', 'title', 'Search', 'script'),
('457', '40', 'pjField', '3', 'title', 'Back-end titles', 'script'),
('458', '41', 'pjField', '3', 'title', 'Front-end titles', 'script'),
('459', '42', 'pjField', '3', 'title', 'Languages', 'script'),
('460', '44', 'pjField', '3', 'title', 'Admin Login', 'script'),
('461', '45', 'pjField', '3', 'title', 'Login', 'script'),
('462', '47', 'pjField', '3', 'title', 'Dashboard', 'script'),
('463', '57', 'pjField', '3', 'title', 'Option list', 'script'),
('464', '58', 'pjField', '3', 'title', 'Add +', 'script'),
('465', '62', 'pjField', '3', 'title', 'Delete', 'script'),
('466', '65', 'pjField', '3', 'title', 'Type', 'script'),
('467', '66', 'pjField', '3', 'title', 'Name', 'script'),
('468', '67', 'pjField', '3', 'title', 'Role', 'script'),
('469', '68', 'pjField', '3', 'title', 'Status', 'script'),
('470', '69', 'pjField', '3', 'title', 'Is confirmed', 'script'),
('471', '70', 'pjField', '3', 'title', 'Update user', 'script'),
('472', '71', 'pjField', '3', 'title', 'Add user', 'script'),
('473', '72', 'pjField', '3', 'title', 'Value', 'script'),
('474', '73', 'pjField', '3', 'title', 'Option', 'script'),
('475', '74', 'pjField', '3', 'title', 'days', 'script'),
('476', '115', 'pjField', '3', 'title', 'Languages', 'script'),
('477', '116', 'pjField', '3', 'title', 'Yes', 'script'),
('478', '117', 'pjField', '3', 'title', 'No', 'script'),
('479', '338', 'pjField', '3', 'title', 'Error', 'script'),
('480', '347', 'pjField', '3', 'title', '&laquo; Back', 'script'),
('481', '355', 'pjField', '3', 'title', 'Cancel', 'script'),
('482', '356', 'pjField', '3', 'title', 'Forgot password', 'script'),
('483', '357', 'pjField', '3', 'title', 'Password reminder', 'script'),
('484', '358', 'pjField', '3', 'title', 'Send', 'script'),
('485', '359', 'pjField', '3', 'title', 'Password reminder', 'script'),
('486', '360', 'pjField', '3', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('487', '365', 'pjField', '3', 'title', 'Profile', 'script'),
('488', '380', 'pjField', '3', 'title', 'Languages Title', 'script'),
('489', '381', 'pjField', '3', 'title', 'Languages Body', 'script'),
('490', '382', 'pjField', '3', 'title', 'Languages Backend Title', 'script'),
('491', '383', 'pjField', '3', 'title', 'Languages Backend Body', 'script'),
('492', '384', 'pjField', '3', 'title', 'Languages Frontend Title', 'script'),
('493', '385', 'pjField', '3', 'title', 'Languages Frontend Body', 'script'),
('494', '386', 'pjField', '3', 'title', 'Listing Prices Title', 'script'),
('495', '387', 'pjField', '3', 'title', 'Listing Prices Body', 'script'),
('496', '388', 'pjField', '3', 'title', 'Listing Bookings Title', 'script'),
('497', '389', 'pjField', '3', 'title', 'Listing Bookings Body', 'script'),
('498', '390', 'pjField', '3', 'title', 'Listing Contact Title', 'script'),
('499', '391', 'pjField', '3', 'title', 'Listing Contact Body', 'script'),
('500', '392', 'pjField', '3', 'title', 'Listing Address Title', 'script'),
('501', '393', 'pjField', '3', 'title', 'Listing Address Body', 'script'),
('502', '395', 'pjField', '3', 'title', 'Extend exp.date Title', 'script'),
('503', '396', 'pjField', '3', 'title', 'Extend exp.date Body', 'script'),
('504', '408', 'pjField', '3', 'title', 'Backup', 'script'),
('505', '409', 'pjField', '3', 'title', 'Backup', 'script'),
('506', '410', 'pjField', '3', 'title', 'Backup database', 'script'),
('507', '411', 'pjField', '3', 'title', 'Backup files', 'script'),
('508', '412', 'pjField', '3', 'title', 'Choose Action', 'script'),
('509', '413', 'pjField', '3', 'title', 'Go to page:', 'script'),
('510', '414', 'pjField', '3', 'title', 'Total items:', 'script'),
('511', '415', 'pjField', '3', 'title', 'Items per page', 'script'),
('512', '416', 'pjField', '3', 'title', 'Prev page', 'script'),
('513', '417', 'pjField', '3', 'title', '&laquo; Prev', 'script'),
('514', '418', 'pjField', '3', 'title', 'Next page', 'script'),
('515', '419', 'pjField', '3', 'title', 'Next &raquo;', 'script'),
('516', '420', 'pjField', '3', 'title', 'Delete confirmation', 'script'),
('517', '421', 'pjField', '3', 'title', 'Are you sure you want to delete selected record?', 'script'),
('518', '422', 'pjField', '3', 'title', 'Action confirmation', 'script'),
('519', '423', 'pjField', '3', 'title', 'OK', 'script'),
('520', '424', 'pjField', '3', 'title', 'Cancel', 'script'),
('521', '425', 'pjField', '3', 'title', 'Delete', 'script'),
('522', '426', 'pjField', '3', 'title', 'No records found', 'script'),
('523', '433', 'pjField', '3', 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
('524', '434', 'pjField', '3', 'title', 'IP address', 'script'),
('525', '435', 'pjField', '3', 'title', 'Registration date/time', 'script'),
('526', '441', 'pjField', '3', 'title', 'Currency', 'script'),
('527', '442', 'pjField', '3', 'title', 'Date format', 'script'),
('528', '451', 'pjField', '3', 'title', 'Timezone', 'script'),
('529', '452', 'pjField', '3', 'title', 'First day of the week', 'script'),
('530', '455', 'pjField', '3', 'title', 'Active', 'script'),
('531', '456', 'pjField', '3', 'title', 'Inactive', 'script'),
('532', '457', 'pjField', '3', 'title', 'Active', 'script'),
('533', '458', 'pjField', '3', 'title', 'Inactive', 'script'),
('534', '471', 'pjField', '3', 'title', 'Yes', 'script'),
('535', '472', 'pjField', '3', 'title', 'No', 'script'),
('536', '476', 'pjField', '3', 'title', 'Mr.', 'script'),
('537', '477', 'pjField', '3', 'title', 'Mrs.', 'script'),
('538', '478', 'pjField', '3', 'title', 'Miss', 'script'),
('539', '479', 'pjField', '3', 'title', 'Ms.', 'script'),
('540', '480', 'pjField', '3', 'title', 'Dr.', 'script'),
('541', '481', 'pjField', '3', 'title', 'Prof.', 'script'),
('542', '482', 'pjField', '3', 'title', 'Rev.', 'script'),
('543', '483', 'pjField', '3', 'title', 'Other', 'script'),
('544', '496', 'pjField', '3', 'title', 'GMT-12:00', 'script'),
('545', '497', 'pjField', '3', 'title', 'GMT-11:00', 'script'),
('546', '498', 'pjField', '3', 'title', 'GMT-10:00', 'script'),
('547', '499', 'pjField', '3', 'title', 'GMT-09:00', 'script'),
('548', '500', 'pjField', '3', 'title', 'GMT-08:00', 'script'),
('549', '501', 'pjField', '3', 'title', 'GMT-07:00', 'script'),
('550', '502', 'pjField', '3', 'title', 'GMT-06:00', 'script'),
('551', '503', 'pjField', '3', 'title', 'GMT-05:00', 'script'),
('552', '504', 'pjField', '3', 'title', 'GMT-04:00', 'script'),
('553', '505', 'pjField', '3', 'title', 'GMT-03:00', 'script'),
('554', '506', 'pjField', '3', 'title', 'GMT-02:00', 'script'),
('555', '507', 'pjField', '3', 'title', 'GMT-01:00', 'script'),
('556', '508', 'pjField', '3', 'title', 'GMT', 'script'),
('557', '509', 'pjField', '3', 'title', 'GMT+01:00', 'script'),
('558', '510', 'pjField', '3', 'title', 'GMT+02:00', 'script'),
('559', '511', 'pjField', '3', 'title', 'GMT+03:00', 'script'),
('560', '512', 'pjField', '3', 'title', 'GMT+04:00', 'script'),
('561', '513', 'pjField', '3', 'title', 'GMT+05:00', 'script'),
('562', '514', 'pjField', '3', 'title', 'GMT+06:00', 'script'),
('563', '515', 'pjField', '3', 'title', 'GMT+07:00', 'script'),
('564', '516', 'pjField', '3', 'title', 'GMT+08:00', 'script'),
('565', '517', 'pjField', '3', 'title', 'GMT+09:00', 'script'),
('566', '518', 'pjField', '3', 'title', 'GMT+10:00', 'script'),
('567', '519', 'pjField', '3', 'title', 'GMT+11:00', 'script'),
('568', '520', 'pjField', '3', 'title', 'GMT+12:00', 'script'),
('569', '521', 'pjField', '3', 'title', 'GMT+13:00', 'script'),
('570', '540', 'pjField', '3', 'title', 'User updated!', 'script'),
('571', '541', 'pjField', '3', 'title', 'User added!', 'script'),
('572', '542', 'pjField', '3', 'title', 'User failed to add.', 'script'),
('573', '543', 'pjField', '3', 'title', 'User not found.', 'script'),
('574', '552', 'pjField', '3', 'title', 'Backup', 'script'),
('575', '553', 'pjField', '3', 'title', 'Backup complete!', 'script'),
('576', '554', 'pjField', '3', 'title', 'Backup failed!', 'script'),
('577', '555', 'pjField', '3', 'title', 'Backup failed!', 'script'),
('578', '556', 'pjField', '3', 'title', 'Account not found!', 'script'),
('579', '557', 'pjField', '3', 'title', 'Password send!', 'script'),
('580', '558', 'pjField', '3', 'title', 'Password not send!', 'script'),
('581', '559', 'pjField', '3', 'title', 'Profile updated!', 'script'),
('582', '578', 'pjField', '3', 'title', 'All the changes made to this user have been saved.', 'script'),
('583', '579', 'pjField', '3', 'title', 'All the changes made to this user have been saved.', 'script'),
('584', '580', 'pjField', '3', 'title', 'We are sorry, but the user has not been added.', 'script'),
('585', '581', 'pjField', '3', 'title', 'User your looking for is missing.', 'script'),
('586', '589', 'pjField', '3', 'title', 'All the changes made to titles have been saved.', 'script'),
('587', '590', 'pjField', '3', 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
('588', '591', 'pjField', '3', 'title', 'All backup files have been saved.', 'script'),
('589', '592', 'pjField', '3', 'title', 'No option was selected.', 'script'),
('590', '593', 'pjField', '3', 'title', 'Backup not performed.', 'script'),
('591', '594', 'pjField', '3', 'title', 'Given email address is not associated with any account.', 'script'),
('592', '595', 'pjField', '3', 'title', 'For further instructions please check your mailbox.', 'script'),
('593', '596', 'pjField', '3', 'title', 'We''re sorry, please try again later.', 'script'),
('594', '597', 'pjField', '3', 'title', 'All the changes made to your profile have been saved.', 'script'),
('595', '627', 'pjField', '3', 'title', 'January', 'script'),
('596', '628', 'pjField', '3', 'title', 'February', 'script'),
('597', '629', 'pjField', '3', 'title', 'March', 'script'),
('598', '630', 'pjField', '3', 'title', 'April', 'script'),
('599', '631', 'pjField', '3', 'title', 'May', 'script'),
('600', '632', 'pjField', '3', 'title', 'June', 'script'),
('601', '633', 'pjField', '3', 'title', 'July', 'script'),
('602', '634', 'pjField', '3', 'title', 'August', 'script'),
('603', '635', 'pjField', '3', 'title', 'September', 'script'),
('604', '636', 'pjField', '3', 'title', 'October', 'script'),
('605', '637', 'pjField', '3', 'title', 'November', 'script'),
('606', '638', 'pjField', '3', 'title', 'December', 'script'),
('607', '639', 'pjField', '3', 'title', 'Sunday', 'script'),
('608', '640', 'pjField', '3', 'title', 'Monday', 'script'),
('609', '641', 'pjField', '3', 'title', 'Tuesday', 'script'),
('610', '642', 'pjField', '3', 'title', 'Wednesday', 'script'),
('611', '643', 'pjField', '3', 'title', 'Thursday', 'script'),
('612', '644', 'pjField', '3', 'title', 'Friday', 'script'),
('613', '645', 'pjField', '3', 'title', 'Saturday', 'script'),
('614', '646', 'pjField', '3', 'title', 'S', 'script'),
('615', '647', 'pjField', '3', 'title', 'M', 'script'),
('616', '648', 'pjField', '3', 'title', 'T', 'script'),
('617', '649', 'pjField', '3', 'title', 'W', 'script'),
('618', '650', 'pjField', '3', 'title', 'T', 'script'),
('619', '651', 'pjField', '3', 'title', 'F', 'script'),
('620', '652', 'pjField', '3', 'title', 'S', 'script'),
('621', '653', 'pjField', '3', 'title', 'Jan', 'script'),
('622', '654', 'pjField', '3', 'title', 'Feb', 'script'),
('623', '655', 'pjField', '3', 'title', 'Mar', 'script'),
('624', '656', 'pjField', '3', 'title', 'Apr', 'script'),
('625', '657', 'pjField', '3', 'title', 'May', 'script'),
('626', '658', 'pjField', '3', 'title', 'Jun', 'script'),
('627', '659', 'pjField', '3', 'title', 'Jul', 'script'),
('628', '660', 'pjField', '3', 'title', 'Aug', 'script'),
('629', '661', 'pjField', '3', 'title', 'Sep', 'script'),
('630', '662', 'pjField', '3', 'title', 'Oct', 'script'),
('631', '663', 'pjField', '3', 'title', 'Nov', 'script'),
('632', '664', 'pjField', '3', 'title', 'Dec', 'script'),
('633', '665', 'pjField', '3', 'title', 'You are not loged in.', 'script'),
('634', '666', 'pjField', '3', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('635', '667', 'pjField', '3', 'title', 'Empty resultset.', 'script'),
('636', '668', 'pjField', '3', 'title', 'The operation is not allowed in demo mode.', 'script'),
('637', '669', 'pjField', '3', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('638', '670', 'pjField', '3', 'title', 'No permisions to edit the property', 'script'),
('639', '671', 'pjField', '3', 'title', 'No permisions to edit the reservation', 'script'),
('640', '672', 'pjField', '3', 'title', 'No reservation found', 'script'),
('641', '673', 'pjField', '3', 'title', 'No property for the reservation found', 'script'),
('642', '674', 'pjField', '3', 'title', 'Your registration was successfull.', 'script'),
('643', '675', 'pjField', '3', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('644', '676', 'pjField', '3', 'title', 'E-Mail address already exist', 'script'),
('645', '677', 'pjField', '3', 'title', 'Wrong username or password', 'script'),
('646', '678', 'pjField', '3', 'title', 'Access denied', 'script'),
('647', '679', 'pjField', '3', 'title', 'Account is disabled', 'script'),
('648', '907', 'pjField', '3', 'title', 'Arrays titles', 'script'),
('649', '908', 'pjField', '3', 'title', 'Languages Arrays Title', 'script'),
('650', '909', 'pjField', '3', 'title', 'Languages Array Body', 'script'),
('651', '910', 'pjField', '3', 'title', 'Back', 'script'),
('652', '982', 'pjField', '3', 'title', 'Order', 'script'),
('653', '983', 'pjField', '3', 'title', 'Is default', 'script'),
('654', '984', 'pjField', '3', 'title', 'Flag', 'script'),
('655', '985', 'pjField', '3', 'title', 'Title', 'script'),
('656', '986', 'pjField', '3', 'title', 'Delete', 'script'),
('657', '990', 'pjField', '3', 'title', 'Continue', 'script'),
('658', '992', 'pjField', '3', 'title', 'Email address is already in use', 'script'),
('659', '993', 'pjField', '3', 'title', 'Revert status', 'script'),
('660', '994', 'pjField', '3', 'title', 'Export', 'script'),
('661', '995', 'pjField', '1', 'title', 'Send email', 'script'),
('662', '995', 'pjField', '2', 'title', 'Send email', 'script'),
('663', '995', 'pjField', '3', 'title', 'Send email', 'script'),
('664', '996', 'pjField', '1', 'title', 'SMTP Host', 'script'),
('665', '996', 'pjField', '2', 'title', 'SMTP Host', 'script'),
('666', '996', 'pjField', '3', 'title', 'SMTP Host', 'script'),
('667', '997', 'pjField', '1', 'title', 'SMTP Port', 'script'),
('668', '997', 'pjField', '2', 'title', 'SMTP Port', 'script'),
('669', '997', 'pjField', '3', 'title', 'SMTP Port', 'script'),
('670', '998', 'pjField', '1', 'title', 'SMTP Username', 'script'),
('671', '998', 'pjField', '2', 'title', 'SMTP Username', 'script'),
('672', '998', 'pjField', '3', 'title', 'SMTP Username', 'script'),
('673', '999', 'pjField', '1', 'title', 'SMTP Password', 'script'),
('674', '999', 'pjField', '2', 'title', 'SMTP Password', 'script'),
('675', '999', 'pjField', '3', 'title', 'SMTP Password', 'script'),
('676', '1200', 'pjField', '1', 'title', 'SMS', 'script'),
('677', '1200', 'pjField', '2', 'title', 'SMS', 'script'),
('678', '1200', 'pjField', '3', 'title', 'SMS', 'script'),
('679', '1201', 'pjField', '1', 'title', 'Invoice', 'script'),
('680', '1201', 'pjField', '2', 'title', 'Invoice', 'script'),
('681', '1201', 'pjField', '3', 'title', 'Invoice', 'script'),
('682', '1202', 'pjField', '1', 'title', 'Bookings', 'script'),
('683', '1202', 'pjField', '2', 'title', 'Bookings', 'script'),
('684', '1202', 'pjField', '3', 'title', 'Bookings', 'script'),
('685', '1203', 'pjField', '1', 'title', 'Rooms', 'script'),
('686', '1203', 'pjField', '2', 'title', 'Rooms', 'script'),
('687', '1203', 'pjField', '3', 'title', 'Rooms', 'script'),
('688', '1231', 'pjField', '1', 'title', 'Prices', 'script'),
('689', '1231', 'pjField', '2', 'title', 'Prices', 'script'),
('690', '1231', 'pjField', '3', 'title', 'Prices', 'script'),
('691', '1232', 'pjField', '1', 'title', 'Extras', 'script'),
('692', '1232', 'pjField', '2', 'title', 'Extras', 'script'),
('693', '1232', 'pjField', '3', 'title', 'Extras', 'script'),
('694', '1233', 'pjField', '1', 'title', 'Limits', 'script'),
('695', '1233', 'pjField', '2', 'title', 'Limits', 'script'),
('696', '1233', 'pjField', '3', 'title', 'Limits', 'script'),
('697', '1234', 'pjField', '1', 'title', 'Discounts', 'script'),
('698', '1234', 'pjField', '2', 'title', 'Discounts', 'script'),
('699', '1234', 'pjField', '3', 'title', 'Discounts', 'script'),
('700', '1235', 'pjField', '1', 'title', 'Per day', 'script'),
('701', '1235', 'pjField', '2', 'title', 'Per day', 'script'),
('702', '1235', 'pjField', '3', 'title', 'Per day', 'script'),
('703', '1236', 'pjField', '1', 'title', 'Per booking', 'script'),
('704', '1236', 'pjField', '2', 'title', 'Per booking', 'script'),
('705', '1236', 'pjField', '3', 'title', 'Per booking', 'script'),
('706', '1237', 'pjField', '1', 'title', 'Per person', 'script'),
('707', '1237', 'pjField', '2', 'title', 'Per person', 'script'),
('708', '1237', 'pjField', '3', 'title', 'Per person', 'script'),
('709', '1238', 'pjField', '1', 'title', 'Per day / per person', 'script'),
('710', '1238', 'pjField', '2', 'title', 'Per day / per person', 'script'),
('711', '1238', 'pjField', '3', 'title', 'Per day / per person', 'script'),
('712', '1239', 'pjField', '1', 'title', 'Price', 'script'),
('713', '1239', 'pjField', '2', 'title', 'Price', 'script'),
('714', '1239', 'pjField', '3', 'title', 'Price', 'script'),
('715', '1240', 'pjField', '1', 'title', 'Name', 'script'),
('716', '1240', 'pjField', '2', 'title', 'Name', 'script'),
('717', '1240', 'pjField', '3', 'title', 'Name', 'script'),
('718', '1241', 'pjField', '1', 'title', 'Manage extras', 'script'),
('719', '1241', 'pjField', '2', 'title', 'Manage extras', 'script'),
('720', '1241', 'pjField', '3', 'title', 'Manage extras', 'script'),
('721', '1242', 'pjField', '1', 'title', 'These are special items and/or services which your clients can book. For example a breakfast, airport pickup, or anything else that you offer.', 'script'),
('722', '1242', 'pjField', '2', 'title', 'These are special items and/or services which your clients can book. For example a breakfast, airport pickup, or anything else that you offer.', 'script'),
('723', '1242', 'pjField', '3', 'title', 'These are special items and/or services which your clients can book. For example a breakfast, airport pickup, or anything else that you offer.', 'script'),
('724', '1243', 'pjField', '1', 'title', 'Add an extra', 'script'),
('725', '1243', 'pjField', '2', 'title', 'Add an extra', 'script'),
('726', '1243', 'pjField', '3', 'title', 'Add an extra', 'script'),
('727', '1244', 'pjField', '1', 'title', 'Add name and price for the extra. You can also set how the price to be calculated - once for the whole booking, per day only, per day and per person or just per person.', 'script'),
('728', '1244', 'pjField', '2', 'title', 'Add name and price for the extra. You can also set how the price to be calculated - once for the whole booking, per day only, per day and per person or just per person.', 'script'),
('729', '1244', 'pjField', '3', 'title', 'Add name and price for the extra. You can also set how the price to be calculated - once for the whole booking, per day only, per day and per person or just per person.', 'script'),
('730', '1245', 'pjField', '1', 'title', 'Update an extra', 'script'),
('731', '1245', 'pjField', '2', 'title', 'Update an extra', 'script'),
('732', '1245', 'pjField', '3', 'title', 'Update an extra', 'script'),
('733', '1246', 'pjField', '1', 'title', 'Update an extra and click Save.', 'script'),
('734', '1246', 'pjField', '2', 'title', 'Update an extra and click Save.', 'script'),
('735', '1246', 'pjField', '3', 'title', 'Update an extra and click Save.', 'script'),
('736', '1247', 'pjField', '1', 'title', 'Per', 'script'),
('737', '1247', 'pjField', '2', 'title', 'Per', 'script'),
('738', '1247', 'pjField', '3', 'title', 'Per', 'script'),
('739', '1248', 'pjField', '1', 'title', 'Delete selected', 'script'),
('740', '1248', 'pjField', '2', 'title', 'Delete selected', 'script'),
('741', '1248', 'pjField', '3', 'title', 'Delete selected', 'script'),
('742', '1249', 'pjField', '1', 'title', 'Are you sure you want to delete selected items?', 'script'),
('743', '1249', 'pjField', '2', 'title', 'Are you sure you want to delete selected items?', 'script'),
('744', '1249', 'pjField', '3', 'title', 'Are you sure you want to delete selected items?', 'script'),
('745', '1250', 'pjField', '1', 'title', 'Extra updated!', 'script'),
('746', '1250', 'pjField', '2', 'title', 'Extra updated!', 'script'),
('747', '1250', 'pjField', '3', 'title', 'Extra updated!', 'script'),
('748', '1252', 'pjField', '1', 'title', 'All the changes made to this extra have been saved.', 'script'),
('749', '1252', 'pjField', '2', 'title', 'All the changes made to this extra have been saved.', 'script'),
('750', '1252', 'pjField', '3', 'title', 'All the changes made to this extra have been saved.', 'script'),
('751', '1253', 'pjField', '1', 'title', 'Extra added!', 'script'),
('752', '1253', 'pjField', '2', 'title', 'Extra added!', 'script'),
('753', '1253', 'pjField', '3', 'title', 'Extra added!', 'script'),
('754', '1254', 'pjField', '1', 'title', 'All the changes made to this extra have been saved.', 'script'),
('755', '1254', 'pjField', '2', 'title', 'All the changes made to this extra have been saved.', 'script'),
('756', '1254', 'pjField', '3', 'title', 'All the changes made to this extra have been saved.', 'script'),
('757', '1255', 'pjField', '1', 'title', 'Extra failed to add.', 'script'),
('758', '1255', 'pjField', '2', 'title', 'Extra failed to add.', 'script'),
('759', '1255', 'pjField', '3', 'title', 'Extra failed to add.', 'script'),
('760', '1256', 'pjField', '1', 'title', 'We are sorry, but the extra has not been added.', 'script'),
('761', '1256', 'pjField', '2', 'title', 'We are sorry, but the extra has not been added.', 'script'),
('762', '1256', 'pjField', '3', 'title', 'We are sorry, but the extra has not been added.', 'script'),
('763', '1257', 'pjField', '1', 'title', 'Extra failed to update.', 'script'),
('764', '1257', 'pjField', '2', 'title', 'Extra failed to update.', 'script'),
('765', '1257', 'pjField', '3', 'title', 'Extra failed to update.', 'script'),
('766', '1258', 'pjField', '1', 'title', 'We are sorry, but the extra has not been updated.', 'script'),
('767', '1258', 'pjField', '2', 'title', 'We are sorry, but the extra has not been updated.', 'script'),
('768', '1258', 'pjField', '3', 'title', 'We are sorry, but the extra has not been updated.', 'script'),
('769', '1259', 'pjField', '1', 'title', 'Extra not found.', 'script'),
('770', '1259', 'pjField', '2', 'title', 'Extra not found.', 'script'),
('771', '1259', 'pjField', '3', 'title', 'Extra not found.', 'script'),
('772', '1260', 'pjField', '1', 'title', 'Extra your looking for is missing.', 'script'),
('773', '1260', 'pjField', '2', 'title', 'Extra your looking for is missing.', 'script'),
('774', '1260', 'pjField', '3', 'title', 'Extra your looking for is missing.', 'script'),
('775', '1263', 'pjField', '1', 'title', 'Country updated!', 'script'),
('776', '1263', 'pjField', '2', 'title', 'Country updated!', 'script'),
('777', '1263', 'pjField', '3', 'title', 'Country updated!', 'script'),
('778', '1264', 'pjField', '1', 'title', 'Country added!', 'script'),
('779', '1264', 'pjField', '2', 'title', 'Country added!', 'script'),
('780', '1264', 'pjField', '3', 'title', 'Country added!', 'script'),
('781', '1265', 'pjField', '1', 'title', 'Country failed to add.', 'script'),
('782', '1265', 'pjField', '2', 'title', 'Country failed to add.', 'script'),
('783', '1265', 'pjField', '3', 'title', 'Country failed to add.', 'script'),
('784', '1266', 'pjField', '1', 'title', 'Country not found.', 'script'),
('785', '1266', 'pjField', '2', 'title', 'Country not found.', 'script'),
('786', '1266', 'pjField', '3', 'title', 'Country not found.', 'script'),
('787', '1267', 'pjField', '1', 'title', 'All the changes made to this country have been saved.', 'script'),
('788', '1267', 'pjField', '2', 'title', 'All the changes made to this country have been saved.', 'script'),
('789', '1267', 'pjField', '3', 'title', 'All the changes made to this country have been saved.', 'script'),
('790', '1268', 'pjField', '1', 'title', 'All the changes made to this country have been saved.', 'script'),
('791', '1268', 'pjField', '2', 'title', 'All the changes made to this country have been saved.', 'script'),
('792', '1268', 'pjField', '3', 'title', 'All the changes made to this user have been saved.', 'script'),
('793', '1269', 'pjField', '1', 'title', 'We are sorry, but the country has not been added.', 'script'),
('794', '1269', 'pjField', '2', 'title', 'We are sorry, but the country has not been added.', 'script'),
('795', '1269', 'pjField', '3', 'title', 'We are sorry, but the country has not been added.', 'script'),
('796', '1270', 'pjField', '1', 'title', 'Country your looking for is missing.', 'script'),
('797', '1270', 'pjField', '2', 'title', 'Country your looking for is missing.', 'script'),
('798', '1270', 'pjField', '3', 'title', 'Country your looking for is missing.', 'script'),
('799', '1271', 'pjField', '1', 'title', 'Type', 'script'),
('800', '1271', 'pjField', '2', 'title', 'Type', 'script'),
('801', '1271', 'pjField', '3', 'title', 'Type', 'script'),
('802', '1272', 'pjField', '1', 'title', 'Adults', 'script'),
('803', '1272', 'pjField', '2', 'title', 'Adults', 'script'),
('804', '1272', 'pjField', '3', 'title', 'Adults', 'script'),
('805', '1273', 'pjField', '1', 'title', 'Children', 'script'),
('806', '1273', 'pjField', '2', 'title', 'Children', 'script'),
('807', '1273', 'pjField', '3', 'title', 'Children', 'script'),
('808', '1274', 'pjField', '1', 'title', 'Room count', 'script'),
('809', '1274', 'pjField', '2', 'title', 'Room count', 'script'),
('810', '1274', 'pjField', '3', 'title', 'Room count', 'script'),
('811', '1275', 'pjField', '1', 'title', 'Add room', 'script'),
('812', '1275', 'pjField', '2', 'title', 'Add room', 'script'),
('813', '1275', 'pjField', '3', 'title', 'Add room', 'script'),
('814', '1276', 'pjField', '1', 'title', 'Update room', 'script'),
('815', '1276', 'pjField', '2', 'title', 'Update room', 'script'),
('816', '1276', 'pjField', '3', 'title', 'Update room', 'script'),
('817', '1278', 'pjField', '1', 'title', 'Description', 'script'),
('818', '1278', 'pjField', '2', 'title', 'Description', 'script'),
('819', '1278', 'pjField', '3', 'title', 'Description', 'script'),
('820', '1279', 'pjField', '1', 'title', 'Room updated!', 'script'),
('821', '1279', 'pjField', '2', 'title', 'Room updated!', 'script'),
('822', '1279', 'pjField', '3', 'title', 'Room updated!', 'script'),
('823', '1280', 'pjField', '1', 'title', 'Room added!', 'script'),
('824', '1280', 'pjField', '2', 'title', 'Room added!', 'script'),
('825', '1280', 'pjField', '3', 'title', 'Room added!', 'script'),
('826', '1281', 'pjField', '1', 'title', 'Room failed to add.', 'script'),
('827', '1281', 'pjField', '2', 'title', 'Room failed to add.', 'script'),
('828', '1281', 'pjField', '3', 'title', 'Room failed to add.', 'script'),
('829', '1282', 'pjField', '1', 'title', 'Room not found.', 'script'),
('830', '1282', 'pjField', '2', 'title', 'Room not found.', 'script'),
('831', '1282', 'pjField', '3', 'title', 'Room not found.', 'script'),
('832', '1283', 'pjField', '1', 'title', 'Room details have been saved.', 'script'),
('833', '1283', 'pjField', '2', 'title', 'Room details have been saved.', 'script'),
('834', '1283', 'pjField', '3', 'title', 'Room details have been saved.', 'script'),
('835', '1284', 'pjField', '1', 'title', 'Room details have been saved.', 'script'),
('836', '1284', 'pjField', '2', 'title', 'Room details have been saved.', 'script'),
('837', '1284', 'pjField', '3', 'title', 'Room details have been saved.', 'script'),
('838', '1285', 'pjField', '1', 'title', 'We are sorry, but the room has not been added.', 'script'),
('839', '1285', 'pjField', '2', 'title', 'We are sorry, but the room has not been added.', 'script'),
('840', '1285', 'pjField', '3', 'title', 'We are sorry, but the room has not been added.', 'script'),
('841', '1286', 'pjField', '1', 'title', 'Room your looking for is missing.', 'script'),
('842', '1286', 'pjField', '2', 'title', 'Room your looking for is missing.', 'script'),
('843', '1286', 'pjField', '3', 'title', 'Room your looking for is missing.', 'script'),
('844', '1287', 'pjField', '1', 'title', 'Install', 'script'),
('845', '1287', 'pjField', '2', 'title', 'Install', 'script'),
('846', '1287', 'pjField', '3', 'title', 'Install', 'script'),
('847', '1288', 'pjField', '1', 'title', 'Preview', 'script'),
('848', '1288', 'pjField', '2', 'title', 'Preview', 'script'),
('849', '1288', 'pjField', '3', 'title', 'Preview', 'script'),
('850', '1289', 'pjField', '1', 'title', 'Photos', 'script'),
('851', '1289', 'pjField', '2', 'title', 'Photos', 'script'),
('852', '1289', 'pjField', '3', 'title', 'Photos', 'script'),
('853', '1290', 'pjField', '1', 'title', 'Upload as many images as you want for this property. You can resize, crop, rotate, watermark and complress the uploaded images. Drag & drop to change their order.', 'script'),
('854', '1290', 'pjField', '2', 'title', 'Upload as many images as you want for this property. You can resize, crop, rotate, watermark and complress the uploaded images. Drag & drop to change their order.', 'script'),
('855', '1290', 'pjField', '3', 'title', 'Upload as many images as you want for this property. You can resize, crop, rotate, watermark and complress the uploaded images. Drag & drop to change their order.', 'script'),
('856', '1291', 'pjField', '1', 'title', 'Add booking', 'script'),
('857', '1291', 'pjField', '2', 'title', 'Add booking', 'script'),
('858', '1291', 'pjField', '3', 'title', 'Add booking', 'script'),
('859', '1292', 'pjField', '1', 'title', 'Update booking', 'script'),
('860', '1292', 'pjField', '2', 'title', 'Update booking', 'script'),
('861', '1292', 'pjField', '3', 'title', 'Update booking', 'script'),
('862', '1293', 'pjField', '1', 'title', 'Confirmed', 'script'),
('863', '1293', 'pjField', '2', 'title', 'Confirmed', 'script'),
('864', '1293', 'pjField', '3', 'title', 'Confirmed', 'script'),
('865', '1294', 'pjField', '1', 'title', 'Pending', 'script'),
('866', '1294', 'pjField', '2', 'title', 'Pending', 'script'),
('867', '1294', 'pjField', '3', 'title', 'Pending', 'script'),
('868', '1295', 'pjField', '1', 'title', 'Cancelled', 'script'),
('869', '1295', 'pjField', '2', 'title', 'Cancelled', 'script'),
('870', '1295', 'pjField', '3', 'title', 'Cancelled', 'script'),
('871', '1296', 'pjField', '1', 'title', 'Booking dates', 'script'),
('872', '1296', 'pjField', '2', 'title', 'Booking dates', 'script'),
('873', '1296', 'pjField', '3', 'title', 'Booking dates', 'script'),
('874', '1297', 'pjField', '1', 'title', 'Client', 'script'),
('875', '1297', 'pjField', '2', 'title', 'Client', 'script'),
('876', '1297', 'pjField', '3', 'title', 'Client', 'script'),
('877', '1298', 'pjField', '1', 'title', 'Rooms', 'script'),
('878', '1298', 'pjField', '2', 'title', 'Rooms', 'script'),
('879', '1298', 'pjField', '3', 'title', 'Rooms', 'script'),
('880', '1299', 'pjField', '1', 'title', 'First Name', 'script'),
('881', '1299', 'pjField', '2', 'title', 'First Name', 'script'),
('882', '1299', 'pjField', '3', 'title', 'First Name', 'script'),
('883', '1300', 'pjField', '1', 'title', 'Last Name', 'script'),
('884', '1300', 'pjField', '2', 'title', 'Last Name', 'script'),
('885', '1300', 'pjField', '3', 'title', 'Last Name', 'script'),
('886', '1301', 'pjField', '1', 'title', 'Title', 'script'),
('887', '1301', 'pjField', '2', 'title', 'Title', 'script'),
('888', '1301', 'pjField', '3', 'title', 'Title', 'script'),
('889', '1302', 'pjField', '1', 'title', 'Email', 'script'),
('890', '1302', 'pjField', '2', 'title', 'Email', 'script'),
('891', '1302', 'pjField', '3', 'title', 'Email', 'script'),
('892', '1303', 'pjField', '1', 'title', 'Phone', 'script'),
('893', '1303', 'pjField', '2', 'title', 'Phone', 'script'),
('894', '1303', 'pjField', '3', 'title', 'Phone', 'script'),
('895', '1304', 'pjField', '1', 'title', 'Company Name', 'script'),
('896', '1304', 'pjField', '2', 'title', 'Company Name', 'script'),
('897', '1304', 'pjField', '3', 'title', 'Company Name', 'script'),
('898', '1305', 'pjField', '1', 'title', 'Postcode/Zip', 'script'),
('899', '1305', 'pjField', '2', 'title', 'Postcode/Zip', 'script'),
('900', '1305', 'pjField', '3', 'title', 'Postcode/Zip', 'script'),
('901', '1306', 'pjField', '1', 'title', 'City', 'script'),
('902', '1306', 'pjField', '2', 'title', 'City', 'script'),
('903', '1306', 'pjField', '3', 'title', 'City', 'script'),
('904', '1307', 'pjField', '1', 'title', 'County/Region/State', 'script'),
('905', '1307', 'pjField', '2', 'title', 'County/Region/State', 'script'),
('906', '1307', 'pjField', '3', 'title', 'County/Region/State', 'script'),
('907', '1308', 'pjField', '1', 'title', 'Country', 'script'),
('908', '1308', 'pjField', '2', 'title', 'Country', 'script'),
('909', '1308', 'pjField', '3', 'title', 'Country', 'script'),
('910', '1309', 'pjField', '1', 'title', 'Address Line 1', 'script'),
('911', '1309', 'pjField', '2', 'title', 'Address Line 1', 'script'),
('912', '1309', 'pjField', '3', 'title', 'Address Line 1', 'script'),
('913', '1310', 'pjField', '1', 'title', 'Arrival Time', 'script'),
('914', '1310', 'pjField', '2', 'title', 'Arrival Time', 'script'),
('915', '1310', 'pjField', '3', 'title', 'Arrival Time', 'script'),
('916', '1311', 'pjField', '1', 'title', 'Additional requirements', 'script'),
('917', '1311', 'pjField', '2', 'title', 'Additional requirements', 'script'),
('918', '1311', 'pjField', '3', 'title', 'Additional requirements', 'script'),
('919', '1312', 'pjField', '1', 'title', 'Status', 'script'),
('920', '1312', 'pjField', '2', 'title', 'Status', 'script'),
('921', '1312', 'pjField', '3', 'title', 'Status', 'script'),
('922', '1313', 'pjField', '1', 'title', 'Deposit', 'script'),
('923', '1313', 'pjField', '2', 'title', 'Deposit', 'script'),
('924', '1313', 'pjField', '3', 'title', 'Deposit', 'script'),
('925', '1314', 'pjField', '1', 'title', 'Tax', 'script'),
('926', '1314', 'pjField', '2', 'title', 'Tax', 'script'),
('927', '1314', 'pjField', '3', 'title', 'Tax', 'script'),
('928', '1315', 'pjField', '1', 'title', 'Total', 'script'),
('929', '1315', 'pjField', '2', 'title', 'Total', 'script'),
('930', '1315', 'pjField', '3', 'title', 'Total', 'script'),
('931', '1316', 'pjField', '1', 'title', 'Payment method', 'script'),
('932', '1316', 'pjField', '2', 'title', 'Payment method', 'script'),
('933', '1316', 'pjField', '3', 'title', 'Payment method', 'script'),
('934', '1317', 'pjField', '1', 'title', 'Date from', 'script'),
('935', '1317', 'pjField', '2', 'title', 'Date from', 'script'),
('936', '1317', 'pjField', '3', 'title', 'Date from', 'script'),
('937', '1318', 'pjField', '1', 'title', 'Date to', 'script'),
('938', '1318', 'pjField', '2', 'title', 'Date to', 'script'),
('939', '1318', 'pjField', '3', 'title', 'Date to', 'script'),
('940', '1319', 'pjField', '1', 'title', 'Room type', 'script'),
('941', '1319', 'pjField', '2', 'title', 'Room type', 'script'),
('942', '1319', 'pjField', '3', 'title', 'Room type', 'script'),
('943', '1320', 'pjField', '1', 'title', 'Paypal', 'script'),
('944', '1320', 'pjField', '2', 'title', 'Paypal', 'script'),
('945', '1320', 'pjField', '3', 'title', 'Paypal', 'script'),
('946', '1321', 'pjField', '1', 'title', 'Authorize.NET', 'script'),
('947', '1321', 'pjField', '2', 'title', 'Authorize.NET', 'script'),
('948', '1321', 'pjField', '3', 'title', 'Authorize.NET', 'script'),
('949', '1322', 'pjField', '1', 'title', 'Bank Account', 'script'),
('950', '1322', 'pjField', '2', 'title', 'Bank Account', 'script'),
('951', '1322', 'pjField', '3', 'title', 'Bank Account', 'script'),
('952', '1323', 'pjField', '1', 'title', 'Credit card', 'script'),
('953', '1323', 'pjField', '2', 'title', 'Credit card', 'script'),
('954', '1323', 'pjField', '3', 'title', 'Credit card', 'script'),
('955', '1324', 'pjField', '1', 'title', 'Client details', 'script'),
('956', '1324', 'pjField', '2', 'title', 'Client details', 'script'),
('957', '1324', 'pjField', '3', 'title', 'Client details', 'script'),
('958', '1325', 'pjField', '1', 'title', 'Booking details', 'script'),
('959', '1325', 'pjField', '2', 'title', 'Booking details', 'script'),
('960', '1325', 'pjField', '3', 'title', 'Booking details', 'script'),
('961', '1326', 'pjField', '1', 'title', 'Payment details', 'script'),
('962', '1326', 'pjField', '2', 'title', 'Payment details', 'script'),
('963', '1326', 'pjField', '3', 'title', 'Payment details', 'script'),
('964', '1327', 'pjField', '1', 'title', 'CC Exp.date', 'script'),
('965', '1327', 'pjField', '2', 'title', 'CC Exp.date', 'script'),
('966', '1327', 'pjField', '3', 'title', 'CC Exp.date', 'script'),
('967', '1328', 'pjField', '1', 'title', 'CC Number', 'script'),
('968', '1328', 'pjField', '2', 'title', 'CC Number', 'script'),
('969', '1328', 'pjField', '3', 'title', 'CC Number', 'script'),
('970', '1329', 'pjField', '1', 'title', 'CC Code', 'script'),
('971', '1329', 'pjField', '2', 'title', 'CC Code', 'script'),
('972', '1329', 'pjField', '3', 'title', 'CC Code', 'script'),
('973', '1330', 'pjField', '1', 'title', 'CC Type', 'script'),
('974', '1330', 'pjField', '2', 'title', 'CC Type', 'script'),
('975', '1330', 'pjField', '3', 'title', 'CC Type', 'script'),
('976', '1331', 'pjField', '1', 'title', 'Visa', 'script'),
('977', '1331', 'pjField', '2', 'title', 'Visa', 'script'),
('978', '1331', 'pjField', '3', 'title', 'Visa', 'script'),
('979', '1332', 'pjField', '1', 'title', 'MasterCard', 'script'),
('980', '1332', 'pjField', '2', 'title', 'MasterCard', 'script'),
('981', '1332', 'pjField', '3', 'title', 'MasterCard', 'script'),
('982', '1333', 'pjField', '1', 'title', 'AmericanExpress', 'script'),
('983', '1333', 'pjField', '2', 'title', 'AmericanExpress', 'script'),
('984', '1333', 'pjField', '3', 'title', 'AmericanExpress', 'script'),
('985', '1334', 'pjField', '1', 'title', 'Maestro', 'script'),
('986', '1334', 'pjField', '2', 'title', 'Maestro', 'script'),
('987', '1334', 'pjField', '3', 'title', 'Maestro', 'script'),
('988', '1335', 'pjField', '1', 'title', 'Room details', 'script'),
('989', '1335', 'pjField', '2', 'title', 'Room details', 'script'),
('990', '1335', 'pjField', '3', 'title', 'Room details', 'script'),
('991', '1336', 'pjField', '1', 'title', '+ Add room', 'script'),
('992', '1336', 'pjField', '2', 'title', '+ Add room', 'script'),
('993', '1336', 'pjField', '3', 'title', '+ Add room', 'script'),
('994', '1337', 'pjField', '1', 'title', 'Recalculate the price', 'script'),
('995', '1337', 'pjField', '2', 'title', 'Recalculate the price', 'script'),
('996', '1337', 'pjField', '3', 'title', 'Recalculate the price', 'script'),
('997', '1338', 'pjField', '1', 'title', 'Edit booking room', 'script'),
('998', '1338', 'pjField', '2', 'title', 'Edit booking room', 'script'),
('999', '1338', 'pjField', '3', 'title', 'Edit booking room', 'script'),
('1000', '1339', 'pjField', '1', 'title', 'Delete booking room', 'script'),
('1001', '1339', 'pjField', '2', 'title', 'Delete booking room', 'script'),
('1002', '1339', 'pjField', '3', 'title', 'Delete booking room', 'script'),
('1003', '1340', 'pjField', '1', 'title', 'Add booking room', 'script'),
('1004', '1340', 'pjField', '2', 'title', 'Add booking room', 'script'),
('1005', '1340', 'pjField', '3', 'title', 'Add booking room', 'script'),
('1006', '1341', 'pjField', '1', 'title', 'No rooms found', 'script'),
('1007', '1341', 'pjField', '2', 'title', 'No rooms found', 'script'),
('1008', '1341', 'pjField', '3', 'title', 'No rooms found', 'script'),
('1009', '1342', 'pjField', '1', 'title', 'There are not rooms added to this booking.', 'script'),
('1010', '1342', 'pjField', '2', 'title', 'There are not rooms added to this booking.', 'script'),
('1011', '1342', 'pjField', '3', 'title', 'There are not rooms added to this booking.', 'script'),
('1012', '1343', 'pjField', '1', 'title', 'Extra''s details', 'script'),
('1013', '1343', 'pjField', '2', 'title', 'Extra''s details', 'script'),
('1014', '1343', 'pjField', '3', 'title', 'Extra''s details', 'script'),
('1015', '1344', 'pjField', '1', 'title', 'Booking updated!', 'script'),
('1016', '1344', 'pjField', '2', 'title', 'Booking updated!', 'script'),
('1017', '1344', 'pjField', '3', 'title', 'Booking updated!', 'script'),
('1018', '1345', 'pjField', '1', 'title', 'Booking added!', 'script'),
('1019', '1345', 'pjField', '2', 'title', 'Booking added!', 'script'),
('1020', '1345', 'pjField', '3', 'title', 'Booking added!', 'script'),
('1021', '1346', 'pjField', '1', 'title', 'Booking failed to add.', 'script'),
('1022', '1346', 'pjField', '2', 'title', 'Booking failed to add.', 'script'),
('1023', '1346', 'pjField', '3', 'title', 'Booking failed to add.', 'script'),
('1024', '1347', 'pjField', '1', 'title', 'Booking not found.', 'script'),
('1025', '1347', 'pjField', '2', 'title', 'Booking not found.', 'script'),
('1026', '1347', 'pjField', '3', 'title', 'Booking not found.', 'script'),
('1027', '1348', 'pjField', '1', 'title', 'All the changes made to this booking have been saved.', 'script'),
('1028', '1348', 'pjField', '2', 'title', 'All the changes made to this booking have been saved.', 'script'),
('1029', '1348', 'pjField', '3', 'title', 'All the changes made to this booking have been saved.', 'script'),
('1030', '1349', 'pjField', '1', 'title', 'All the changes made to this booking have been saved.', 'script'),
('1031', '1349', 'pjField', '2', 'title', 'All the changes made to this booking have been saved.', 'script'),
('1032', '1349', 'pjField', '3', 'title', 'All the changes made to this booking have been saved.', 'script'),
('1033', '1350', 'pjField', '1', 'title', 'We are sorry, but the booking has not been added.', 'script'),
('1034', '1350', 'pjField', '2', 'title', 'We are sorry, but the booking has not been added.', 'script'),
('1035', '1350', 'pjField', '3', 'title', 'We are sorry, but the booking has not been added.', 'script'),
('1036', '1351', 'pjField', '1', 'title', 'Booking your looking for is missing.', 'script'),
('1037', '1351', 'pjField', '2', 'title', 'Booking your looking for is missing.', 'script'),
('1038', '1351', 'pjField', '3', 'title', 'Booking your looking for is missing.', 'script'),
('1039', '1352', 'pjField', '1', 'title', 'Date from', 'script'),
('1040', '1352', 'pjField', '2', 'title', 'Date from', 'script'),
('1041', '1352', 'pjField', '3', 'title', 'Date from', 'script'),
('1042', '1353', 'pjField', '1', 'title', 'Date to', 'script'),
('1043', '1353', 'pjField', '2', 'title', 'Date to', 'script'),
('1044', '1353', 'pjField', '3', 'title', 'Date to', 'script'),
('1045', '1354', 'pjField', '1', 'title', 'Start on', 'script'),
('1046', '1354', 'pjField', '2', 'title', 'Start on', 'script'),
('1047', '1354', 'pjField', '3', 'title', 'Start on', 'script'),
('1048', '1355', 'pjField', '1', 'title', 'Min nights', 'script'),
('1049', '1355', 'pjField', '2', 'title', 'Min nights', 'script'),
('1050', '1355', 'pjField', '3', 'title', 'Min nights', 'script'),
('1051', '1356', 'pjField', '1', 'title', 'Max nights', 'script'),
('1052', '1356', 'pjField', '2', 'title', 'Max nights', 'script'),
('1053', '1356', 'pjField', '3', 'title', 'Max nights', 'script'),
('1054', '1357', 'pjField', '1', 'title', 'Any day', 'script'),
('1055', '1357', 'pjField', '2', 'title', 'Any day', 'script'),
('1056', '1357', 'pjField', '3', 'title', 'Any day', 'script'),
('1057', '1358', 'pjField', '1', 'title', 'Select a Room', 'script'),
('1058', '1358', 'pjField', '2', 'title', 'Select a Room', 'script'),
('1059', '1358', 'pjField', '3', 'title', 'Select a Room', 'script'),
('1060', '1359', 'pjField', '1', 'title', '+ Add Limit', 'script'),
('1061', '1359', 'pjField', '2', 'title', '+ Add Limit', 'script'),
('1062', '1359', 'pjField', '3', 'title', '+ Add Limit', 'script'),
('1063', '1360', 'pjField', '1', 'title', 'Package', 'script'),
('1064', '1360', 'pjField', '2', 'title', 'Package', 'script'),
('1065', '1360', 'pjField', '3', 'title', 'Package', 'script'),
('1066', '1361', 'pjField', '1', 'title', 'Free night', 'script'),
('1067', '1361', 'pjField', '2', 'title', 'Free night', 'script'),
('1068', '1361', 'pjField', '3', 'title', 'Free night', 'script'),
('1069', '1362', 'pjField', '1', 'title', 'Promo code', 'script'),
('1070', '1362', 'pjField', '2', 'title', 'Promo code', 'script'),
('1071', '1362', 'pjField', '3', 'title', 'Promo code', 'script'),
('1072', '1363', 'pjField', '1', 'title', '+ Add Promo code', 'script'),
('1073', '1363', 'pjField', '2', 'title', '+ Add Promo code', 'script'),
('1074', '1363', 'pjField', '3', 'title', '+ Add Promo code', 'script'),
('1075', '1364', 'pjField', '1', 'title', '+ Add Free night', 'script'),
('1076', '1364', 'pjField', '2', 'title', '+ Add Free night', 'script'),
('1077', '1364', 'pjField', '3', 'title', '+ Add Free night', 'script'),
('1078', '1365', 'pjField', '1', 'title', '+ Add Package', 'script'),
('1079', '1365', 'pjField', '2', 'title', '+ Add Package', 'script'),
('1080', '1365', 'pjField', '3', 'title', '+ Add Package', 'script'),
('1081', '1366', 'pjField', '1', 'title', 'Amount', 'script'),
('1082', '1366', 'pjField', '2', 'title', 'Amount', 'script'),
('1083', '1366', 'pjField', '3', 'title', 'Amount', 'script'),
('1084', '1367', 'pjField', '1', 'title', 'Percent', 'script'),
('1085', '1367', 'pjField', '2', 'title', 'Percent', 'script'),
('1086', '1367', 'pjField', '3', 'title', 'Percent', 'script'),
('1087', '1368', 'pjField', '1', 'title', 'Type', 'script'),
('1088', '1368', 'pjField', '2', 'title', 'Type', 'script'),
('1089', '1368', 'pjField', '3', 'title', 'Type', 'script'),
('1090', '1369', 'pjField', '1', 'title', 'Discount', 'script'),
('1091', '1369', 'pjField', '2', 'title', 'Discount', 'script'),
('1092', '1369', 'pjField', '3', 'title', 'Discount', 'script'),
('1093', '1370', 'pjField', '1', 'title', 'Promo code', 'script'),
('1094', '1370', 'pjField', '2', 'title', 'Promo code', 'script'),
('1095', '1370', 'pjField', '3', 'title', 'Promo code', 'script'),
('1096', '1371', 'pjField', '1', 'title', 'Min length', 'script'),
('1097', '1371', 'pjField', '2', 'title', 'Min length', 'script'),
('1098', '1371', 'pjField', '3', 'title', 'Min length', 'script'),
('1099', '1372', 'pjField', '1', 'title', 'Max length', 'script'),
('1100', '1372', 'pjField', '2', 'title', 'Max length', 'script'),
('1101', '1372', 'pjField', '3', 'title', 'Max length', 'script'),
('1102', '1373', 'pjField', '1', 'title', 'Free nights', 'script'),
('1103', '1373', 'pjField', '2', 'title', 'Free nights', 'script'),
('1104', '1373', 'pjField', '3', 'title', 'Free nights', 'script'),
('1105', '1374', 'pjField', '1', 'title', 'Start day', 'script'),
('1106', '1374', 'pjField', '2', 'title', 'Start day', 'script'),
('1107', '1374', 'pjField', '3', 'title', 'Start day', 'script'),
('1108', '1375', 'pjField', '1', 'title', 'End day', 'script'),
('1109', '1375', 'pjField', '2', 'title', 'End day', 'script'),
('1110', '1375', 'pjField', '3', 'title', 'End day', 'script'),
('1111', '1376', 'pjField', '1', 'title', 'Total price', 'script'),
('1112', '1376', 'pjField', '2', 'title', 'Total price', 'script'),
('1113', '1376', 'pjField', '3', 'title', 'Total price', 'script'),
('1114', '1377', 'pjField', '1', 'title', 'General', 'script'),
('1115', '1377', 'pjField', '2', 'title', 'General', 'script'),
('1116', '1377', 'pjField', '3', 'title', 'General', 'script'),
('1117', '1378', 'pjField', '1', 'title', 'Payments', 'script'),
('1118', '1378', 'pjField', '2', 'title', 'Payments', 'script'),
('1119', '1378', 'pjField', '3', 'title', 'Payments', 'script'),
('1120', '1379', 'pjField', '1', 'title', 'Booking Form', 'script'),
('1121', '1379', 'pjField', '2', 'title', 'Booking Form', 'script'),
('1122', '1379', 'pjField', '3', 'title', 'Booking Form', 'script'),
('1123', '1380', 'pjField', '1', 'title', 'Terms', 'script'),
('1124', '1380', 'pjField', '2', 'title', 'Terms', 'script'),
('1125', '1380', 'pjField', '3', 'title', 'Terms', 'script'),
('1126', '1381', 'pjField', '1', 'title', 'Confirmation', 'script'),
('1127', '1381', 'pjField', '2', 'title', 'Confirmation', 'script'),
('1128', '1381', 'pjField', '3', 'title', 'Confirmation', 'script'),
('1129', '1382', 'pjField', '1', 'title', 'Address', 'script'),
('1130', '1382', 'pjField', '3', 'title', 'Address', 'script'),
('1131', '1384', 'pjField', '1', 'title', 'Captcha', 'script'),
('1132', '1384', 'pjField', '3', 'title', 'Captcha', 'script'),
('1133', '1386', 'pjField', '1', 'title', 'City', 'script'),
('1134', '1386', 'pjField', '3', 'title', 'City', 'script'),
('1135', '1387', 'pjField', '1', 'title', 'Email', 'script'),
('1136', '1387', 'pjField', '3', 'title', 'Email', 'script'),
('1137', '1388', 'pjField', '1', 'title', 'First Name', 'script'),
('1138', '1388', 'pjField', '3', 'title', 'First Name', 'script'),
('1139', '1389', 'pjField', '1', 'title', 'Notes', 'script'),
('1140', '1389', 'pjField', '3', 'title', 'Notes', 'script'),
('1141', '1390', 'pjField', '1', 'title', 'Phone', 'script'),
('1142', '1390', 'pjField', '3', 'title', 'Phone', 'script'),
('1143', '1391', 'pjField', '1', 'title', 'State', 'script'),
('1144', '1391', 'pjField', '3', 'title', 'State', 'script'),
('1145', '1392', 'pjField', '1', 'title', 'Terms', 'script'),
('1146', '1392', 'pjField', '3', 'title', 'Terms', 'script'),
('1147', '1393', 'pjField', '1', 'title', 'Zip', 'script'),
('1148', '1393', 'pjField', '3', 'title', 'Zip', 'script'),
('1149', '1382', 'pjField', '2', 'title', 'Address', 'script'),
('1150', '1384', 'pjField', '2', 'title', 'Captcha', 'script'),
('1151', '1386', 'pjField', '2', 'title', 'City', 'script'),
('1152', '1387', 'pjField', '2', 'title', 'Email', 'script'),
('1153', '1388', 'pjField', '2', 'title', 'First Name', 'script'),
('1154', '1389', 'pjField', '2', 'title', 'Notes', 'script'),
('1155', '1390', 'pjField', '2', 'title', 'Phone', 'script'),
('1156', '1391', 'pjField', '2', 'title', 'State', 'script'),
('1157', '1392', 'pjField', '2', 'title', 'Terms', 'script'),
('1158', '1393', 'pjField', '2', 'title', 'Zip', 'script'),
('1159', '1394', 'pjField', '1', 'title', 'Country', 'script'),
('1160', '1394', 'pjField', '2', 'title', 'Country', 'script'),
('1161', '1394', 'pjField', '3', 'title', 'Country', 'script'),
('1162', '1395', 'pjField', '1', 'title', 'Paypal address', 'script'),
('1163', '1395', 'pjField', '3', 'title', 'Paypal address', 'script'),
('1164', '1396', 'pjField', '1', 'title', 'Check this if you want people to be able to make reservations.', 'script'),
('1165', '1396', 'pjField', '3', 'title', 'Check this if you want people to be able to make reservations.', 'script'),
('1166', '1397', 'pjField', '1', 'title', 'Allow payments with Authorize.net', 'script'),
('1167', '1397', 'pjField', '3', 'title', 'Allow payments with Authorize.net', 'script'),
('1168', '1398', 'pjField', '1', 'title', 'Provide Bank account details for wire transfers', 'script'),
('1169', '1398', 'pjField', '3', 'title', 'Provide Bank account details for wire transfers', 'script'),
('1170', '1399', 'pjField', '1', 'title', 'Collect Credit Card details for offline processing', 'script'),
('1171', '1399', 'pjField', '3', 'title', 'Collect Credit Card details for offline processing', 'script'),
('1172', '1400', 'pjField', '1', 'title', 'Allow payments with PayPal', 'script'),
('1173', '1400', 'pjField', '3', 'title', 'Allow payments with PayPal', 'script'),
('1174', '1401', 'pjField', '1', 'title', 'Authorize.net transaction key', 'script'),
('1175', '1401', 'pjField', '3', 'title', 'Authorize.net transaction key', 'script'),
('1176', '1402', 'pjField', '1', 'title', 'Authorize.net merchant ID', 'script'),
('1177', '1402', 'pjField', '3', 'title', 'Authorize.net merchant ID', 'script'),
('1178', '1403', 'pjField', '1', 'title', 'Bank account', 'script'),
('1179', '1403', 'pjField', '3', 'title', 'Bank account', 'script'),
('1180', '1404', 'pjField', '1', 'title', 'Set deposit amount to be collected for each reservation', 'script'),
('1181', '1404', 'pjField', '3', 'title', 'Set deposit amount to be collected for each reservation', 'script'),
('1182', '1405', 'pjField', '1', 'title', 'Check if you want to disable payments and only collect reservation details', 'script'),
('1183', '1405', 'pjField', '3', 'title', 'Check if you want to disable payments and only collect reservation details', 'script'),
('1184', '1406', 'pjField', '1', 'title', 'Reservations and prices will be based on', 'script'),
('1185', '1406', 'pjField', '3', 'title', 'Reservations and prices will be based on', 'script'),
('1186', '1407', 'pjField', '1', 'title', 'Require 100% if the reservations is within X days', 'script'),
('1187', '1407', 'pjField', '3', 'title', 'Require 100% if the reservations is within X days', 'script'),
('1188', '1408', 'pjField', '1', 'title', 'Set a security deposit payment to be collected with each reservation', 'script'),
('1189', '1408', 'pjField', '3', 'title', 'Set a security deposit payment to be collected with each reservation', 'script'),
('1190', '1409', 'pjField', '1', 'title', 'Set the status for new reservations when reservation form is saved', 'script'),
('1191', '1409', 'pjField', '3', 'title', 'Set the status for new reservations when reservation form is saved', 'script'),
('1192', '1410', 'pjField', '1', 'title', 'Set the status for new reservations if payment has been made for it', 'script'),
('1193', '1410', 'pjField', '3', 'title', 'Set the status for new reservations if payment has been made for it', 'script'),
('1194', '1411', 'pjField', '1', 'title', 'Tax amount to be collected for each reservation', 'script'),
('1195', '1411', 'pjField', '3', 'title', 'Tax amount to be collected for each reservation', 'script'),
('1196', '1412', 'pjField', '1', 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
('1197', '1412', 'pjField', '3', 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
('1198', '1413', 'pjField', '1', 'title', 'Authorize.net time zone', 'script'),
('1199', '1413', 'pjField', '3', 'title', 'Authorize.net time zone', 'script'),
('1200', '1395', 'pjField', '2', 'title', 'Paypal address', 'script'),
('1201', '1396', 'pjField', '2', 'title', 'Check this if you want people to be able to make reservations.', 'script'),
('1202', '1397', 'pjField', '2', 'title', 'Allow payments with Authorize.net', 'script'),
('1203', '1398', 'pjField', '2', 'title', 'Provide Bank account details for wire transfers', 'script'),
('1204', '1399', 'pjField', '2', 'title', 'Collect Credit Card details for offline processing', 'script'),
('1205', '1400', 'pjField', '2', 'title', 'Allow payments with PayPal', 'script'),
('1206', '1401', 'pjField', '2', 'title', 'Authorize.net transaction key', 'script'),
('1207', '1402', 'pjField', '2', 'title', 'Authorize.net merchant ID', 'script'),
('1208', '1403', 'pjField', '2', 'title', 'Bank account', 'script'),
('1209', '1404', 'pjField', '2', 'title', 'Set deposit amount to be collected for each reservation', 'script'),
('1210', '1405', 'pjField', '2', 'title', 'Check if you want to disable payments and only collect reservation details', 'script'),
('1211', '1406', 'pjField', '2', 'title', 'Reservations and prices will be based on', 'script'),
('1212', '1407', 'pjField', '2', 'title', 'Require 100% if the reservations is within X days', 'script'),
('1213', '1408', 'pjField', '2', 'title', 'Set a security deposit payment to be collected with each reservation', 'script'),
('1214', '1409', 'pjField', '2', 'title', 'Set the status for new reservations when reservation form is saved', 'script'),
('1215', '1410', 'pjField', '2', 'title', 'Set the status for new reservations if payment has been made for it', 'script'),
('1216', '1411', 'pjField', '2', 'title', 'Tax amount to be collected for each reservation', 'script'),
('1217', '1412', 'pjField', '2', 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
('1218', '1413', 'pjField', '2', 'title', 'Authorize.net time zone', 'script'),
('1219', '1414', 'pjField', '1', 'title', 'New reservation received', 'script'),
('1220', '1414', 'pjField', '2', 'title', 'New reservation received', 'script'),
('1221', '1414', 'pjField', '3', 'title', 'New reservation received', 'script'),
('1222', '1415', 'pjField', '1', 'title', 'Reservation cancelled', 'script'),
('1223', '1415', 'pjField', '2', 'title', 'Reservation cancelled', 'script'),
('1224', '1415', 'pjField', '3', 'title', 'Reservation cancelled', 'script'),
('1225', '1416', 'pjField', '1', 'title', 'Password reminder', 'script'),
('1226', '1416', 'pjField', '2', 'title', 'Password reminder', 'script'),
('1227', '1416', 'pjField', '3', 'title', 'Password reminder', 'script'),
('1228', '1417', 'pjField', '1', 'title', 'Booking terms URL', 'script'),
('1229', '1417', 'pjField', '2', 'title', 'Booking terms URL', 'script'),
('1230', '1417', 'pjField', '3', 'title', 'Booking terms URL', 'script'),
('1231', '1418', 'pjField', '1', 'title', 'Booking terms content', 'script'),
('1232', '1418', 'pjField', '2', 'title', 'Booking terms content', 'script'),
('1233', '1418', 'pjField', '3', 'title', 'Booking terms content', 'script'),
('1234', '1419', 'pjField', '1', 'title', 'Booking form', 'script'),
('1235', '1419', 'pjField', '2', 'title', 'Booking form', 'script'),
('1236', '1419', 'pjField', '3', 'title', 'Booking form', 'script'),
('1237', '1420', 'pjField', '1', 'title', 'Confirmation', 'script'),
('1238', '1420', 'pjField', '2', 'title', 'Confirmation', 'script'),
('1239', '1420', 'pjField', '3', 'title', 'Confirmation', 'script'),
('1240', '1421', 'pjField', '1', 'title', 'Terms and Confirmations', 'script'),
('1241', '1421', 'pjField', '2', 'title', 'Terms and Confirmations', 'script'),
('1242', '1421', 'pjField', '3', 'title', 'Terms and Confirmations', 'script'),
('1243', '1422', 'pjField', '1', 'title', 'Choose the fields that should be available on the booking form.', 'script'),
('1244', '1422', 'pjField', '2', 'title', 'Choose the fields that should be available on the booking form.', 'script'),
('1245', '1422', 'pjField', '3', 'title', 'Choose the fields that should be available on the booking form.', 'script'),
('1246', '1423', 'pjField', '1', 'title', 'Email notifications will be sent to people who make a reservation after reservation form is completed or/and payment is made. If you leave subject field blank no email will be sent. You can use tokens in the email messages to personalize them.<br /><br /><br /><table width="100%" border="0" cellspacing="0" cellpadding="0">  <tbody><tr>    <td width="50%" valign="top"><p>{Title} - customer title;<br />      {FirstName} - customer first name;<br />      {LastName} - customer last name; <br />      {Phone} - customer phone number; <br />      {Email} - customer e-mail address; <br />      {ArrivalTime} - arrival time; <br />      {Notes} - additional notes; <br />      {Company} - company; <br />      {Address} - address; <br />      {City} - city; <br />      {State} - state; <br />      {Zip} - zip code; <br />      {Country} - country; <br />{BookingID} - Booking ID; <br />      {DateFrom} - Booking start date; <br />{DateTo} - Booking end date; <br />{Rooms} - selected rooms; <br />{Extras} - selected room extras; </p></td>    <td width="50%" valign="top">{CCType} - CC type; <br />      {CCNum} - CC number; <br />      {CCExpMonth} - CC exp.month; <br />      {CCExpYear} - CC exp.year; <br />      {CCSec} - CC sec. code; <br />      {PaymentMethod} - selected payment method; <br />      {Deposit} - Deposit amount; <br />      {SecurityDeposit} - Security deposit amount; <br />{Tax} - Tax amount; <br />      {Total} - Total amount; <br />      {RoomPrice} - Room(s) price; <br />      {ExtraPrice} - Rooms extras price; <br />      {Discount} - Discount amount; <br />      {CancelURL} - Link for booking cancellation;</td>  </tr></tbody></table>', 'script'),
('1247', '1423', 'pjField', '2', 'title', 'Email notifications will be sent to people who make a reservation after reservation form is completed or/and payment is made. If you leave subject field blank no email will be sent. You can use tokens in the email messages to personalize them.<br /><br /><br /><table width="100%" border="0" cellspacing="0" cellpadding="0">  <tbody><tr>    <td width="50%" valign="top"><p>{Title} - customer title;<br />      {FirstName} - customer first name;<br />      {LastName} - customer last name; <br />      {Phone} - customer phone number; <br />      {Email} - customer e-mail address; <br />      {ArrivalTime} - arrival time; <br />      {Notes} - additional notes; <br />      {Company} - company; <br />      {Address} - address; <br />      {City} - city; <br />      {State} - state; <br />      {Zip} - zip code; <br />      {Country} - country; <br />{BookingID} - Booking ID; <br />      {DateFrom} - Booking start date; <br />{DateTo} - Booking end date; <br />{Rooms} - selected rooms; <br />{Extras} - selected room extras; </p></td>    <td width="50%" valign="top">{CCType} - CC type; <br />      {CCNum} - CC number; <br />      {CCExpMonth} - CC exp.month; <br />      {CCExpYear} - CC exp.year; <br />      {CCSec} - CC sec. code; <br />      {PaymentMethod} - selected payment method; <br />      {Deposit} - Deposit amount; <br />      {SecurityDeposit} - Security deposit amount; <br />{Tax} - Tax amount; <br />      {Total} - Total amount; <br />      {RoomPrice} - Room(s) price; <br />      {ExtraPrice} - Rooms extras price; <br />      {Discount} - Discount amount; <br />      {CancelURL} - Link for booking cancellation;</td>  </tr></tbody></table>', 'script'),
('1248', '1423', 'pjField', '3', 'title', 'Email notifications will be sent to people who make a reservation after reservation form is completed or/and payment is made. If you leave subject field blank no email will be sent. You can use tokens in the email messages to personalize them.<br /><br /><br /><table width="100%" border="0" cellspacing="0" cellpadding="0">  <tbody><tr>    <td width="50%" valign="top"><p>{Title} - customer title;<br />      {FirstName} - customer first name;<br />      {LastName} - customer last name; <br />      {Phone} - customer phone number; <br />      {Email} - customer e-mail address; <br />      {ArrivalTime} - arrival time; <br />      {Notes} - additional notes; <br />      {Company} - company; <br />      {Address} - address; <br />      {City} - city; <br />      {State} - state; <br />      {Zip} - zip code; <br />      {Country} - country; <br />{BookingID} - Booking ID; <br />      {DateFrom} - Booking start date; <br />{DateTo} - Booking end date; <br />{Rooms} - selected rooms; <br />{Extras} - selected room extras; </p></td>    <td width="50%" valign="top">{CCType} - CC type; <br />      {CCNum} - CC number; <br />      {CCExpMonth} - CC exp.month; <br />      {CCExpYear} - CC exp.year; <br />      {CCSec} - CC sec. code; <br />      {PaymentMethod} - selected payment method; <br />      {Deposit} - Deposit amount; <br />      {SecurityDeposit} - Security deposit amount; <br />{Tax} - Tax amount; <br />      {Total} - Total amount; <br />      {RoomPrice} - Room(s) price; <br />      {ExtraPrice} - Rooms extras price; <br />      {Discount} - Discount amount; <br />      {CancelURL} - Link for booking cancellation;</td>  </tr></tbody></table>', 'script'),
('1249', '1424', 'pjField', '1', 'title', 'Enter booking terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
('1250', '1424', 'pjField', '2', 'title', 'Enter booking terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
('1251', '1424', 'pjField', '3', 'title', 'Enter booking terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
('1252', '1425', 'pjField', '1', 'title', 'Define different periods throughout the year and set different booking limits. For example you may want to allow minimum 3 nights bookings during the high season.', 'script'),
('1253', '1425', 'pjField', '2', 'title', 'Define different periods throughout the year and set different booking limits. For example you may want to allow minimum 3 nights bookings during the high season.', 'script'),
('1254', '1425', 'pjField', '3', 'title', 'Define different periods throughout the year and set different booking limits. For example you may want to allow minimum 3 nights bookings during the high season.', 'script'),
('1261', '1430', 'pjField', '1', 'title', 'Max value', 'script'),
('1262', '1430', 'pjField', '2', 'title', 'Max value', 'script'),
('1263', '1430', 'pjField', '3', 'title', 'Max value', 'script'),
('1294', '1431', 'pjField', '1', 'title', 'General options updated!', 'script'),
('1295', '1431', 'pjField', '2', 'title', 'General options updated!', 'script'),
('1296', '1431', 'pjField', '3', 'title', 'General options updated!', 'script'),
('1297', '1432', 'pjField', '1', 'title', 'Booking options updated!', 'script'),
('1298', '1432', 'pjField', '2', 'title', 'Booking options updated!', 'script'),
('1299', '1432', 'pjField', '3', 'title', 'Booking options updated!', 'script'),
('1300', '1433', 'pjField', '1', 'title', 'All the changes made to general options have been saved.', 'script'),
('1301', '1433', 'pjField', '2', 'title', 'All the changes made to general options have been saved.', 'script'),
('1302', '1433', 'pjField', '3', 'title', 'All the changes made to general options have been saved.', 'script'),
('1303', '1434', 'pjField', '1', 'title', 'All the changes made to booking options have been saved.', 'script'),
('1304', '1434', 'pjField', '2', 'title', 'All the changes made to booking options have been saved.', 'script'),
('1305', '1434', 'pjField', '3', 'title', 'All the changes made to booking options have been saved.', 'script'),
('1306', '1435', 'pjField', '1', 'title', 'Booking form options updated!', 'script'),
('1307', '1435', 'pjField', '2', 'title', 'Booking form options updated!', 'script'),
('1308', '1435', 'pjField', '3', 'title', 'Booking form options updated!', 'script'),
('1309', '1436', 'pjField', '1', 'title', 'Confirmation options updated!', 'script'),
('1310', '1436', 'pjField', '2', 'title', 'Confirmation options updated!', 'script'),
('1311', '1436', 'pjField', '3', 'title', 'Confirmation options updated!', 'script'),
('1312', '1437', 'pjField', '1', 'title', 'Terms options updated!', 'script'),
('1313', '1437', 'pjField', '2', 'title', 'Terms options updated!', 'script'),
('1314', '1437', 'pjField', '3', 'title', 'Terms options updated!', 'script'),
('1315', '1438', 'pjField', '1', 'title', 'All the changes made to booking form options have been saved.', 'script'),
('1316', '1438', 'pjField', '2', 'title', 'All the changes made to booking form options have been saved.', 'script'),
('1317', '1438', 'pjField', '3', 'title', 'All the changes made to booking form options have been saved.', 'script'),
('1318', '1439', 'pjField', '1', 'title', 'All the changes made to confirmation options have been saved.', 'script'),
('1319', '1439', 'pjField', '2', 'title', 'All the changes made to confirmation options have been saved.', 'script'),
('1320', '1439', 'pjField', '3', 'title', 'All the changes made to confirmation options have been saved.', 'script'),
('1321', '1440', 'pjField', '1', 'title', 'All the changes made to terms options have been saved.', 'script'),
('1322', '1440', 'pjField', '2', 'title', 'All the changes made to terms options have been saved.', 'script'),
('1323', '1440', 'pjField', '3', 'title', 'All the changes made to terms options have been saved.', 'script'),
('1324', '1441', 'pjField', '1', 'title', 'Payment options updated!', 'script'),
('1325', '1441', 'pjField', '2', 'title', 'Payment options updated!', 'script'),
('1326', '1441', 'pjField', '3', 'title', 'Payment options updated!', 'script'),
('1327', '1442', 'pjField', '1', 'title', 'All the changes made to payment options have been saved.', 'script'),
('1328', '1442', 'pjField', '2', 'title', 'All the changes made to payment options have been saved.', 'script'),
('1329', '1442', 'pjField', '3', 'title', 'All the changes made to payment options have been saved.', 'script'),
('1330', '1444', 'pjField', '1', 'title', 'Find Invoices', 'script'),
('1331', '1444', 'pjField', '2', 'title', 'Find Invoices', 'script'),
('1332', '1444', 'pjField', '3', 'title', 'Find Invoices', 'script'),
('1333', '1445', 'pjField', '1', 'title', 'Invoice Details', 'script'),
('1334', '1445', 'pjField', '2', 'title', 'Invoice Details', 'script'),
('1335', '1445', 'pjField', '3', 'title', 'Invoice Details', 'script'),
('1336', '1443', 'pjField', '1', 'title', 'Create Invoice', 'script'),
('1337', '1443', 'pjField', '2', 'title', 'Create Invoice', 'script'),
('1338', '1443', 'pjField', '3', 'title', 'Create Invoice', 'script'),
('1339', '1446', 'pjField', '1', 'title', 'Unique ID', 'script'),
('1340', '1446', 'pjField', '2', 'title', 'Unique ID', 'script'),
('1341', '1446', 'pjField', '3', 'title', 'Unique ID', 'script'),
('1342', '1447', 'pjField', '1', 'title', 'Room', 'script'),
('1343', '1447', 'pjField', '2', 'title', 'Room', 'script'),
('1344', '1447', 'pjField', '3', 'title', 'Room', 'script'),
('1345', '1448', 'pjField', '1', 'title', 'Package Items', 'script'),
('1346', '1448', 'pjField', '2', 'title', 'Package Items', 'script'),
('1347', '1448', 'pjField', '3', 'title', 'Package Items', 'script'),
('1348', '1449', 'pjField', '1', 'title', 'Price', 'script'),
('1349', '1449', 'pjField', '2', 'title', 'Price', 'script'),
('1350', '1449', 'pjField', '3', 'title', 'Price', 'script'),
('1351', '1450', 'pjField', '1', 'title', 'Add item', 'script'),
('1352', '1450', 'pjField', '2', 'title', 'Add item', 'script'),
('1353', '1450', 'pjField', '3', 'title', 'Add item', 'script'),
('1354', '1451', 'pjField', '1', 'title', 'Please enter the dates of your stay to check availability', 'script'),
('1355', '1451', 'pjField', '2', 'title', 'Please enter the dates of your stay to check availability', 'script'),
('1356', '1451', 'pjField', '3', 'title', 'Please enter the dates of your stay to check availability', 'script'),
('1357', '1452', 'pjField', '1', 'title', 'Check Availability', 'script'),
('1358', '1452', 'pjField', '2', 'title', 'Check Availability', 'script'),
('1359', '1452', 'pjField', '3', 'title', 'Check Availability', 'script'),
('1360', '1453', 'pjField', '1', 'title', 'Check-in date', 'script'),
('1361', '1453', 'pjField', '2', 'title', 'Check-in date', 'script'),
('1362', '1453', 'pjField', '3', 'title', 'Check-in date', 'script'),
('1363', '1454', 'pjField', '1', 'title', 'Check-out date', 'script'),
('1364', '1454', 'pjField', '2', 'title', 'Check-out date', 'script'),
('1365', '1454', 'pjField', '3', 'title', 'Check-out date', 'script'),
('1366', '1455', 'pjField', '1', 'title', 'Adults', 'script'),
('1367', '1455', 'pjField', '2', 'title', 'Adults', 'script'),
('1368', '1455', 'pjField', '3', 'title', 'Adults', 'script'),
('1369', '1456', 'pjField', '1', 'title', 'Children', 'script'),
('1370', '1456', 'pjField', '2', 'title', 'Children', 'script'),
('1371', '1456', 'pjField', '3', 'title', 'Children', 'script'),
('1372', '1457', 'pjField', '1', 'title', 'People', 'script'),
('1373', '1457', 'pjField', '2', 'title', 'People', 'script'),
('1374', '1457', 'pjField', '3', 'title', 'People', 'script'),
('1375', '1458', 'pjField', '1', 'title', 'Rooms', 'script'),
('1376', '1458', 'pjField', '2', 'title', 'Rooms', 'script'),
('1377', '1458', 'pjField', '3', 'title', 'Rooms', 'script'),
('1378', '1459', 'pjField', '1', 'title', 'Price', 'script'),
('1379', '1459', 'pjField', '2', 'title', 'Price', 'script'),
('1380', '1459', 'pjField', '3', 'title', 'Price', 'script'),
('1381', '1460', 'pjField', '1', 'title', 'Not available', 'script'),
('1382', '1460', 'pjField', '2', 'title', 'Not available', 'script'),
('1383', '1460', 'pjField', '3', 'title', 'Not available', 'script'),
('1384', '1461', 'pjField', '1', 'title', 'from', 'script'),
('1385', '1461', 'pjField', '2', 'title', 'from', 'script'),
('1386', '1461', 'pjField', '3', 'title', 'from', 'script'),
('1387', '1462', 'pjField', '1', 'title', 'Available rooms from', 'script'),
('1388', '1462', 'pjField', '2', 'title', 'Available rooms from', 'script'),
('1389', '1462', 'pjField', '3', 'title', 'Available rooms from', 'script'),
('1390', '1463', 'pjField', '1', 'title', 'change dates', 'script'),
('1391', '1463', 'pjField', '2', 'title', 'change dates', 'script'),
('1392', '1463', 'pjField', '3', 'title', 'change dates', 'script'),
('1393', '1464', 'pjField', '1', 'title', 'Book', 'script'),
('1394', '1464', 'pjField', '2', 'title', 'Book', 'script'),
('1395', '1464', 'pjField', '3', 'title', 'Book', 'script'),
('1396', '1465', 'pjField', '1', 'title', 'Back', 'script'),
('1397', '1465', 'pjField', '2', 'title', 'Back', 'script'),
('1398', '1465', 'pjField', '3', 'title', 'Back', 'script'),
('1399', '1466', 'pjField', '1', 'title', 'Rooms not found', 'script'),
('1400', '1466', 'pjField', '2', 'title', 'Rooms not found', 'script'),
('1401', '1466', 'pjField', '3', 'title', 'Rooms not found', 'script'),
('1402', '1467', 'pjField', '1', 'title', 'Room', 'script'),
('1403', '1467', 'pjField', '2', 'title', 'Room', 'script'),
('1404', '1467', 'pjField', '3', 'title', 'Room', 'script'),
('1405', '1468', 'pjField', '1', 'title', 'Continue', 'script'),
('1406', '1468', 'pjField', '2', 'title', 'Continue', 'script'),
('1407', '1468', 'pjField', '3', 'title', 'Continue', 'script'),
('1408', '1469', 'pjField', '1', 'title', 'selected room(s) can accommodate {X} person(s)', 'script'),
('1409', '1469', 'pjField', '2', 'title', 'selected room(s) can accommodate {X} person(s)', 'script'),
('1410', '1469', 'pjField', '3', 'title', 'selected room(s) can accommodate {X} person(s)', 'script'),
('1411', '1470', 'pjField', '1', 'title', 'Select number of adults and children for each room. Price may change and will be calculated based on your selection.', 'script'),
('1412', '1470', 'pjField', '2', 'title', 'Select number of adults and children for each room. Price may change and will be calculated based on your selection.', 'script'),
('1413', '1470', 'pjField', '3', 'title', 'Select number of adults and children for each room. Price may change and will be calculated based on your selection.', 'script'),
('1414', '1471', 'pjField', '1', 'title', 'Personal Details', 'script'),
('1415', '1471', 'pjField', '2', 'title', 'Personal Details', 'script'),
('1416', '1471', 'pjField', '3', 'title', 'Personal Details', 'script'),
('1417', '1472', 'pjField', '1', 'title', 'Billing Address', 'script'),
('1418', '1472', 'pjField', '2', 'title', 'Billing Address', 'script'),
('1419', '1472', 'pjField', '3', 'title', 'Billing Address', 'script'),
('1420', '1473', 'pjField', '1', 'title', 'Payment Method', 'script'),
('1421', '1473', 'pjField', '2', 'title', 'Payment Method', 'script'),
('1422', '1473', 'pjField', '3', 'title', 'Payment Method', 'script'),
('1423', '1474', 'pjField', '1', 'title', 'Terms and Conditions', 'script'),
('1424', '1474', 'pjField', '2', 'title', 'Terms and Conditions', 'script'),
('1425', '1474', 'pjField', '3', 'title', 'Terms and Conditions', 'script'),
('1426', '1475', 'pjField', '1', 'title', 'Select Title', 'script'),
('1427', '1475', 'pjField', '2', 'title', 'Select Title', 'script'),
('1428', '1475', 'pjField', '3', 'title', 'Select Title', 'script'),
('1429', '1476', 'pjField', '1', 'title', 'Select Country', 'script'),
('1430', '1476', 'pjField', '2', 'title', 'Select Country', 'script'),
('1431', '1476', 'pjField', '3', 'title', 'Select Country', 'script'),
('1432', '1477', 'pjField', '1', 'title', 'Select Payment method', 'script'),
('1433', '1477', 'pjField', '2', 'title', 'Select Payment method', 'script'),
('1434', '1477', 'pjField', '3', 'title', 'Select Payment method', 'script'),
('1435', '1480', 'pjField', '1', 'title', 'I have read and agree to the Booking Conditions', 'script'),
('1436', '1480', 'pjField', '2', 'title', 'I have read and agree to the Booking Conditions', 'script'),
('1437', '1480', 'pjField', '3', 'title', 'I have read and agree to the Booking Conditions', 'script'),
('1438', '1481', 'pjField', '1', 'title', 'Read terms and conditions', 'script'),
('1439', '1481', 'pjField', '2', 'title', 'Read terms and conditions', 'script'),
('1440', '1481', 'pjField', '3', 'title', 'Read terms and conditions', 'script'),
('1441', '1482', 'pjField', '1', 'title', 'Preview Booking', 'script'),
('1442', '1482', 'pjField', '2', 'title', 'Preview Booking', 'script'),
('1443', '1482', 'pjField', '3', 'title', 'Preview Booking', 'script'),
('1444', '1483', 'pjField', '1', 'title', 'Confirm Booking', 'script'),
('1445', '1483', 'pjField', '2', 'title', 'Confirm Booking', 'script'),
('1446', '1483', 'pjField', '3', 'title', 'Confirm Booking', 'script'),
('1447', '1484', 'pjField', '1', 'title', 'Last Name', 'script'),
('1448', '1484', 'pjField', '2', 'title', 'Last Name', 'script'),
('1449', '1484', 'pjField', '3', 'title', 'Last Name', 'script'),
('1450', '1485', 'pjField', '1', 'title', 'Title', 'script'),
('1451', '1485', 'pjField', '2', 'title', 'Title', 'script'),
('1452', '1485', 'pjField', '3', 'title', 'Title', 'script'),
('1453', '1486', 'pjField', '1', 'title', 'Arrival Time', 'script'),
('1454', '1486', 'pjField', '2', 'title', 'Arrival Time', 'script'),
('1455', '1486', 'pjField', '3', 'title', 'Arrival Time', 'script'),
('1456', '1487', 'pjField', '1', 'title', 'Company', 'script'),
('1457', '1487', 'pjField', '2', 'title', 'Company', 'script'),
('1458', '1487', 'pjField', '3', 'title', 'Company', 'script'),
('1459', '1488', 'pjField', '1', 'title', 'Select CC Type', 'script'),
('1460', '1488', 'pjField', '2', 'title', 'Select CC Type', 'script'),
('1461', '1488', 'pjField', '3', 'title', 'Select CC Type', 'script'),
('1462', '1489', 'pjField', '1', 'title', 'Human Verification', 'script'),
('1463', '1489', 'pjField', '2', 'title', 'Human Verification', 'script'),
('1464', '1489', 'pjField', '3', 'title', 'Human Verification', 'script'),
('1465', '1490', 'pjField', '1', 'title', 'Captcha', 'script'),
('1466', '1490', 'pjField', '2', 'title', 'Captcha', 'script'),
('1467', '1490', 'pjField', '3', 'title', 'Captcha', 'script'),
('1468', '1491', 'pjField', '1', 'title', 'Checkout', 'script'),
('1469', '1491', 'pjField', '2', 'title', 'Checkout', 'script'),
('1470', '1491', 'pjField', '3', 'title', 'Checkout', 'script'),
('1471', '1492', 'pjField', '1', 'title', 'Your Booking', 'script'),
('1472', '1492', 'pjField', '2', 'title', 'Your Booking', 'script'),
('1473', '1492', 'pjField', '3', 'title', 'Your Booking', 'script'),
('1474', '1493', 'pjField', '1', 'title', 'Extras', 'script'),
('1475', '1493', 'pjField', '2', 'title', 'Extras', 'script'),
('1476', '1493', 'pjField', '3', 'title', 'Extras', 'script'),
('1477', '1494', 'pjField', '1', 'title', 'change', 'script'),
('1478', '1494', 'pjField', '2', 'title', 'change', 'script'),
('1479', '1494', 'pjField', '3', 'title', 'change', 'script'),
('1480', '1495', 'pjField', '1', 'title', 'Booking conditions', 'script'),
('1481', '1495', 'pjField', '2', 'title', 'Booking conditions', 'script'),
('1482', '1495', 'pjField', '3', 'title', 'Booking conditions', 'script'),
('1483', '1496', 'pjField', '1', 'title', 'For', 'script'),
('1484', '1496', 'pjField', '2', 'title', 'For', 'script'),
('1485', '1496', 'pjField', '3', 'title', 'For', 'script'),
('1486', '1497', 'pjField', '1', 'title', 'Max persons per room', 'script'),
('1487', '1497', 'pjField', '2', 'title', 'Max persons per room', 'script'),
('1488', '1497', 'pjField', '3', 'title', 'Max persons per room', 'script'),
('1489', '1498', 'pjField', '1', 'title', 'Room(s) Price', 'script'),
('1490', '1498', 'pjField', '2', 'title', 'Room(s) Price', 'script'),
('1491', '1498', 'pjField', '3', 'title', 'Room(s) Price', 'script'),
('1492', '1499', 'pjField', '1', 'title', 'Extras Price', 'script'),
('1493', '1499', 'pjField', '2', 'title', 'Extras Price', 'script'),
('1494', '1499', 'pjField', '3', 'title', 'Extras Price', 'script'),
('1495', '1500', 'pjField', '1', 'title', 'Tax', 'script'),
('1496', '1500', 'pjField', '2', 'title', 'Tax', 'script'),
('1497', '1500', 'pjField', '3', 'title', 'Tax', 'script'),
('1498', '1501', 'pjField', '1', 'title', 'Total', 'script'),
('1499', '1501', 'pjField', '2', 'title', 'Total', 'script'),
('1500', '1501', 'pjField', '3', 'title', 'Total', 'script'),
('1501', '1502', 'pjField', '1', 'title', 'Deposit required', 'script'),
('1502', '1502', 'pjField', '2', 'title', 'Deposit required', 'script'),
('1503', '1502', 'pjField', '3', 'title', 'Deposit required', 'script'),
('1504', '1503', 'pjField', '1', 'title', 'night', 'script'),
('1505', '1503', 'pjField', '2', 'title', 'night', 'script'),
('1506', '1503', 'pjField', '3', 'title', 'night', 'script'),
('1507', '1504', 'pjField', '1', 'title', 'room', 'script'),
('1508', '1504', 'pjField', '2', 'title', 'room', 'script'),
('1509', '1504', 'pjField', '3', 'title', 'room', 'script'),
('1510', '1505', 'pjField', '1', 'title', 'rooms', 'script'),
('1511', '1505', 'pjField', '2', 'title', 'rooms', 'script'),
('1512', '1505', 'pjField', '3', 'title', 'rooms', 'script'),
('1513', '1506', 'pjField', '1', 'title', 'nights', 'script'),
('1514', '1506', 'pjField', '2', 'title', 'nights', 'script'),
('1515', '1506', 'pjField', '3', 'title', 'nights', 'script'),
('1516', '1507', 'pjField', '1', 'title', 'st', 'script'),
('1517', '1507', 'pjField', '2', 'title', 'st', 'script'),
('1518', '1507', 'pjField', '3', 'title', 'st', 'script'),
('1519', '1508', 'pjField', '1', 'title', 'nd', 'script'),
('1520', '1508', 'pjField', '2', 'title', 'nd', 'script'),
('1521', '1508', 'pjField', '3', 'title', 'nd', 'script'),
('1522', '1509', 'pjField', '1', 'title', 'rd', 'script'),
('1523', '1509', 'pjField', '2', 'title', 'rd', 'script'),
('1524', '1509', 'pjField', '3', 'title', 'rd', 'script'),
('1525', '1510', 'pjField', '1', 'title', 'th', 'script'),
('1526', '1510', 'pjField', '2', 'title', 'th', 'script'),
('1527', '1510', 'pjField', '3', 'title', 'th', 'script'),
('1528', '1511', 'pjField', '1', 'title', 'to', 'script'),
('1529', '1511', 'pjField', '2', 'title', 'to', 'script'),
('1530', '1511', 'pjField', '3', 'title', 'to', 'script'),
('1531', '1512', 'pjField', '1', 'title', 'Room(s) price', 'script'),
('1532', '1512', 'pjField', '2', 'title', 'Room(s) price', 'script'),
('1533', '1512', 'pjField', '3', 'title', 'Room(s) price', 'script'),
('1534', '1513', 'pjField', '1', 'title', 'Extra(s) price', 'script'),
('1535', '1513', 'pjField', '2', 'title', 'Extra(s) price', 'script'),
('1536', '1513', 'pjField', '3', 'title', 'Extra(s) price', 'script'),
('1537', '1514', 'pjField', '1', 'title', 'Sorry, but the Room''s list can''t be displayed because there are missing or incorrect parameters. Please return back to the Search form.', 'script'),
('1538', '1514', 'pjField', '2', 'title', 'Sorry, but the Room''s list can''t be displayed because there are missing or incorrect parameters. Please return back to the Search form.', 'script'),
('1539', '1514', 'pjField', '3', 'title', 'Sorry, but the Room''s list can''t be displayed because there are missing or incorrect parameters. Please return back to the Search form.', 'script'),
('1540', '1515', 'pjField', '1', 'title', 'Sorry, but extras can''t be displayed because there are missing or incorrect parameters. Please return back to our room list.', 'script'),
('1541', '1515', 'pjField', '2', 'title', 'Sorry, but extras can''t be displayed because there are missing or incorrect parameters. Please return back to our room list.', 'script'),
('1542', '1515', 'pjField', '3', 'title', 'Sorry, but extras can''t be displayed because there are missing or incorrect parameters. Please return back to our room list.', 'script'),
('1543', '1516', 'pjField', '1', 'title', 'Sorry, but the Checkout form can''t be displayed because there are missing or incorrect parameters. Please return back to the Extra''s page.', 'script'),
('1544', '1516', 'pjField', '2', 'title', 'Sorry, but the Checkout form can''t be displayed because there are missing or incorrect parameters. Please return back to the Extra''s page.', 'script'),
('1545', '1516', 'pjField', '3', 'title', 'Sorry, but the Checkout form can''t be displayed because there are missing or incorrect parameters. Please return back to the Extra''s page.', 'script'),
('1546', '1517', 'pjField', '1', 'title', 'Sorry, but the Preview form can''t be displayed because there are missing or incorrect parameters. Please return back to the Checkout form.', 'script'),
('1547', '1517', 'pjField', '2', 'title', 'Sorry, but the Preview form can''t be displayed because there are missing or incorrect parameters. Please return back to the Checkout form.', 'script'),
('1548', '1517', 'pjField', '3', 'title', 'Sorry, but the Preview form can''t be displayed because there are missing or incorrect parameters. Please return back to the Checkout form.', 'script'),
('1549', '1518', 'pjField', '1', 'title', 'Checkout form has been submitted.', 'script'),
('1550', '1518', 'pjField', '2', 'title', 'Checkout form has been submitted.', 'script'),
('1551', '1518', 'pjField', '3', 'title', 'Checkout form has been submitted.', 'script'),
('1552', '1519', 'pjField', '1', 'title', 'Missing parameters.', 'script'),
('1553', '1519', 'pjField', '2', 'title', 'Missing parameters.', 'script'),
('1554', '1519', 'pjField', '3', 'title', 'Missing parameters.', 'script'),
('1555', '1520', 'pjField', '1', 'title', 'Missing or wrong captcha.', 'script'),
('1556', '1520', 'pjField', '2', 'title', 'Missing or wrong captcha.', 'script'),
('1557', '1520', 'pjField', '3', 'title', 'Missing or wrong captcha.', 'script'),
('1558', '1521', 'pjField', '1', 'title', 'Booking contains invalid data.', 'script'),
('1559', '1521', 'pjField', '2', 'title', 'Booking contains invalid data.', 'script'),
('1560', '1521', 'pjField', '3', 'title', 'Booking contains invalid data.', 'script'),
('1561', '1522', 'pjField', '1', 'title', 'Booking has not been stored.', 'script'),
('1562', '1522', 'pjField', '2', 'title', 'Booking has not been stored.', 'script'),
('1563', '1522', 'pjField', '3', 'title', 'Booking has not been stored.', 'script'),
('1564', '1523', 'pjField', '1', 'title', 'Booking has been stored.', 'script'),
('1565', '1523', 'pjField', '2', 'title', 'Booking has been stored.', 'script'),
('1566', '1523', 'pjField', '3', 'title', 'Booking has been stored.', 'script'),
('1567', '1524', 'pjField', '1', 'title', 'Your booking has been stored and sent successfully. Thank you.', 'script'),
('1568', '1524', 'pjField', '2', 'title', 'Your booking has been stored and sent successfully. Thank you.', 'script'),
('1569', '1524', 'pjField', '3', 'title', 'Your booking has been stored and sent successfully. Thank you.', 'script'),
('1570', '1525', 'pjField', '1', 'title', 'Please wait while redirect to secure payment processor webpage complete. If your browser does not redirect in 3 seconds, click on the button below.', 'script'),
('1571', '1525', 'pjField', '2', 'title', 'Please wait while redirect to secure payment processor webpage complete. If your browser does not redirect in 3 seconds, click on the button below.', 'script'),
('1572', '1525', 'pjField', '3', 'title', 'Please wait while redirect to secure payment processor webpage complete. If your browser does not redirect in 3 seconds, click on the button below.', 'script'),
('1573', '1526', 'pjField', '1', 'title', 'Hotel Booking', 'script'),
('1574', '1526', 'pjField', '2', 'title', 'Hotel Booking', 'script'),
('1575', '1526', 'pjField', '3', 'title', 'Hotel Booking', 'script'),
('1576', '1527', 'pjField', '1', 'title', 'Hotel Booking', 'script'),
('1577', '1527', 'pjField', '2', 'title', 'Hotel Booking', 'script'),
('1578', '1527', 'pjField', '3', 'title', 'Hotel Booking', 'script'),
('1579', '1528', 'pjField', '1', 'title', 'Go to PayPal Secure page', 'script'),
('1580', '1528', 'pjField', '2', 'title', 'Go to PayPal Secure page', 'script'),
('1581', '1528', 'pjField', '3', 'title', 'Go to PayPal Secure page', 'script'),
('1582', '1529', 'pjField', '1', 'title', 'Go to Authorize.NET Secure page', 'script'),
('1583', '1529', 'pjField', '2', 'title', 'Go to Authorize.NET Secure page', 'script'),
('1584', '1529', 'pjField', '3', 'title', 'Go to Authorize.NET Secure page', 'script'),
('1585', '1530', 'pjField', '1', 'title', 'selected rooms for', 'script'),
('1586', '1530', 'pjField', '2', 'title', 'selected rooms for', 'script'),
('1587', '1530', 'pjField', '3', 'title', 'selected rooms for', 'script'),
('1588', '1531', 'pjField', '1', 'title', 'Bank account', 'script'),
('1589', '1531', 'pjField', '2', 'title', 'Bank account', 'script'),
('1590', '1531', 'pjField', '3', 'title', 'Bank account', 'script'),
('1591', '1563', 'pjField', '1', 'title', 'Add a Room', 'script'),
('1592', '1563', 'pjField', '2', 'title', 'Add a Room', 'script'),
('1593', '1563', 'pjField', '3', 'title', 'Add a Room', 'script'),
('1594', '1564', 'pjField', '1', 'title', 'Enter name and description for the room (e.g. Single room, Double room, Studio). You can also specify number of adults and children the room can accommodate plus the number of  available rooms from this room type. Once you add the room you will be able to upload photos.', 'script'),
('1595', '1564', 'pjField', '2', 'title', 'Enter name and description for the room (e.g. Single room, Double room, Studio). You can also specify number of adults and children the room can accommodate plus the number of  available rooms from this room type. Once you add the room you will be able to upload photos.', 'script'),
('1596', '1564', 'pjField', '3', 'title', 'Enter name and description for the room (e.g. Single room, Double room, Studio). You can also specify number of adults and children the room can accommodate plus the number of  available rooms from this room type. Once you add the room you will be able to upload photos.', 'script'),
('1597', '1565', 'pjField', '1', 'title', 'Apply Code', 'script'),
('1598', '1565', 'pjField', '2', 'title', 'Apply Code', 'script'),
('1599', '1565', 'pjField', '3', 'title', 'Apply Code', 'script'),
('1600', '1566', 'pjField', '1', 'title', 'Last login', 'script'),
('1601', '1566', 'pjField', '2', 'title', 'Last login', 'script'),
('1602', '1566', 'pjField', '3', 'title', 'Last login', 'script'),
('1603', '1567', 'pjField', '1', 'title', 'nights', 'script'),
('1604', '1567', 'pjField', '2', 'title', 'nights', 'script'),
('1605', '1567', 'pjField', '3', 'title', 'nights', 'script'),
('1606', '1568', 'pjField', '1', 'title', 'night', 'script'),
('1607', '1568', 'pjField', '2', 'title', 'night', 'script'),
('1608', '1568', 'pjField', '3', 'title', 'night', 'script'),
('1609', '1569', 'pjField', '1', 'title', 'day', 'script'),
('1610', '1569', 'pjField', '2', 'title', 'day', 'script'),
('1611', '1569', 'pjField', '3', 'title', 'day', 'script'),
('1612', '1570', 'pjField', '1', 'title', 'client bookings<br>today', 'script'),
('1613', '1570', 'pjField', '2', 'title', 'client bookings<br>today', 'script'),
('1614', '1570', 'pjField', '3', 'title', 'client bookings<br>today', 'script'),
('1615', '1571', 'pjField', '1', 'title', 'client booking<br>today', 'script'),
('1616', '1571', 'pjField', '2', 'title', 'client booking<br>today', 'script'),
('1617', '1571', 'pjField', '3', 'title', 'client booking<br>today', 'script'),
('1618', '1572', 'pjField', '1', 'title', 'rooms available<br>today', 'script'),
('1619', '1572', 'pjField', '2', 'title', 'rooms available<br>today', 'script'),
('1620', '1572', 'pjField', '3', 'title', 'rooms available<br>today', 'script'),
('1621', '1573', 'pjField', '1', 'title', 'room available<br>today', 'script'),
('1622', '1573', 'pjField', '2', 'title', 'room available<br>today', 'script'),
('1623', '1573', 'pjField', '3', 'title', 'room available<br>today', 'script'),
('1624', '1574', 'pjField', '1', 'title', 'booked rooms<br>today', 'script'),
('1625', '1574', 'pjField', '2', 'title', 'booked rooms<br>today', 'script'),
('1626', '1574', 'pjField', '3', 'title', 'booked rooms<br>today', 'script'),
('1627', '1575', 'pjField', '1', 'title', 'booked room<br>today', 'script'),
('1628', '1575', 'pjField', '2', 'title', 'booked room<br>today', 'script'),
('1629', '1575', 'pjField', '3', 'title', 'booked room<br>today', 'script'),
('1630', '1576', 'pjField', '1', 'title', 'Discount', 'script'),
('1631', '1576', 'pjField', '2', 'title', 'Discount', 'script'),
('1632', '1576', 'pjField', '3', 'title', 'Discount', 'script'),
('1633', '1577', 'pjField', '1', 'title', 'Promo code', 'script'),
('1634', '1577', 'pjField', '2', 'title', 'Promo code', 'script'),
('1635', '1577', 'pjField', '3', 'title', 'Promo code', 'script'),
('1636', '1578', 'pjField', '1', 'title', 'Discount', 'script'),
('1637', '1578', 'pjField', '2', 'title', 'Discount', 'script'),
('1638', '1578', 'pjField', '3', 'title', 'Discount', 'script'),
('1639', '1811', 'pjField', '1', 'title', 'Cancel', 'script'),
('1640', '1811', 'pjField', '2', 'title', 'Cancel', 'script'),
('1641', '1811', 'pjField', '3', 'title', 'Cancel', 'script'),
('1642', '1812', 'pjField', '1', 'title', 'Child', 'script'),
('1643', '1812', 'pjField', '2', 'title', 'Child', 'script'),
('1644', '1812', 'pjField', '3', 'title', 'Child', 'script'),
('1645', '1813', 'pjField', '1', 'title', 'Adult', 'script'),
('1646', '1813', 'pjField', '2', 'title', 'Adult', 'script'),
('1647', '1813', 'pjField', '3', 'title', 'Adult', 'script'),
('1648', '1814', 'pjField', '1', 'title', 'edit room(s)', 'script'),
('1649', '1814', 'pjField', '2', 'title', 'edit room(s)', 'script'),
('1650', '1814', 'pjField', '3', 'title', 'edit room(s)', 'script'),
('1651', '1815', 'pjField', '1', 'title', 'change rooms', 'script'),
('1652', '1815', 'pjField', '2', 'title', 'change rooms', 'script'),
('1653', '1815', 'pjField', '3', 'title', 'change rooms', 'script'),
('1654', '1816', 'pjField', '1', 'title', 'Security', 'script'),
('1655', '1816', 'pjField', '2', 'title', 'Security', 'script'),
('1656', '1816', 'pjField', '3', 'title', 'Security', 'script'),
('1657', '1817', 'pjField', '1', 'title', 'Booking Details', 'script'),
('1658', '1817', 'pjField', '2', 'title', 'Booking Details', 'script'),
('1659', '1817', 'pjField', '3', 'title', 'Booking Details', 'script'),
('1660', '1818', 'pjField', '1', 'title', 'Step 1 (Required)', 'script'),
('1661', '1818', 'pjField', '2', 'title', 'Step 1 (Required)', 'script'),
('1662', '1818', 'pjField', '3', 'title', 'Step 1 (Required)', 'script'),
('1663', '1819', 'pjField', '1', 'title', 'Step 2 (Optional) - for SEO purposes and better ranking you need to put next meta tag into the HEAD part of your page', 'script'),
('1664', '1819', 'pjField', '2', 'title', 'Step 2 (Optional) - for SEO purposes and better ranking you need to put next meta tag into the HEAD part of your page', 'script'),
('1665', '1819', 'pjField', '3', 'title', 'Step 2 (Optional) - for SEO purposes and better ranking you need to put next meta tag into the HEAD part of your page', 'script'),
('1666', '1820', 'pjField', '1', 'title', 'Step 3 (Optional) - In the text box below enter the page file name where the booking engine is placed. Then grab the generated code and put it in your .htaccess file. You need to put the .htaccess file in the same folder where your web page is. ', 'script'),
('1667', '1820', 'pjField', '2', 'title', 'Step 3 (Optional) - In the text box below enter the page file name where the booking engine is placed. Then grab the generated code and put it in your .htaccess file. You need to put the .htaccess file in the same folder where your web page is. ', 'script'),
('1668', '1820', 'pjField', '3', 'title', 'Step 3 (Optional) - In the text box below enter the page file name where the booking engine is placed. Then grab the generated code and put it in your .htaccess file. You need to put the .htaccess file in the same folder where your web page is. ', 'script'),
('1669', '1821', 'pjField', '1', 'title', 'Install code', 'script'),
('1670', '1821', 'pjField', '2', 'title', 'Install code', 'script'),
('1671', '1821', 'pjField', '3', 'title', 'Install code', 'script'),
('1672', '1822', 'pjField', '1', 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
('1673', '1822', 'pjField', '2', 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
('1674', '1822', 'pjField', '3', 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
('1675', '1823', 'pjField', '1', 'title', 'Language options', 'script'),
('1676', '1823', 'pjField', '2', 'title', 'Language options', 'script'),
('1677', '1823', 'pjField', '3', 'title', 'Language options', 'script'),
('1678', '1824', 'pjField', '1', 'title', 'Language', 'script'),
('1679', '1824', 'pjField', '2', 'title', 'Language', 'script'),
('1680', '1824', 'pjField', '3', 'title', 'Language', 'script'),
('1681', '1825', 'pjField', '1', 'title', 'Security', 'script'),
('1682', '1825', 'pjField', '2', 'title', 'Security', 'script'),
('1683', '1825', 'pjField', '3', 'title', 'Security', 'script'),
('1684', '1826', 'pjField', '1', 'title', 'In order to manage prices, please select a room.', 'script'),
('1685', '1826', 'pjField', '2', 'title', 'In order to manage prices, please select a room.', 'script'),
('1686', '1826', 'pjField', '3', 'title', 'In order to manage prices, please select a room.', 'script'),
('1687', '1827', 'pjField', '1', 'title', 'Select a room', 'script'),
('1688', '1827', 'pjField', '2', 'title', 'Select a room', 'script'),
('1689', '1827', 'pjField', '3', 'title', 'Select a room', 'script'),
('1690', '1828', 'pjField', '1', 'title', 'You can use the Limits feature to define certain limits for all the bookings made by your clients. For example you may want to limit "Double room" bookings to be at least 2 nights long if booking start on Friday during summer season. Or you may want to allow maximum 30 days long bookings. Just click on the "Add limit" button and fill in the form.', 'script'),
('1691', '1828', 'pjField', '2', 'title', 'You can use the Limits feature to define certain limits for all the bookings made by your clients. For example you may want to limit "Double room" bookings to be at least 2 nights long if booking start on Friday during summer season. Or you may want to allow maximum 30 days long bookings. Just click on the "Add limit" button and fill in the form.', 'script'),
('1692', '1828', 'pjField', '3', 'title', 'You can use the Limits feature to define certain limits for all the bookings made by your clients. For example you may want to limit "Double room" bookings to be at least 2 nights long if booking start on Friday during summer season. Or you may want to allow maximum 30 days long bookings. Just click on the "Add limit" button and fill in the form.', 'script'),
('1693', '1829', 'pjField', '1', 'title', 'Set booking limites', 'script'),
('1694', '1829', 'pjField', '2', 'title', 'Set booking limites', 'script'),
('1695', '1829', 'pjField', '3', 'title', 'Set booking limites', 'script'),
('1696', '1830', 'pjField', '1', 'title', 'Free night offers', 'script'),
('1697', '1830', 'pjField', '2', 'title', 'Free night offers', 'script'),
('1698', '1830', 'pjField', '3', 'title', 'Free night offers', 'script'),
('1699', '1831', 'pjField', '1', 'title', 'You can create a free night promotion for bookings made during a specific period and with a certain length. Just click on the "Add Free night" button and fill in the form.', 'script'),
('1700', '1831', 'pjField', '2', 'title', 'You can create a free night promotion for bookings made during a specific period and with a certain length. Just click on the "Add Free night" button and fill in the form.', 'script'),
('1701', '1831', 'pjField', '3', 'title', 'You can create a free night promotion for bookings made during a specific period and with a certain length. Just click on the "Add Free night" button and fill in the form.', 'script'),
('1702', '1832', 'pjField', '1', 'title', 'Promo codes', 'script'),
('1703', '1832', 'pjField', '2', 'title', 'Promo codes', 'script'),
('1704', '1832', 'pjField', '3', 'title', 'Promo codes', 'script'),
('1705', '1833', 'pjField', '1', 'title', 'Create different promo codes for any room during certain time of the year. The promo code can be either in % or fixed amount. Just click on the "Add Promo code" button and fill in the form.', 'script'),
('1706', '1833', 'pjField', '2', 'title', 'Create different promo codes for any room during certain time of the year. The promo code can be either in % or fixed amount. Just click on the "Add Promo code" button and fill in the form.', 'script'),
('1707', '1833', 'pjField', '3', 'title', 'Create different promo codes for any room during certain time of the year. The promo code can be either in % or fixed amount. Just click on the "Add Promo code" button and fill in the form.', 'script'),
('1708', '1834', 'pjField', '1', 'title', 'Packages', 'script'),
('1709', '1834', 'pjField', '2', 'title', 'Packages', 'script'),
('1710', '1834', 'pjField', '3', 'title', 'Packages', 'script'),
('1711', '1835', 'pjField', '1', 'title', 'You can create different packages and set custom price for it. For example make a weekend "Double room" package with a fixed price during high season. Just click on the "Add package" button and fill in the form.', 'script'),
('1712', '1835', 'pjField', '2', 'title', 'You can create different packages and set custom price for it. For example make a weekend "Double room" package with a fixed price during high season. Just click on the "Add package" button and fill in the form.', 'script'),
('1713', '1835', 'pjField', '3', 'title', 'You can create different packages and set custom price for it. For example make a weekend "Double room" package with a fixed price during high season. Just click on the "Add package" button and fill in the form.', 'script'),
('1714', '1836', 'pjField', '1', 'title', 'Update room', 'script'),
('1715', '1836', 'pjField', '2', 'title', 'Update room', 'script'),
('1716', '1836', 'pjField', '3', 'title', 'Update room', 'script'),
('1717', '1837', 'pjField', '1', 'title', 'Update name and description for the room (e.g. Single room, Double room, Studio). You can also specify number of adults and children the room can accommodate plus the number of  available rooms from this room type. Below you can upload photos for your room.', 'script'),
('1718', '1837', 'pjField', '2', 'title', 'Update name and description for the room (e.g. Single room, Double room, Studio). You can also specify number of adults and children the room can accommodate plus the number of  available rooms from this room type. Below you can upload photos for your room.', 'script'),
('1719', '1837', 'pjField', '3', 'title', 'Update name and description for the room (e.g. Single room, Double room, Studio). You can also specify number of adults and children the room can accommodate plus the number of  available rooms from this room type. Below you can upload photos for your room.', 'script'),
('1720', '1838', 'pjField', '1', 'title', 'General options', 'script'),
('1721', '1838', 'pjField', '2', 'title', 'General options', 'script'),
('1722', '1838', 'pjField', '3', 'title', 'General options', 'script'),
('1723', '1839', 'pjField', '1', 'title', 'Configure general option for your booking system. If you want to send all notifications using SMTP method you need to have login details for it.', 'script'),
('1724', '1839', 'pjField', '2', 'title', 'Configure general option for your booking system. If you want to send all notifications using SMTP method you need to have login details for it.', 'script'),
('1725', '1839', 'pjField', '3', 'title', 'Configure general option for your booking system. If you want to send all notifications using SMTP method you need to have login details for it.', 'script'),
('1726', '1840', 'pjField', '1', 'title', 'Ðžptions', 'script'),
('1727', '1840', 'pjField', '2', 'title', 'Ðžptions', 'script'),
('1728', '1840', 'pjField', '3', 'title', 'Ðžptions', 'script'),
('1729', '1841', 'pjField', '1', 'title', 'Set different booking options for your hotel booking engine.', 'script'),
('1730', '1841', 'pjField', '2', 'title', 'Set different booking options for your hotel booking engine.', 'script'),
('1731', '1841', 'pjField', '3', 'title', 'Set different booking options for your hotel booking engine.', 'script'),
('1732', '1842', 'pjField', '1', 'title', 'Payments', 'script'),
('1733', '1842', 'pjField', '2', 'title', 'Payments', 'script'),
('1734', '1842', 'pjField', '3', 'title', 'Payments', 'script'),
('1735', '1843', 'pjField', '1', 'title', 'Set different payment options for your booking engine. Enable or disable the available payment processing companies.', 'script'),
('1736', '1843', 'pjField', '2', 'title', 'Set different payment options for your booking engine. Enable or disable the available payment processing companies.', 'script'),
('1737', '1843', 'pjField', '3', 'title', 'Set different payment options for your booking engine. Enable or disable the available payment processing companies.', 'script'),
('1738', '1844', 'pjField', '1', 'title', 'No client bookings today.', 'script'),
('1739', '1844', 'pjField', '2', 'title', 'No client bookings today.', 'script'),
('1740', '1844', 'pjField', '3', 'title', 'No client bookings today.', 'script'),
('1741', '1846', 'pjField', '1', 'title', 'No available rooms today.', 'script'),
('1742', '1846', 'pjField', '2', 'title', 'No available rooms today.', 'script'),
('1743', '1846', 'pjField', '3', 'title', 'No available rooms today.', 'script'),
('1744', '1847', 'pjField', '1', 'title', 'No booked rooms today.', 'script'),
('1745', '1847', 'pjField', '2', 'title', 'No booked rooms today.', 'script'),
('1746', '1847', 'pjField', '3', 'title', 'No booked rooms today.', 'script'),
('1747', '1848', 'pjField', '1', 'title', 'All', 'script'),
('1748', '1848', 'pjField', '2', 'title', 'All', 'script'),
('1749', '1848', 'pjField', '3', 'title', 'All', 'script'),
('1750', '1849', 'pjField', '1', 'title', 'Client Name', 'script'),
('1751', '1849', 'pjField', '2', 'title', 'Client Name', 'script'),
('1752', '1849', 'pjField', '3', 'title', 'Client Name', 'script'),
('1753', '1850', 'pjField', '1', 'title', 'Client Email', 'script'),
('1754', '1850', 'pjField', '2', 'title', 'Client Email', 'script'),
('1755', '1850', 'pjField', '3', 'title', 'Client Email', 'script'),
('1756', '1851', 'pjField', '1', 'title', 'Room Type', 'script'),
('1757', '1851', 'pjField', '2', 'title', 'Room Type', 'script'),
('1758', '1851', 'pjField', '3', 'title', 'Room Type', 'script'),
('1759', '1852', 'pjField', '1', 'title', 'Booking from / to', 'script'),
('1760', '1852', 'pjField', '2', 'title', 'Booking from / to', 'script'),
('1761', '1852', 'pjField', '3', 'title', 'Booking from / to', 'script'),
('1762', '1853', 'pjField', '1', 'title', 'Booking made between', 'script'),
('1763', '1853', 'pjField', '2', 'title', 'Booking made between', 'script'),
('1764', '1853', 'pjField', '3', 'title', 'Booking made between', 'script'),
('1765', '1854', 'pjField', '1', 'title', 'Price range', 'script'),
('1766', '1854', 'pjField', '2', 'title', 'Price range', 'script'),
('1767', '1854', 'pjField', '3', 'title', 'Price range', 'script'),
('1768', '1855', 'pjField', '1', 'title', 'Subject', 'script'),
('1769', '1855', 'pjField', '2', 'title', 'Subject', 'script'),
('1770', '1855', 'pjField', '3', 'title', 'Subject', 'script'),
('1771', '1856', 'pjField', '1', 'title', 'Email body', 'script'),
('1772', '1856', 'pjField', '2', 'title', 'Email body', 'script'),
('1773', '1856', 'pjField', '3', 'title', 'Email body', 'script'),
('1774', '1858', 'pjField', '1', 'title', 'Client - booking confirmation email', 'script'),
('1775', '1858', 'pjField', '2', 'title', 'Client - booking confirmation email', 'script'),
('1776', '1858', 'pjField', '3', 'title', 'Client - booking confirmation email', 'script'),
('1777', '1859', 'pjField', '1', 'title', 'Client - payment confirmation email', 'script'),
('1778', '1859', 'pjField', '2', 'title', 'Client - payment confirmation email', 'script'),
('1779', '1859', 'pjField', '3', 'title', 'Client - payment confirmation email', 'script'),
('1780', '1860', 'pjField', '1', 'title', 'Admin - booking confirmation email', 'script'),
('1781', '1860', 'pjField', '2', 'title', 'Admin - booking confirmation email', 'script'),
('1782', '1860', 'pjField', '3', 'title', 'Admin - booking confirmation email', 'script'),
('1783', '1861', 'pjField', '1', 'title', 'Admin - payment confirmation email', 'script'),
('1784', '1861', 'pjField', '2', 'title', 'Admin - payment confirmation email', 'script'),
('1785', '1861', 'pjField', '3', 'title', 'Admin - payment confirmation email', 'script'),
('1786', '1862', 'pjField', '1', 'title', 'Authorize.net MD5 Hash value', 'script'),
('1787', '1862', 'pjField', '2', 'title', 'Authorize.net MD5 Hash value', 'script'),
('1788', '1862', 'pjField', '3', 'title', 'Authorize.net MD5 Hash value', 'script'),
('1789', '1863', 'pjField', '1', 'title', 'Invoice Details', 'script'),
('1790', '1863', 'pjField', '2', 'title', 'Invoice Details', 'script'),
('1791', '1863', 'pjField', '3', 'title', 'Invoice Details', 'script'),
('1792', '1864', 'pjField', '1', 'title', 'Invoice', 'script'),
('1793', '1864', 'pjField', '2', 'title', 'Invoice', 'script'),
('1794', '1864', 'pjField', '3', 'title', 'Invoice', 'script'),
('1795', '1865', 'pjField', '1', 'title', 'Balance payment', 'script'),
('1796', '1865', 'pjField', '2', 'title', 'Balance payment', 'script'),
('1797', '1865', 'pjField', '3', 'title', 'Balance payment', 'script'),
('1798', '1866', 'pjField', '1', 'title', '(invalid date)', 'script'),
('1799', '1866', 'pjField', '2', 'title', '(invalid date)', 'script'),
('1800', '1866', 'pjField', '3', 'title', '(invalid date)', 'script'),
('1801', '1867', 'pjField', '1', 'title', '(invalid date/time)', 'script'),
('1802', '1867', 'pjField', '2', 'title', '(invalid date/time)', 'script'),
('1803', '1867', 'pjField', '3', 'title', '(invalid date/time)', 'script'),
('1804', '1868', 'pjField', '1', 'title', '(empty date/time)', 'script'),
('1805', '1868', 'pjField', '2', 'title', '(empty date/time)', 'script'),
('1806', '1868', 'pjField', '3', 'title', '(empty date/time)', 'script'),
('1807', '1869', 'pjField', '1', 'title', '(empty date)', 'script'),
('1808', '1869', 'pjField', '2', 'title', '(empty date)', 'script'),
('1809', '1869', 'pjField', '3', 'title', '(empty date)', 'script'),
('1810', '1870', 'pjField', '1', 'title', 'Currency', 'script'),
('1811', '1870', 'pjField', '2', 'title', 'Currency', 'script'),
('1812', '1870', 'pjField', '3', 'title', 'Currency', 'script'),
('1813', '2113', 'pjField', '1', 'title', 'Rooms', 'script'),
('1814', '2113', 'pjField', '2', 'title', 'Rooms', 'script'),
('1815', '2113', 'pjField', '3', 'title', 'Rooms', 'script'),
('1816', '2114', 'pjField', '1', 'title', 'Below you can view available room types and their count. Under the Add Room tab you can edit a new room type. To Edit a room just click on the edit icon next to it.', 'script'),
('1817', '2114', 'pjField', '2', 'title', 'Below you can view available room types and their count. Under the Add Room tab you can edit a new room type. To Edit a room just click on the edit icon next to it.', 'script'),
('1818', '2114', 'pjField', '3', 'title', 'Below you can view available room types and their count. Under the Add Room tab you can edit a new room type. To Edit a room just click on the edit icon next to it.', 'script'),
('1819', '2115', 'pjField', '1', 'title', 'Availability', 'script'),
('1820', '2115', 'pjField', '2', 'title', 'Availability', 'script'),
('1821', '2115', 'pjField', '3', 'title', 'Availability', 'script'),
('1822', '2116', 'pjField', '1', 'title', 'Availability', 'script'),
('1823', '2116', 'pjField', '2', 'title', 'Availability', 'script'),
('1824', '2116', 'pjField', '3', 'title', 'Availability', 'script'),
('1825', '2117', 'pjField', '1', 'title', 'Below you can see room availability. In each date field you can see booked rooms and available rooms for each room type. (2/8 means that you have 2 booked and 8 available rooms). Click on any date box and bookings for selected date will be loaded below.', 'script'),
('1826', '2117', 'pjField', '2', 'title', 'Below you can see room availability. In each date field you can see booked rooms and available rooms for each room type. (2/8 means that you have 2 booked and 8 available rooms). Click on any date box and bookings for selected date will be loaded below.', 'script'),
('1827', '2117', 'pjField', '3', 'title', 'Below you can see room availability. In each date field you can see booked rooms and available rooms for each room type. (2/8 means that you have 2 booked and 8 available rooms). Click on any date box and bookings for selected date will be loaded below.', 'script'),
('1828', '2118', 'pjField', '1', 'title', 'Previous 30 days', 'script'),
('1829', '2118', 'pjField', '2', 'title', 'Previous 30 days', 'script'),
('1830', '2118', 'pjField', '3', 'title', 'Previous 30 days', 'script'),
('1831', '2119', 'pjField', '1', 'title', 'Next 30 days', 'script'),
('1832', '2119', 'pjField', '2', 'title', 'Next 30 days', 'script'),
('1833', '2119', 'pjField', '3', 'title', 'Next 30 days', 'script'),
('1834', '2120', 'pjField', '1', 'title', 'Date/Time', 'script'),
('1835', '2120', 'pjField', '2', 'title', 'Date/Time', 'script'),
('1836', '2120', 'pjField', '3', 'title', 'Date/Time', 'script'),
('1837', '2121', 'pjField', '1', 'title', 'IP address', 'script'),
('1838', '2121', 'pjField', '2', 'title', 'IP address', 'script'),
('1839', '2121', 'pjField', '3', 'title', 'IP address', 'script'),
('1840', '2122', 'pjField', '1', 'title', 'Email confirmation', 'script'),
('1841', '2122', 'pjField', '2', 'title', 'Email confirmation', 'script'),
('1842', '2122', 'pjField', '3', 'title', 'Email confirmation', 'script'),
('1843', '2123', 'pjField', '1', 'title', 'Email confirmation', 'script'),
('1844', '2123', 'pjField', '2', 'title', 'Email confirmation', 'script'),
('1845', '2123', 'pjField', '3', 'title', 'Email confirmation', 'script'),
('1846', '2124', 'pjField', '1', 'title', 'Subject', 'script'),
('1847', '2124', 'pjField', '2', 'title', 'Subject', 'script'),
('1848', '2124', 'pjField', '3', 'title', 'Subject', 'script'),
('1849', '2125', 'pjField', '1', 'title', 'Message', 'script'),
('1850', '2125', 'pjField', '2', 'title', 'Message', 'script'),
('1851', '2125', 'pjField', '3', 'title', 'Message', 'script'),
('1852', '2126', 'pjField', '1', 'title', 'SEO', 'script'),
('1853', '2126', 'pjField', '2', 'title', 'SEO', 'script'),
('1854', '2126', 'pjField', '3', 'title', 'SEO', 'script'),
('1855', '2127', 'pjField', '1', 'title', 'Hide language selector', 'script'),
('1856', '2127', 'pjField', '2', 'title', 'Hide language selector', 'script'),
('1857', '2127', 'pjField', '3', 'title', 'Hide language selector', 'script'),
('1858', '2128', 'pjField', '1', 'title', 'To better optimize your shopping cart please follow the steps below', 'script'),
('1859', '2128', 'pjField', '2', 'title', 'To better optimize your shopping cart please follow the steps below', 'script'),
('1860', '2128', 'pjField', '3', 'title', 'To better optimize your shopping cart please follow the steps below', 'script'),
('1861', '2129', 'pjField', '1', 'title', 'SEO Optimization', 'script'),
('1862', '2129', 'pjField', '2', 'title', 'SEO Optimization', 'script'),
('1863', '2129', 'pjField', '3', 'title', 'SEO Optimization', 'script'),
('1864', '2130', 'pjField', '1', 'title', 'Step 2. Put the meta tag below between <head> and </head>tags on your web page', 'script'),
('1865', '2130', 'pjField', '2', 'title', 'Step 2. Put the meta tag below between <head> and </head>tags on your web page', 'script'),
('1866', '2130', 'pjField', '3', 'title', 'Step 2. Put the meta tag below between <head> and </head>tags on your web page', 'script'),
('1867', '2131', 'pjField', '1', 'title', 'Step 1. Webpage where your front end shopping cart is', 'script'),
('1868', '2131', 'pjField', '2', 'title', 'Step 1. Webpage where your front end shopping cart is', 'script'),
('1869', '2131', 'pjField', '3', 'title', 'Step 1. Webpage where your front end shopping cart is', 'script'),
('1870', '2132', 'pjField', '1', 'title', 'Step 3. Create .htaccess file (or update existing one) in the folder where your web page is and put the data below in it', 'script'),
('1871', '2132', 'pjField', '2', 'title', 'Step 3. Create .htaccess file (or update existing one) in the folder where your web page is and put the data below in it', 'script'),
('1872', '2132', 'pjField', '3', 'title', 'Step 3. Create .htaccess file (or update existing one) in the folder where your web page is and put the data below in it', 'script'),
('1873', '2133', 'pjField', '1', 'title', 'Promo code not found.', 'script'),
('1874', '2133', 'pjField', '2', 'title', 'Promo code not found.', 'script'),
('1875', '2133', 'pjField', '3', 'title', 'Promo code not found.', 'script'),
('1876', '2134', 'pjField', '1', 'title', 'Allow Cash payments', 'script'),
('1877', '2134', 'pjField', '2', 'title', 'Allow Cash payments', 'script'),
('1878', '2134', 'pjField', '3', 'title', 'Allow Cash payments', 'script'),
('1879', '2135', 'pjField', '1', 'title', 'Cash', 'script'),
('1880', '2135', 'pjField', '2', 'title', 'Cash', 'script'),
('1881', '2135', 'pjField', '3', 'title', 'Cash', 'script'),
('1882', '2136', 'pjField', '1', 'title', 'Profile settings', 'script'),
('1883', '2136', 'pjField', '2', 'title', 'Profile settings', 'script'),
('1884', '2136', 'pjField', '3', 'title', 'Profile settings', 'script'),
('1885', '2137', 'pjField', '1', 'title', 'Use form below to update your profile details.', 'script'),
('1886', '2137', 'pjField', '2', 'title', 'Use form below to update your profile details.', 'script'),
('1887', '2137', 'pjField', '3', 'title', 'Use form below to update your profile details.', 'script'),
('1888', '2138', 'pjField', '1', 'title', 'Latest bookings', 'script'),
('1889', '2138', 'pjField', '2', 'title', 'Latest bookings', 'script'),
('1890', '2138', 'pjField', '3', 'title', 'Latest bookings', 'script'),
('1891', '2139', 'pjField', '1', 'title', 'Available rooms today', 'script'),
('1892', '2139', 'pjField', '2', 'title', 'Available rooms today', 'script'),
('1893', '2139', 'pjField', '3', 'title', 'Available rooms today', 'script'),
('1894', '2140', 'pjField', '1', 'title', 'Booked rooms today', 'script'),
('1895', '2140', 'pjField', '2', 'title', 'Booked rooms today', 'script'),
('1896', '2140', 'pjField', '3', 'title', 'Booked rooms today', 'script'),
('1897', '2141', 'pjField', '1', 'title', 'Room(s) overlap', 'script'),
('1898', '2141', 'pjField', '2', 'title', 'Room(s) overlap', 'script'),
('1899', '2141', 'pjField', '3', 'title', 'Room(s) overlap', 'script'),
('1900', '2142', 'pjField', '1', 'title', 'Rooms that you are trying to book are already occupied.', 'script'),
('1901', '2142', 'pjField', '2', 'title', 'Rooms that you are trying to book are already occupied.', 'script'),
('1902', '2142', 'pjField', '3', 'title', 'Rooms that you are trying to book are already occupied.', 'script'),
('1903', '2143', 'pjField', '1', 'title', 'Email is already taken', 'script'),
('1904', '2143', 'pjField', '2', 'title', 'Email is already taken', 'script'),
('1905', '2143', 'pjField', '3', 'title', 'Email is already taken', 'script'),
('1906', '2144', 'pjField', '1', 'title', 'Sorry but the email address is already taken.', 'script'),
('1907', '2144', 'pjField', '2', 'title', 'Sorry but the email address is already taken.', 'script'),
('1908', '2144', 'pjField', '3', 'title', 'Sorry but the email address is already taken.', 'script'),
('1909', '2145', 'pjField', '1', 'title', 'Missing or invalid data.', 'script'),
('1910', '2145', 'pjField', '2', 'title', 'Missing or invalid data.', 'script'),
('1911', '2145', 'pjField', '3', 'title', 'Missing or invalid data.', 'script'),
('1912', '2146', 'pjField', '1', 'title', 'Profile update error', 'script'),
('1913', '2146', 'pjField', '2', 'title', 'Profile update error', 'script'),
('1914', '2146', 'pjField', '3', 'title', 'Profile update error', 'script'),
('1915', '2147', 'pjField', '1', 'title', 'User update error', 'script'),
('1916', '2147', 'pjField', '2', 'title', 'User update error', 'script'),
('1917', '2147', 'pjField', '3', 'title', 'User update error', 'script'),
('1918', '2148', 'pjField', '1', 'title', 'Sorry but the email address is already taken.', 'script'),
('1919', '2148', 'pjField', '2', 'title', 'Sorry but the email address is already taken.', 'script'),
('1920', '2148', 'pjField', '3', 'title', 'Sorry but the email address is already taken.', 'script'),
('1921', '2149', 'pjField', '1', 'title', 'User error', 'script'),
('1922', '2149', 'pjField', '2', 'title', 'User error', 'script'),
('1923', '2149', 'pjField', '3', 'title', 'User error', 'script'),
('1924', '2150', 'pjField', '1', 'title', 'Missing or invalid data.', 'script'),
('1925', '2150', 'pjField', '2', 'title', 'Missing or invalid data.', 'script'),
('1926', '2150', 'pjField', '3', 'title', 'Missing or invalid data.', 'script'),
('1927', '2151', 'pjField', '1', 'title', 'Emails', 'script'),
('1928', '2151', 'pjField', '2', 'title', 'Emails', 'script'),
('1929', '2151', 'pjField', '3', 'title', 'Emails', 'script'),
('1930', '2152', 'pjField', '1', 'title', 'SMS', 'script'),
('1931', '2152', 'pjField', '2', 'title', 'SMS', 'script'),
('1932', '2152', 'pjField', '3', 'title', 'SMS', 'script'),
('1933', '2153', 'pjField', '1', 'title', 'Admin - booking confirmation sms', 'script'),
('1934', '2153', 'pjField', '2', 'title', 'Admin - booking confirmation sms', 'script'),
('1935', '2153', 'pjField', '3', 'title', 'Admin - booking confirmation sms', 'script'),
('1936', '2154', 'pjField', '1', 'title', 'Admin - payment confirmation sms', 'script'),
('1937', '2154', 'pjField', '2', 'title', 'Admin - payment confirmation sms', 'script'),
('1938', '2154', 'pjField', '3', 'title', 'Admin - payment confirmation sms', 'script'),
('1939', '2155', 'pjField', '1', 'title', 'SMS content', 'script'),
('1940', '2155', 'pjField', '2', 'title', 'SMS content', 'script'),
('1941', '2155', 'pjField', '3', 'title', 'SMS content', 'script'),
('3637', '2452', 'pjField', '1', 'title', 'Layout', 'script'),
('3638', '2452', 'pjField', '2', 'title', 'Layout', 'script'),
('3639', '2452', 'pjField', '3', 'title', 'Layout', 'script'),
('3652', '2453', 'pjField', '1', 'title', 'I want this?', 'script'),
('3653', '2453', 'pjField', '2', 'title', 'I want this?', 'script'),
('3654', '2453', 'pjField', '3', 'title', 'I want this?', 'script'),
('3655', '2454', 'pjField', '1', 'title', 'More Extras', 'script'),
('3656', '2454', 'pjField', '2', 'title', 'More Extras', 'script'),
('3657', '2454', 'pjField', '3', 'title', 'More Extras', 'script'),
('3658', '2455', 'pjField', '1', 'title', 'Image', 'script'),
('3659', '2455', 'pjField', '2', 'title', 'Image', 'script'),
('3660', '2455', 'pjField', '3', 'title', 'Image', 'script'),
('3670', '2456', 'pjField', '1', 'title', 'Delete confirmation', 'script'),
('3671', '2456', 'pjField', '2', 'title', 'Delete confirmation', 'script'),
('3672', '2456', 'pjField', '3', 'title', 'Delete confirmation', 'script'),
('3673', '2457', 'pjField', '1', 'title', 'Are you sure you want to delete selected image?', 'script'),
('3674', '2457', 'pjField', '2', 'title', 'Are you sure you want to delete selected image?', 'script'),
('3675', '2457', 'pjField', '3', 'title', 'Are you sure you want to delete selected image?', 'script'),
('3712', '2458', 'pjField', '1', 'title', 'Show week numbers', 'script'),
('3713', '2458', 'pjField', '2', 'title', 'Show week numbers', 'script'),
('3714', '2458', 'pjField', '3', 'title', 'Show week numbers', 'script'),
('3718', '2459', 'pjField', '1', 'title', 'Sun', 'script'),
('3719', '2459', 'pjField', '2', 'title', 'Sun', 'script'),
('3720', '2459', 'pjField', '3', 'title', 'Sun', 'script'),
('3721', '2460', 'pjField', '1', 'title', 'Sat', 'script'),
('3722', '2460', 'pjField', '2', 'title', 'Sat', 'script'),
('3723', '2460', 'pjField', '3', 'title', 'Sat', 'script'),
('3724', '2461', 'pjField', '1', 'title', 'Mon', 'script'),
('3725', '2461', 'pjField', '2', 'title', 'Mon', 'script'),
('3726', '2461', 'pjField', '3', 'title', 'Mon', 'script'),
('3727', '2462', 'pjField', '1', 'title', 'Tue', 'script'),
('3728', '2462', 'pjField', '2', 'title', 'Tue', 'script'),
('3729', '2462', 'pjField', '3', 'title', 'Tue', 'script'),
('3730', '2463', 'pjField', '1', 'title', 'Wed', 'script'),
('3731', '2463', 'pjField', '2', 'title', 'Wed', 'script'),
('3732', '2463', 'pjField', '3', 'title', 'Wed', 'script'),
('3733', '2464', 'pjField', '1', 'title', 'Thu', 'script'),
('3734', '2464', 'pjField', '2', 'title', 'Thu', 'script'),
('3735', '2464', 'pjField', '3', 'title', 'Thu', 'script'),
('3736', '2465', 'pjField', '1', 'title', 'Fri', 'script'),
('3737', '2465', 'pjField', '2', 'title', 'Fri', 'script'),
('3738', '2465', 'pjField', '3', 'title', 'Fri', 'script'),
('3765', '2466', 'pjField', '1', 'title', 'Prev month', 'script'),
('3766', '2466', 'pjField', '2', 'title', 'Prev month', 'script'),
('3767', '2466', 'pjField', '3', 'title', 'Prev month', 'script'),
('3768', '2467', 'pjField', '1', 'title', 'Next month', 'script'),
('3769', '2467', 'pjField', '2', 'title', 'Next month', 'script'),
('3770', '2467', 'pjField', '3', 'title', 'Next month', 'script'),
('3771', '2468', 'pjField', '1', 'title', 'More Rooms +', 'script'),
('3772', '2468', 'pjField', '2', 'title', 'More Rooms +', 'script'),
('3773', '2468', 'pjField', '3', 'title', 'More Rooms +', 'script'),
('3774', '2469', 'pjField', '1', 'title', 'Click on the calendar above to select arrival date', 'script'),
('3775', '2469', 'pjField', '2', 'title', 'Click on the calendar above to select arrival date', 'script'),
('3776', '2469', 'pjField', '3', 'title', 'Click on the calendar above to select arrival date', 'script'),
('3777', '2470', 'pjField', '1', 'title', 'Nights', 'script'),
('3778', '2470', 'pjField', '2', 'title', 'Nights', 'script'),
('3779', '2470', 'pjField', '3', 'title', 'Nights', 'script'),
('3780', '2471', 'pjField', '1', 'title', 'Children', 'script'),
('3781', '2471', 'pjField', '2', 'title', 'Children', 'script'),
('3782', '2471', 'pjField', '3', 'title', 'Children', 'script'),
('3783', '2472', 'pjField', '1', 'title', 'Adults', 'script'),
('3784', '2472', 'pjField', '2', 'title', 'Adults', 'script'),
('3785', '2472', 'pjField', '3', 'title', 'Adults', 'script'),
('3786', '2473', 'pjField', '1', 'title', 'Check in date', 'script'),
('3787', '2473', 'pjField', '2', 'title', 'Check in date', 'script'),
('3788', '2473', 'pjField', '3', 'title', 'Check in date', 'script'),
('3789', '2474', 'pjField', '1', 'title', 'Max.nights (Layout 2)', 'script'),
('3790', '2474', 'pjField', '2', 'title', 'Max.nights (Layout 2)', 'script'),
('3791', '2474', 'pjField', '3', 'title', 'Max.nights (Layout 2)', 'script'),
('3795', '2475', 'pjField', '1', 'title', 'Promo Code', 'script'),
('3796', '2475', 'pjField', '2', 'title', 'Promo Code', 'script'),
('3797', '2475', 'pjField', '3', 'title', 'Promo Code', 'script'),
('3798', '2476', 'pjField', '1', 'title', 'Apply', 'script'),
('3799', '2476', 'pjField', '2', 'title', 'Apply', 'script'),
('3800', '2476', 'pjField', '3', 'title', 'Apply', 'script'),
('3801', '2477', 'pjField', '1', 'title', 'N/A', 'script'),
('3802', '2477', 'pjField', '2', 'title', 'N/A', 'script'),
('3803', '2477', 'pjField', '3', 'title', 'N/A', 'script'),
('3804', '2478', 'pjField', '1', 'title', 'Details', 'script'),
('3805', '2478', 'pjField', '2', 'title', 'Details', 'script'),
('3806', '2478', 'pjField', '3', 'title', 'Details', 'script'),
('3807', '2479', 'pjField', '1', 'title', 'Client', 'script'),
('3808', '2479', 'pjField', '2', 'title', 'Client', 'script'),
('3809', '2479', 'pjField', '3', 'title', 'Client', 'script'),
('3810', '2480', 'pjField', '1', 'title', 'Booking update', 'script'),
('3811', '2480', 'pjField', '2', 'title', 'Booking update', 'script'),
('3812', '2480', 'pjField', '3', 'title', 'Booking update', 'script'),
('3813', '2481', 'pjField', '1', 'title', 'Use form below to update booking details.', 'script'),
('3814', '2481', 'pjField', '2', 'title', 'Use form below to update booking details.', 'script'),
('3815', '2481', 'pjField', '3', 'title', 'Use form below to update booking details.', 'script'),
('3816', '2482', 'pjField', '1', 'title', 'Client details', 'script'),
('3817', '2482', 'pjField', '2', 'title', 'Client details', 'script'),
('3818', '2482', 'pjField', '3', 'title', 'Client details', 'script'),
('3819', '2483', 'pjField', '1', 'title', 'Use form below to update client related data.', 'script'),
('3820', '2483', 'pjField', '2', 'title', 'Use form below to update client related data.', 'script'),
('3821', '2483', 'pjField', '3', 'title', 'Use form below to update client related data.', 'script'),
('3822', '2484', 'pjField', '1', 'title', 'Invoice details', 'script'),
('3823', '2484', 'pjField', '2', 'title', 'Invoice details', 'script'),
('3824', '2484', 'pjField', '3', 'title', 'Invoice details', 'script'),
('3825', '2485', 'pjField', '1', 'title', 'Use grid below to organize your invoices.', 'script'),
('3826', '2485', 'pjField', '2', 'title', 'Use grid below to organize your invoices.', 'script'),
('3827', '2485', 'pjField', '3', 'title', 'Use grid below to organize your invoices.', 'script'),
('3828', '2486', 'pjField', '1', 'title', 'Add a booking', 'script'),
('3829', '2486', 'pjField', '2', 'title', 'Add a booking', 'script'),
('3830', '2486', 'pjField', '3', 'title', 'Add a booking', 'script'),
('3831', '2487', 'pjField', '1', 'title', 'Fill in the form below to add a new booking. Under Clients tab you can enter information about the client.', 'script'),
('3832', '2487', 'pjField', '2', 'title', 'Fill in the form below to add a new booking. Under Clients tab you can enter information about the client.', 'script'),
('3833', '2487', 'pjField', '3', 'title', 'Fill in the form below to add a new booking. Under Clients tab you can enter information about the client.', 'script'),
('3834', '2488', 'pjField', '1', 'title', 'Client details', 'script'),
('3835', '2488', 'pjField', '2', 'title', 'Client details', 'script'),
('3836', '2488', 'pjField', '3', 'title', 'Client details', 'script'),
('3837', '2489', 'pjField', '1', 'title', 'Use the form below to enter details about your client.', 'script'),
('3838', '2489', 'pjField', '2', 'title', 'Use the form below to enter details about your client.', 'script'),
('3839', '2489', 'pjField', '3', 'title', 'Use the form below to enter details about your client.', 'script'),
('3840', '2490', 'pjField', '1', 'title', 'Night', 'script'),
('3841', '2490', 'pjField', '2', 'title', 'Night', 'script'),
('3842', '2490', 'pjField', '3', 'title', 'Night', 'script'),
('3843', '2491', 'pjField', '1', 'title', 'Day', 'script'),
('3844', '2491', 'pjField', '2', 'title', 'Day', 'script'),
('3845', '2491', 'pjField', '3', 'title', 'Day', 'script'),
('3846', '2492', 'pjField', '1', 'title', 'Layout', 'script'),
('3847', '2492', 'pjField', '2', 'title', 'Layout', 'script'),
('3848', '2492', 'pjField', '3', 'title', 'Layout', 'script'),
('3849', '2493', 'pjField', '1', 'title', 'Install config', 'script'),
('3850', '2493', 'pjField', '2', 'title', 'Install config', 'script'),
('3851', '2493', 'pjField', '3', 'title', 'Install config', 'script'),
('3852', '2494', 'pjField', '1', 'title', 'Install &amp; Preview', 'script'),
('3853', '2494', 'pjField', '2', 'title', 'Install &amp; Preview', 'script'),
('3854', '2494', 'pjField', '3', 'title', 'Install &amp; Preview', 'script'),
('3888', '2495', 'pjField', '1', 'title', 'Missing, empty or invalid parameters.', 'script'),
('3889', '2495', 'pjField', '2', 'title', 'Missing, empty or invalid parameters.', 'script'),
('3890', '2495', 'pjField', '3', 'title', 'Missing, empty or invalid parameters.', 'script'),
('3891', '2496', 'pjField', '1', 'title', 'Booking with such an ID did not exists.', 'script'),
('3892', '2496', 'pjField', '2', 'title', 'Booking with such an ID did not exists.', 'script'),
('3893', '2496', 'pjField', '3', 'title', 'Booking with such an ID did not exists.', 'script'),
('3894', '2497', 'pjField', '1', 'title', 'Security hash did not match.', 'script'),
('3895', '2497', 'pjField', '2', 'title', 'Security hash did not match.', 'script'),
('3896', '2497', 'pjField', '3', 'title', 'Security hash did not match.', 'script'),
('3897', '2498', 'pjField', '1', 'title', 'Booking is already cancelled.', 'script'),
('3898', '2498', 'pjField', '2', 'title', 'Booking is already cancelled.', 'script'),
('3899', '2498', 'pjField', '3', 'title', 'Booking is already cancelled.', 'script'),
('3900', '2499', 'pjField', '1', 'title', 'Booking has been cancelled successfully.', 'script'),
('3901', '2499', 'pjField', '2', 'title', 'Booking has been cancelled successfully.', 'script'),
('3902', '2499', 'pjField', '3', 'title', 'Booking has been cancelled successfully.', 'script'),
('3903', '2500', 'pjField', '1', 'title', 'Cancel booking', 'script'),
('3904', '2500', 'pjField', '2', 'title', 'Cancel booking', 'script'),
('3905', '2500', 'pjField', '3', 'title', 'Cancel booking', 'script'),
('3906', '2501', 'pjField', '1', 'title', 'Booking Cancellation', 'script'),
('3907', '2501', 'pjField', '2', 'title', 'Booking Cancellation', 'script'),
('3908', '2501', 'pjField', '3', 'title', 'Booking Cancellation', 'script'),
('3909', '2502', 'pjField', '1', 'title', 'Admin - booking cancellation email', 'script'),
('3910', '2502', 'pjField', '2', 'title', 'Admin - booking cancellation email', 'script'),
('3911', '2502', 'pjField', '3', 'title', 'Admin - booking cancellation email', 'script'),
('5628', '2805', 'pjField', '1', 'title', 'Check out date', 'script'),
('5629', '2805', 'pjField', '2', 'title', 'Check out date', 'script'),
('5630', '2805', 'pjField', '3', 'title', 'Check out date', 'script'),
('5631', '2806', 'pjField', '1', 'title', 'Days', 'script'),
('5632', '2806', 'pjField', '2', 'title', 'Days', 'script'),
('5633', '2806', 'pjField', '3', 'title', 'Days', 'script'),
('5634', '2807', 'pjField', '1', 'title', 'days', 'script'),
('5635', '2807', 'pjField', '2', 'title', 'days', 'script'),
('5636', '2807', 'pjField', '3', 'title', 'days', 'script'),
('5637', '2808', 'pjField', '1', 'title', 'day', 'script'),
('5638', '2808', 'pjField', '2', 'title', 'day', 'script'),
('5639', '2808', 'pjField', '3', 'title', 'day', 'script'),
('5661', '2809', 'pjField', '1', 'title', 'You have not selected room. Please, return back.', 'script'),
('5662', '2809', 'pjField', '2', 'title', 'You have not selected room. Please, return back.', 'script'),
('5663', '2809', 'pjField', '3', 'title', 'You have not selected room. Please, return back.', 'script'),
('5664', '2810', 'pjField', '1', 'title', 'Bookings are not accepted. Please, return back.', 'script'),
('5665', '2810', 'pjField', '2', 'title', 'Bookings are not accepted. Please, return back.', 'script'),
('5666', '2810', 'pjField', '3', 'title', 'Bookings are not accepted. Please, return back.', 'script'),
('5667', '2812', 'pjField', '1', 'title', 'Selected rooms are not available. Please, return back.', 'script'),
('5668', '2812', 'pjField', '2', 'title', 'Selected rooms are not available. Please, return back.', 'script'),
('5669', '2812', 'pjField', '3', 'title', 'Selected rooms are not available. Please, return back.', 'script'),
('7371', '3115', 'pjField', '1', 'title', 'per day', 'script'),
('7372', '3115', 'pjField', '2', 'title', 'per day', 'script'),
('7373', '3115', 'pjField', '3', 'title', 'per day', 'script'),
('7374', '3116', 'pjField', '1', 'title', 'per night', 'script'),
('7375', '3116', 'pjField', '2', 'title', 'per night', 'script'),
('7376', '3116', 'pjField', '3', 'title', 'per night', 'script');

--
-- Do not remove below
--
INSERT INTO `hotel_booking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, '1', 'pjCalendar', '1', 'terms_url', '', 'data'),
(NULL, '1', 'pjCalendar', '1', 'terms_body', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin bibendum euismod odio non cursus. Vivamus cursus turpis neque. Integer semper varius eros eu congue. Quisque eu tortor lectus. Vivamus tristique sem a tellus dictum posuere. Curabitur ultrices pharetra est, facilisis tempus nibh suscipit id. Nulla dignissim placerat ipsum. Etiam mattis varius purus, eu posuere sapien condimentum eu. Etiam quam odio, suscipit eget egestas id, ultrices a nisi. Vivamus facilisis sem nec purus dapibus, vel molestie massa hendrerit. Cras accumsan gravida quam, sit amet ornare erat condimentum sed. Fusce adipiscing imperdiet imperdiet. Praesent commodo consectetur suscipit.\r\n\r\nAenean nec leo aliquet dui tristique porta eget quis lectus. Aliquam id pharetra felis. Vestibulum suscipit tellus elit, vitae imperdiet nulla ornare ac. Integer non nibh vitae justo aliquet faucibus. Suspendisse pulvinar tempor dui, porttitor elementum turpis adipiscing non. Nulla massa tellus, suscipit sit amet velit ac, viverra lobortis est. Sed sit amet tristique diam. Duis vel nisi vel dolor euismod feugiat. Proin porttitor eros mi, sed ultrices eros egestas sit amet. Curabitur lacinia euismod nisi et malesuada.\r\n\r\nAliquam scelerisque iaculis nunc nec dictum. Aliquam quis mollis purus. Donec vitae urna mi. Donec quis molestie purus, et condimentum erat. Suspendisse sed enim semper, pretium lorem ut, aliquam metus. Donec aliquam dignissim volutpat. Aenean purus arcu, fermentum sit amet nunc id, venenatis sodales sapien. Nunc non tellus iaculis massa suscipit ullamcorper faucibus a odio. Integer bibendum, nisl vel ullamcorper semper, augue risus lobortis quam, et semper eros sem facilisis lectus. Quisque convallis euismod porta. Duis interdum, nibh vel faucibus varius, odio nulla molestie leo, sed ornare massa odio non lectus. Etiam ornare mi eu sapien scelerisque tempus.', 'data'),
(NULL, '1', 'pjCalendar', '3', 'terms_url', 'https://www.yahoo.com/', 'data'),
(NULL, '1', 'pjCalendar', '3', 'terms_body', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin bibendum euismod odio non cursus. Vivamus cursus turpis neque. Integer semper varius eros eu congue. Quisque eu tortor lectus. Vivamus tristique sem a tellus dictum posuere. Curabitur ultrices pharetra est, facilisis tempus nibh suscipit id. Nulla dignissim placerat ipsum. Etiam mattis varius purus, eu posuere sapien condimentum eu. Etiam quam odio, suscipit eget egestas id, ultrices a nisi. Vivamus facilisis sem nec purus dapibus, vel molestie massa hendrerit. Cras accumsan gravida quam, sit amet ornare erat condimentum sed. Fusce adipiscing imperdiet imperdiet. Praesent commodo consectetur suscipit.\r\n\r\nAenean nec leo aliquet dui tristique porta eget quis lectus. Aliquam id pharetra felis. Vestibulum suscipit tellus elit, vitae imperdiet nulla ornare ac. Integer non nibh vitae justo aliquet faucibus. Suspendisse pulvinar tempor dui, porttitor elementum turpis adipiscing non. Nulla massa tellus, suscipit sit amet velit ac, viverra lobortis est. Sed sit amet tristique diam. Duis vel nisi vel dolor euismod feugiat. Proin porttitor eros mi, sed ultrices eros egestas sit amet. Curabitur lacinia euismod nisi et malesuada.\r\n\r\nAliquam scelerisque iaculis nunc nec dictum. Aliquam quis mollis purus. Donec vitae urna mi. Donec quis molestie purus, et condimentum erat. Suspendisse sed enim semper, pretium lorem ut, aliquam metus. Donec aliquam dignissim volutpat. Aenean purus arcu, fermentum sit amet nunc id, venenatis sodales sapien. Nunc non tellus iaculis massa suscipit ullamcorper faucibus a odio. Integer bibendum, nisl vel ullamcorper semper, augue risus lobortis quam, et semper eros sem facilisis lectus. Quisque convallis euismod porta. Duis interdum, nibh vel faucibus varius, odio nulla molestie leo, sed ornare massa odio non lectus. Etiam ornare mi eu sapien scelerisque tempus.', 'data'),
(NULL, '1', 'pjCalendar', '2', 'terms_url', 'https://www.facebook.com/', 'data'),
(NULL, '1', 'pjCalendar', '2', 'terms_body', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin bibendum euismod odio non cursus. Vivamus cursus turpis neque. Integer semper varius eros eu congue. Quisque eu tortor lectus. Vivamus tristique sem a tellus dictum posuere. Curabitur ultrices pharetra est, facilisis tempus nibh suscipit id. Nulla dignissim placerat ipsum. Etiam mattis varius purus, eu posuere sapien condimentum eu. Etiam quam odio, suscipit eget egestas id, ultrices a nisi. Vivamus facilisis sem nec purus dapibus, vel molestie massa hendrerit. Cras accumsan gravida quam, sit amet ornare erat condimentum sed. Fusce adipiscing imperdiet imperdiet. Praesent commodo consectetur suscipit.\r\n\r\nAenean nec leo aliquet dui tristique porta eget quis lectus. Aliquam id pharetra felis. Vestibulum suscipit tellus elit, vitae imperdiet nulla ornare ac. Integer non nibh vitae justo aliquet faucibus. Suspendisse pulvinar tempor dui, porttitor elementum turpis adipiscing non. Nulla massa tellus, suscipit sit amet velit ac, viverra lobortis est. Sed sit amet tristique diam. Duis vel nisi vel dolor euismod feugiat. Proin porttitor eros mi, sed ultrices eros egestas sit amet. Curabitur lacinia euismod nisi et malesuada.\r\n\r\nAliquam scelerisque iaculis nunc nec dictum. Aliquam quis mollis purus. Donec vitae urna mi. Donec quis molestie purus, et condimentum erat. Suspendisse sed enim semper, pretium lorem ut, aliquam metus. Donec aliquam dignissim volutpat. Aenean purus arcu, fermentum sit amet nunc id, venenatis sodales sapien. Nunc non tellus iaculis massa suscipit ullamcorper faucibus a odio. Integer bibendum, nisl vel ullamcorper semper, augue risus lobortis quam, et semper eros sem facilisis lectus. Quisque convallis euismod porta. Duis interdum, nibh vel faucibus varius, odio nulla molestie leo, sed ornare massa odio non lectus. Etiam ornare mi eu sapien scelerisque tempus.', 'data'),
(NULL, '1', 'pjCalendar', '1', 'confirm_subject_client', 'Booking confirmation', 'data'),
(NULL, '1', 'pjCalendar', '1', 'confirm_tokens_client', 'Thank you for your booking. \r\n\r\nID: {BookingID}\r\n\r\nStart date: {DateFrom}\r\nEnd date: {DateTo}\r\nArrival time: {ArrivalTime}\r\n\r\nRoom and room extras\r\n{Rooms}\r\n{Extras}\r\n\r\nPersonal details\r\nName: {FirstName} {LastName}\r\nPhone: {Phone}\r\nEmail: {Email}\r\n\r\nThis is the price for your booking is\r\nRoom(s) price: {RoomPrice}\r\nRoom extras: {ExtraPrice}\r\nDiscount: {Discount}\r\nTax: {Tax}\r\nTotal: {Total}\r\nSecurity deposit: {SecurityDeposit}\r\nDeposit required to confirm your booking: {Deposit}\r\n\r\nAdditional notes:\r\n{Notes}\r\n\r\nThank you,\r\nHotel Management', 'data'),
(NULL, '1', 'pjCalendar', '1', 'payment_subject_client', 'Payment received', 'data'),
(NULL, '1', 'pjCalendar', '1', 'payment_tokens_client', 'We''ve received the payment for your booking and it is now confirmed.\r\n\r\nID: {BookingID}\r\n\r\nThank you,\r\nHotel Management', 'data'),
(NULL, '1', 'pjCalendar', '3', 'confirm_subject_client', 'Booking confirmation', 'data'),
(NULL, '1', 'pjCalendar', '3', 'confirm_tokens_client', 'Thank you for your booking. \r\n\r\nID: {BookingID}\r\n\r\nStart date: {DateFrom}\r\nEnd date: {DateTo}\r\nArrival time: {ArrivalTime}\r\n\r\nRoom and room extras\r\n{Rooms}\r\n{Extras}\r\n\r\nPersonal details\r\nName: {FirstName} {LastName}\r\nPhone: {Phone}\r\nEmail: {Email}\r\n\r\nThis is the price for your booking is\r\nRoom(s) price: {RoomPrice}\r\nRoom extras: {ExtraPrice}\r\nDiscount: {Discount}\r\nTax: {Tax}\r\nTotal: {Total}\r\nSecurity deposit: {SecurityDeposit}\r\nDeposit required to confirm your booking: {Deposit}\r\n\r\nAdditional notes:\r\n{Notes}\r\n\r\nThank you,\r\nHotel Management', 'data'),
(NULL, '1', 'pjCalendar', '3', 'payment_subject_client', 'Payment received', 'data'),
(NULL, '1', 'pjCalendar', '3', 'payment_tokens_client', 'We''ve received the payment for your booking and it is now confirmed.\r\n\r\nID: {BookingID}\r\n\r\nThank you,\r\nHotel Management', 'data'),
(NULL, '1', 'pjCalendar', '2', 'confirm_subject_client', 'Booking confirmation', 'data'),
(NULL, '1', 'pjCalendar', '2', 'confirm_tokens_client', 'Thank you for your booking. \r\n\r\nID: {BookingID}\r\n\r\nStart date: {DateFrom}\r\nEnd date: {DateTo}\r\nArrival time: {ArrivalTime}\r\n\r\nRoom and room extras\r\n{Rooms}\r\n{Extras}\r\n\r\nPersonal details\r\nName: {FirstName} {LastName}\r\nPhone: {Phone}\r\nEmail: {Email}\r\n\r\nThis is the price for your booking is\r\nRoom(s) price: {RoomPrice}\r\nRoom extras: {ExtraPrice}\r\nDiscount: {Discount}\r\nTax: {Tax}\r\nTotal: {Total}\r\nSecurity deposit: {SecurityDeposit}\r\nDeposit required to confirm your booking: {Deposit}\r\n\r\nAdditional notes:\r\n{Notes}\r\n\r\nThank you,\r\nHotel Management', 'data'),
(NULL, '1', 'pjCalendar', '2', 'payment_subject_client', 'Payment received', 'data'),
(NULL, '1', 'pjCalendar', '2', 'payment_tokens_client', 'We''ve received the payment for your booking and it is now confirmed.\r\n\r\nID: {BookingID}\r\n\r\nThank you,\r\nHotel Management', 'data'),
(NULL, '1', 'pjCalendar', '1', 'confirm_subject_admin', 'New booking received', 'data'),
(NULL, '1', 'pjCalendar', '1', 'confirm_tokens_admin', 'New booking has been made. \r\n\r\nID: {BookingID}\r\n\r\nStart date: {DateFrom}\r\nEnd date: {DateTo}\r\nArrival time: {ArrivalTime}\r\n\r\nRoom and room extras\r\n{Rooms}\r\n{Extras}\r\n\r\nPersonal details\r\nName: {FirstName} {LastName}\r\nPhone: {Phone}\r\nEmail: {Email}\r\n\r\nPrice\r\nRoom(s) price: {RoomPrice}\r\nRoom extras: {ExtraPrice}\r\nDiscount: {Discount}\r\nTax: {Tax}\r\nTotal: {Total}\r\nSecurity deposit: {SecurityDeposit}\r\nDeposit required: {Deposit}\r\n\r\nAdditional notes:\r\n{Notes}', 'data'),
(NULL, '1', 'pjCalendar', '1', 'payment_subject_admin', 'New payment received', 'data'),
(NULL, '1', 'pjCalendar', '1', 'payment_tokens_admin', 'Booking deposit has been paid.\r\n\r\nID: {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '3', 'confirm_subject_admin', 'New booking received', 'data'),
(NULL, '1', 'pjCalendar', '3', 'confirm_tokens_admin', 'New booking has been made. \r\n\r\nID: {BookingID}\r\n\r\nStart date: {DateFrom}\r\nEnd date: {DateTo}\r\nArrival time: {ArrivalTime}\r\n\r\nRoom and room extras\r\n{Rooms}\r\n{Extras}\r\n\r\nPersonal details\r\nName: {FirstName} {LastName}\r\nPhone: {Phone}\r\nEmail: {Email}\r\n\r\nPrice\r\nRoom(s) price: {RoomPrice}\r\nRoom extras: {ExtraPrice}\r\nDiscount: {Discount}\r\nTax: {Tax}\r\nTotal: {Total}\r\nSecurity deposit: {SecurityDeposit}\r\nDeposit required: {Deposit}\r\n\r\nAdditional notes:\r\n{Notes}', 'data'),
(NULL, '1', 'pjCalendar', '3', 'payment_subject_admin', 'New payment received', 'data'),
(NULL, '1', 'pjCalendar', '3', 'payment_tokens_admin', 'Booking deposit has been paid.\r\n\r\nID: {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '2', 'confirm_subject_admin', 'New booking received', 'data'),
(NULL, '1', 'pjCalendar', '2', 'confirm_tokens_admin', 'New booking has been made. \r\n\r\nID: {BookingID}\r\n\r\nStart date: {DateFrom}\r\nEnd date: {DateTo}\r\nArrival time: {ArrivalTime}\r\n\r\nRoom and room extras\r\n{Rooms}\r\n{Extras}\r\n\r\nPersonal details\r\nName: {FirstName} {LastName}\r\nPhone: {Phone}\r\nEmail: {Email}\r\n\r\nPrice\r\nRoom(s) price: {RoomPrice}\r\nRoom extras: {ExtraPrice}\r\nDiscount: {Discount}\r\nTax: {Tax}\r\nTotal: {Total}\r\nSecurity deposit: {SecurityDeposit}\r\nDeposit required: {Deposit}\r\n\r\nAdditional notes:\r\n{Notes}', 'data'),
(NULL, '1', 'pjCalendar', '2', 'payment_subject_admin', 'New payment received', 'data'),
(NULL, '1', 'pjCalendar', '2', 'payment_tokens_admin', 'Booking deposit has been paid.\r\n\r\nID: {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '1', 'confirm_sms_admin', 'New booking received {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '1', 'payment_sms_admin', 'New payment received {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '3', 'confirm_sms_admin', 'New booking received {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '3', 'payment_sms_admin', 'New payment received {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '2', 'confirm_sms_admin', 'New booking received {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '2', 'payment_sms_admin', 'New payment received {BookingID}', 'data'),
(NULL, '1', 'pjCalendar', '1', 'cancel_subject_admin', 'Booking cancelled', 'script'),
(NULL, '1', 'pjCalendar', '1', 'cancel_tokens_admin', 'Booking has been cancelled.\r\n\r\nID: {BookingID}', 'script'),
(NULL, '1', 'pjCalendar', '2', 'cancel_subject_admin', 'Booking cancelled', 'script'),
(NULL, '1', 'pjCalendar', '2', 'cancel_tokens_admin', 'Booking has been cancelled.\r\n\r\nID: {BookingID}', 'script'),
(NULL, '1', 'pjCalendar', '3', 'cancel_subject_admin', 'Booking cancelled', 'script'),
(NULL, '1', 'pjCalendar', '3', 'cancel_tokens_admin', 'Booking has been cancelled.\r\n\r\nID: {BookingID}', 'script');